/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterAbstract;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitorFilterWrapper;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;

public abstract class AbstractFilter
extends FilterAbstract
implements Filter {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");
    protected short filterType;
    protected boolean permissiveConstruction = true;

    protected AbstractFilter(FilterFactory factory) {
        super(factory);
    }

    public final boolean contains(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    protected static boolean isLogicFilter(short filterType) {
        LOGGER.entering("AbstractFilter", "isLogicFilter", new Short(filterType));
        return filterType == 1 || filterType == 2 || filterType == 3;
    }

    protected static boolean isMathFilter(short filterType) {
        return filterType == 15 || filterType == 16 || filterType == 17 || filterType == 18;
    }

    protected static boolean isCompareFilter(short filterType) {
        return AbstractFilter.isMathFilter(filterType) || filterType == 14 || filterType == 19 || filterType == 23;
    }

    protected static boolean isGeometryFilter(short filterType) {
        return filterType == 4 || filterType == 5 || filterType == 6 || filterType == 8 || filterType == 7 || filterType == 9 || filterType == 10 || filterType == 11 || filterType == 12 || filterType == 24 || filterType == 13;
    }

    protected static boolean isGeometryDistanceFilter(short filterType) {
        return filterType == 24 || filterType == 13;
    }

    protected static boolean isSimpleFilter(short filterType) {
        return AbstractFilter.isCompareFilter(filterType) || AbstractFilter.isGeometryFilter(filterType) || filterType == 21 || filterType == 22 || filterType == 20;
    }

    public short getFilterType() {
        return this.filterType;
    }

    public final void accept(FilterVisitor visitor) {
        this.accept(new FilterVisitorFilterWrapper(visitor), null);
    }
}

