/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Geometry;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS = new SimpleFeaturePropertyAccessor();
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS = new DefaultGeometrySimpleFeaturePropertyAccessor();
    static PropertyAccessor FID_ACCESS = new FidSimpleFeaturePropertyAccessor();
    static Pattern idPattern = Pattern.compile("@(\\w+:)?id");
    static Pattern propertyPattern = Pattern.compile("(\\w+:)?(\\w+)");

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (xpath == null) {
            return null;
        }
        if (!SimpleFeature.class.isAssignableFrom(type) && !SimpleFeatureType.class.isAssignableFrom(type)) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (idPattern.matcher(xpath).matches()) {
            return FID_ACCESS;
        }
        if (propertyPattern.matcher(xpath).matches()) {
            return ATTRIBUTE_ACCESS;
        }
        return null;
    }

    static String stripPrefix(String xpath) {
        int split = xpath.indexOf(":");
        if (split != -1) {
            return xpath.substring(split + 1);
        }
        return xpath;
    }

    static class SimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        SimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getAttribute(xpath) != null;
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(xpath) != null;
            }
            return false;
        }

        public Object get(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getAttribute(xpath);
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(xpath);
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof SimpleFeature) {
                ((SimpleFeature)object).setAttribute(xpath, value);
            }
            if (object instanceof SimpleFeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class DefaultGeometrySimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometrySimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof SimpleFeature || object instanceof SimpleFeatureType;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getDefaultGeometry();
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getGeometryDescriptor();
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof SimpleFeature) {
                ((SimpleFeature)object).setDefaultGeometry((Object)((Geometry)value));
            }
            if (object instanceof SimpleFeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class FidSimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        FidSimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof SimpleFeature && xpath.matches("@(\\w+:)?id");
        }

        public Object get(Object object, String xpath, Class target) {
            SimpleFeature feature = (SimpleFeature)object;
            return feature.getID();
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            throw new IllegalAttributeException("feature id is immutable");
        }
    }
}

