/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicFormat.class.toString());
    private static final String SUGGESTED_TILESIZE = "SUGGESTED_TILE_SIZE";
    public static final DefaultParameterDescriptor<String> SUGGESTED_TILE_SIZE = new DefaultParameterDescriptor<String>("SUGGESTED_TILE_SIZE", String.class, null, "");
    public static final String TILE_SIZE_SEPARATOR = ",";
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor<Boolean>("Fading", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
    public static final ParameterDescriptor<Color> INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor<Object>("InputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor<Object>("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Double> INPUT_IMAGE_THRESHOLD_VALUE = new DefaultParameterDescriptor<Double>("InputImageThresholdValue", Double.class, null, new Double(Double.NaN));
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor<Integer>("MaxAllowedTiles", Integer.class, null, Integer.valueOf(Integer.MAX_VALUE));
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor<Boolean>("AllowMultithreading", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor<Object>("BackgroundValues", double[].class, null, null);

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup(new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, INPUT_IMAGE_THRESHOLD_VALUE, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING}));
        this.writeParameters = null;
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object source) {
        try {
            URL sourceURL = ImageMosaicUtils.checkSource(source);
            if (sourceURL == null) {
                return false;
            }
            ShapefileDataStore tileIndexStore = null;
            CoordinateReferenceSystem crs = null;
            try {
                File propertiesFile;
                tileIndexStore = new ShapefileDataStore(sourceURL);
                String[] typeNames = tileIndexStore.getTypeNames();
                if (typeNames.length <= 0) {
                    boolean bl = false;
                    return bl;
                }
                String typeName = typeNames[0];
                FeatureSource featureSource = tileIndexStore.getFeatureSource(typeName);
                SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
                crs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                String temp = URLDecoder.decode(sourceURL.getFile(), "UTF8");
                int index = temp.lastIndexOf(".");
                if (index != -1) {
                    temp = temp.substring(0, index);
                }
                if (!(propertiesFile = new File(new StringBuffer(temp).append(".properties").toString())).exists()) throw new FileNotFoundException("Properties file, descibing the ImageMoasic, does not exist:" + propertiesFile);
                if (!propertiesFile.isFile()) {
                    throw new FileNotFoundException("Properties file, descibing the ImageMoasic, does not exist:" + propertiesFile);
                }
                ImageMosaicUtils.MosaicConfigurationBean props = ImageMosaicUtils.loadPropertiesFile(sourceURL, crs);
                if (props == null) {
                    boolean bl = false;
                    return bl;
                }
                String locationAttributeName = props.getLocationAttribute();
                if (schema.getDescriptor(locationAttributeName) == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                block25: {
                    try {
                        if (tileIndexStore != null) {
                            tileIndexStore.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block25;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        try {
            return new ImageMosaicReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

