/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum PathType {
    RELATIVE{

        File checkPath(String parentLocation, String location) {
            File rasterFile = new File(parentLocation, location);
            if (!PathType.checkFileReadable(rasterFile)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to read image for file " + rasterFile.getAbsolutePath());
                }
                return null;
            }
            return rasterFile;
        }
    }
    ,
    ABSOLUTE{

        File checkPath(String parentLocation, String location) {
            File rasterFile = new File(parentLocation, location);
            if (!PathType.checkFileReadable(rasterFile)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to read image for file " + rasterFile.getAbsolutePath());
                }
                return null;
            }
            return rasterFile;
        }
    };

    private static final Logger LOGGER;

    abstract File checkPath(String var1, String var2);

    private static boolean checkFileReadable(File file) {
        return file.exists() && file.canRead() && file.isFile();
    }

    static {
        LOGGER = Logging.getLogger(PathType.class);
    }
}

