/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ReadType {
    DIRECT_READ{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        RenderedImage read(ImageReadParam readP, int imageChoice, File rasterFile, Rectangle readDimension) throws IOException {
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = 1.getInputStream(rasterFile);
                if (inStream == null) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                reader = 1.getReader(inStream);
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (1.checkSourceRegion(readP, readDimension)) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "reading file: " + rasterFile.getAbsolutePath());
                }
                BufferedImage bufferedImage = reader.read(imageChoice, readP);
                return bufferedImage;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                }
                RenderedImage renderedImage = null;
                return renderedImage;
            }
            finally {
                try {
                    reader.dispose();
                }
                catch (Throwable t) {}
                try {
                    inStream.close();
                }
                catch (Throwable t) {}
            }
        }
    }
    ,
    JAI_IMAGEREAD{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        RenderedImage read(ImageReadParam readP, int imageChoice, File rasterFile, Rectangle readDimension) throws IOException {
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = 2.getInputStream(rasterFile);
                if (inStream == null) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                reader = 2.getReader(inStream);
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (2.checkSourceRegion(readP, readDimension)) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                }
                RenderedImage t = null;
                return t;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable t) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable t) {}
            }
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(rasterFile);
            pbjImageRead.add(imageChoice);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(readP);
            pbjImageRead.add(null);
            RenderedOp raster = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead);
            raster.getWidth();
            return raster;
        }
    }
    ,
    UNSPECIFIED{

        RenderedImage read(ImageReadParam readP, int imageChoice, File rasterFile, Rectangle readDimension) throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    private static final Logger LOGGER;

    static ReadType getDefault() {
        return DIRECT_READ;
    }

    abstract RenderedImage read(ImageReadParam var1, int var2, File var3, Rectangle var4) throws IOException;

    static boolean checkSourceRegion(ImageReadParam readP, Rectangle readDimension) {
        Rectangle sourceRegion = readP.getSourceRegion();
        Rectangle.intersect(sourceRegion, readDimension, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readP.setSourceRegion(sourceRegion);
        return false;
    }

    static void getDimensions(int imageChoice, Rectangle readDimension, Rectangle originalDimension, ImageInputStream inStream, ImageReader reader) throws IOException {
        inStream.reset();
        reader.setInput(inStream);
        originalDimension.setRect(0.0, 0.0, reader.getWidth(0), reader.getHeight(0));
        readDimension.setRect(0.0, 0.0, reader.getWidth(imageChoice), reader.getHeight(imageChoice));
    }

    static void getDimension(int imageChoice, Rectangle readDimension, ImageInputStream inStream, ImageReader reader) throws IOException {
        inStream.reset();
        reader.setInput(inStream);
        readDimension.setRect(0.0, 0.0, reader.getWidth(imageChoice), reader.getHeight(imageChoice));
    }

    static ImageReader getReader(ImageInputStream inStream) {
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        ImageReader reader = readersIt.next();
        return reader;
    }

    static ImageInputStream getInputStream(File rasterFile) throws IOException {
        ImageInputStream inStream = ImageIO.createImageInputStream(rasterFile);
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    static {
        LOGGER = Logging.getLogger(ReadType.class);
    }
}

