/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdalconst.gdalconst;

public abstract class GDALImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.gdalframework");
    private List supportedFormats;

    public List getSupportedFormats() {
        return Collections.unmodifiableList(this.supportedFormats);
    }

    public GDALImageReaderSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String readerClassName, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames, Collection supportedFormats) {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        this.supportedFormats = new ArrayList(supportedFormats);
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Can Decode Input");
        }
        if (input instanceof ImageInputStream) {
            ((ImageInputStream)input).mark();
        }
        if (input instanceof String) {
            input = new File((String)input);
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            input = tempURL.getProtocol().equalsIgnoreCase("file") ? new File(URLDecoder.decode(tempURL.getFile(), "UTF8")) : ((URL)input).openStream();
        }
        if (input instanceof File) {
            input = new FileImageInputStreamExtImpl((File)input);
        }
        boolean isInputDecodable = false;
        try {
            String s = ((FileImageInputStreamExtImpl)input).getFile().getAbsolutePath();
            Dataset ds = GDALUtilities.acquireDataSet(s, gdalconst.GA_ReadOnly);
            isInputDecodable = this.isDecodable(ds);
            GDALUtilities.closeDataSet(ds);
        }
        catch (Exception e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return isInputDecodable;
    }

    protected boolean isDecodable(Dataset dataset) {
        if (dataset != null) {
            Driver driver = dataset.GetDriver();
            String sDriver = driver.getShortName();
            return this.getSupportedFormats().contains(sDriver);
        }
        return false;
    }

    public boolean isAvailable() {
        if (!GDALUtilities.isGDALAvailable()) {
            return false;
        }
        List supportedFormats = this.getSupportedFormats();
        Iterator it = supportedFormats.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            String formatName = (String)it.next();
            if (GDALUtilities.isDriverAvailable(formatName)) continue;
            return false;
        }
        return true;
    }

    public synchronized void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (!GDALUtilities.isGDALAvailable()) {
            IIORegistry iioRegistry = (IIORegistry)registry;
            Class<ImageReaderSpi> spiClass = ImageReaderSpi.class;
            Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
            while (iter.hasNext()) {
                ImageReaderSpi provider = iter.next();
                if (!(provider instanceof GDALImageReaderSpi)) continue;
                registry.deregisterServiceProvider(provider);
            }
        }
    }

    static {
        GDALUtilities.loadGDAL();
    }
}

