/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReader;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class Viewer {
    private static final String newLine = System.getProperty("line.separator");

    private Viewer() {
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 1, index, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, 1, index, true);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 1, 0, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, 1, 0, true);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 2, 0, displayImage);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, 2, 0, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 3, index, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, 3, index, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 3, 0, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, 3, 0, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 12, index, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, 12, index, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 12, 0, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, 12, 0, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 30, index, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, 30, index, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, 30, 0, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, 30, 0, true);
    }

    private static String buildMetadataText(RenderedImage ri, int metadataFields, int index) {
        try {
            String newLine = System.getProperty("line.separator");
            GDALImageReader reader = (GDALImageReader)ri.getProperty("JAI.ImageReader");
            StringBuffer sb = new StringBuffer("");
            switch (metadataFields) {
                case 1: 
                case 30: {
                    sb.append(Viewer.getImageMetadata(reader, index));
                    break;
                }
                case 2: {
                    sb.append(Viewer.getStreamMetadata(reader));
                    break;
                }
                case 3: {
                    sb.append(Viewer.getImageMetadata(reader, index)).append(newLine).append(Viewer.getStreamMetadata(reader));
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String buildCRSProperties(RenderedImage ri, int index) {
        int gcpCount;
        double[] geoTransformations;
        GDALImageReader reader = (GDALImageReader)ri.getProperty("JAI.ImageReader");
        StringBuffer sb = new StringBuffer("CRS Information:").append(newLine);
        String projection = reader.getProjection(index);
        if (!projection.equals("")) {
            sb.append("Projections:").append(projection).append(newLine);
        }
        if ((geoTransformations = reader.getGeoTransform(index)) != null) {
            sb.append("Geo Transformation:").append(newLine);
            sb.append("Origin = (").append(Double.toString(geoTransformations[0])).append(",").append(Double.toString(geoTransformations[3])).append(")").append(newLine).append("Pixel Size = (").append(Double.toString(geoTransformations[1])).append(",").append(Double.toString(geoTransformations[5])).append(")").append(newLine).append(newLine).append("---------- Affine GeoTransformation Coefficients ----------").append(newLine);
            for (int i = 0; i < 6; ++i) {
                sb.append("adfTransformCoeff[").append(i).append("]=").append(Double.toString(geoTransformations[i])).append(newLine);
            }
        }
        if ((gcpCount = reader.getGCPCount(index)) != 0) {
            sb.append(newLine).append("Ground Control Points:").append(newLine).append("Projections:").append(newLine).append(reader.getGCPProjection(index)).append(newLine);
            List gcps = reader.getGCPs(index);
            int size = gcps.size();
            for (int i = 0; i < size; ++i) {
                sb.append("GCP ").append(i + 1).append(gcps.get(i)).append(newLine);
            }
        }
        return sb.toString();
    }

    private static String getImageMetadata(GDALImageReader reader, int index) {
        GDALCommonIIOImageMetadata mt = reader.getDatasetMetadata(index);
        List metadata = GDALUtilities.getGDALImageMetadata(mt.getDatasetName());
        if (metadata != null) {
            int size = metadata.size();
            StringBuffer sb = new StringBuffer("Image Metadata:").append(newLine);
            for (int i = 0; i < size; ++i) {
                sb.append(metadata.get(i)).append(newLine);
            }
            return sb.toString();
        }
        return "Image Metadata not found";
    }

    private static String getStreamMetadata(GDALImageReader reader) throws IOException {
        GDALCommonIIOImageMetadata mt = reader.getDatasetMetadata(reader.getNumImages(true) - 1);
        List metadata = GDALUtilities.getGDALStreamMetadata(mt.getDatasetName());
        if (metadata != null) {
            int size = metadata.size();
            StringBuffer sb = new StringBuffer("Stream Metadata:").append(newLine);
            for (int i = 0; i < size; ++i) {
                sb.append(metadata.get(i)).append(newLine);
            }
            return sb.toString();
        }
        return "Stream Metadata not found";
    }

    private static void visualizeWithTextArea(RenderedImage ri, String title, int textFields, int index, boolean displayImage) {
        StringBuffer sb = new StringBuffer();
        switch (textFields) {
            case 1: {
                sb.append("  Image Metadata from ").append(title);
                break;
            }
            case 2: {
                sb.append("  Stream Metadata");
                break;
            }
            case 3: {
                sb.append("  Metadata from ").append(title);
                break;
            }
            case 12: {
                sb.append("  CRS Information for ").append(title);
                break;
            }
            case 30: {
                sb.append(" Additional Information from ").append(title);
            }
        }
        final JFrame frame = new JFrame(title);
        frame.getContentPane().setLayout(new BorderLayout());
        String textPosition = "First";
        if (displayImage) {
            frame.getContentPane().add((Component)new ScrollingImagePanel(ri, 640, 480));
            textPosition = "Before";
        }
        JLabel label = new JLabel(sb.toString());
        frame.getContentPane().add((Component)label, textPosition);
        JTextArea textArea = new JTextArea();
        if (textFields == 12) {
            textArea.setText(Viewer.buildCRSProperties(ri, index));
        } else if (textFields != 30) {
            textArea.setText(Viewer.buildMetadataText(ri, textFields, index));
        } else {
            textArea.setText(new StringBuffer(Viewer.buildMetadataText(ri, textFields, index).toString()).append(newLine).append(Viewer.buildCRSProperties(ri, index)).toString());
        }
        textArea.setEditable(false);
        frame.getContentPane().add(textArea);
        frame.getContentPane().add((Component)new JScrollPane(textArea), "Last");
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
    }

    public static void visualize(RenderedImage ri) {
        ImageIOUtilities.visualize((RenderedImage)ri);
    }

    public static void visualize(RenderedImage ri, String title) {
        ImageIOUtilities.visualize((RenderedImage)ri, (String)title);
    }

    private class TextType {
        private static final int ONLY_IMAGE_METADATA = 1;
        private static final int ONLY_STREAM_METADATA = 2;
        private static final int STREAM_AND_IMAGE_METADATA = 3;
        private static final int PROJECT_AND_GEOTRANSF = 12;
        private static final int EVERYTHING = 30;

        private TextType() {
        }
    }
}

