/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class RangeValidation
extends DefaultFeatureValidation {
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;
    private String attribute;

    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        Object obj = feature.getAttribute(this.attribute);
        if (obj == null) {
            return true;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            if (number.intValue() < this.min) {
                results.error(feature, this.attribute + " is less than " + this.min);
                return false;
            }
            if (number.intValue() > this.max) {
                results.error(feature, this.attribute + " is greater than " + this.max);
                return false;
            }
        }
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public void setMin(int i) {
        this.min = i;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String xpath) {
        this.attribute = xpath;
    }
}

