/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.xml.sax.SAXException;

public class ValidatorResources
implements Serializable {
    private static final String[] registrations = new String[]{"-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0//EN", "/org/apache/commons/validator/resources/validator_1_0.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0.1//EN", "/org/apache/commons/validator/resources/validator_1_0_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1//EN", "/org/apache/commons/validator/resources/validator_1_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1.3//EN", "/org/apache/commons/validator/resources/validator_1_1_3.dtd"};
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$ValidatorResources == null ? (class$org$apache$commons$validator$ValidatorResources = ValidatorResources.class$("org.apache.commons.validator.ValidatorResources")) : class$org$apache$commons$validator$ValidatorResources));
    protected FastHashMap hFormSets = new FastHashMap();
    protected FastHashMap hConstants = new FastHashMap();
    protected FastHashMap hActions = new FastHashMap();
    protected static Locale defaultLocale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorResources;

    public ValidatorResources() {
    }

    public ValidatorResources(InputStream in) throws IOException, SAXException {
        this(new InputStream[]{in});
    }

    public ValidatorResources(InputStream[] streams) throws IOException, SAXException {
        int i;
        URL rulesUrl = this.getClass().getResource("digester-rules.xml");
        Digester digester = DigesterLoader.createDigester((URL)rulesUrl);
        digester.setNamespaceAware(true);
        digester.setValidating(true);
        digester.setUseContextClassLoader(true);
        for (i = 0; i < registrations.length; i += 2) {
            URL url = this.getClass().getResource(registrations[i + 1]);
            if (url == null) continue;
            digester.register(registrations[i], url.toString());
        }
        for (i = 0; i < streams.length; ++i) {
            digester.push((Object)this);
            digester.parse(streams[i]);
        }
        this.process();
    }

    public void put(FormSet fs) {
        this.addFormSet(fs);
    }

    public void addFormSet(FormSet fs) {
        String key = this.buildKey(fs);
        ArrayList<FormSet> formsets = (ArrayList<FormSet>)this.hFormSets.get((Object)key);
        if (formsets == null) {
            formsets = new ArrayList<FormSet>();
            this.hFormSets.put((Object)key, formsets);
        }
        if (!formsets.contains(fs)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding FormSet '" + fs.toString() + "'."));
            }
            formsets.add(fs);
        }
    }

    public void addConstant(Constant c) {
        this.addConstantParam(c.getName(), c.getValue());
    }

    public void addConstantParam(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Global Constant: " + name + "," + value));
            }
            this.hConstants.put((Object)name, (Object)value);
        }
    }

    public void addConstant(String name, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Global Constant: " + name + "," + value));
        }
        this.hConstants.put((Object)name, (Object)value);
    }

    public void addValidatorAction(ValidatorAction va) {
        va.init();
        this.hActions.put((Object)va.getName(), (Object)va);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add ValidatorAction: " + va.getName() + "," + va.getClassname()));
        }
    }

    public ValidatorAction getValidatorAction(String key) {
        return (ValidatorAction)this.hActions.get((Object)key);
    }

    public Map getValidatorActions() {
        return Collections.unmodifiableMap(this.hActions);
    }

    protected String buildKey(FormSet fs) {
        String locale = this.buildLocale(fs.getLanguage(), fs.getCountry(), fs.getVariant());
        if (locale.length() == 0) {
            locale = defaultLocale.toString();
        }
        return locale;
    }

    private String buildLocale(String lang, String country, String variant) {
        String key = lang != null && lang.length() > 0 ? lang : "";
        key = key + (country != null && country.length() > 0 ? "_" + country : "");
        key = key + (variant != null && variant.length() > 0 ? "_" + variant : "");
        return key;
    }

    public Form get(Locale locale, Object formKey) {
        String key = formKey == null ? null : formKey.toString();
        return this.getForm(locale, key);
    }

    public Form getForm(Locale locale, String formKey) {
        return this.getForm(locale.getLanguage(), locale.getCountry(), locale.getVariant(), formKey);
    }

    public Form get(String language, String country, String variant, Object formKey) {
        String key = formKey == null ? null : formKey.toString();
        return this.getForm(language, country, variant, key);
    }

    public Form getForm(String language, String country, String variant, String formKey) {
        String key = this.buildLocale(language, country, variant);
        List v = (List)this.hFormSets.get((Object)key);
        if (v == null) {
            key = language != null && language.length() > 0 ? language : "";
            key = key + (country != null && country.length() > 0 ? "_" + country : "");
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            key = language != null && language.length() > 0 ? language : "";
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            key = defaultLocale.toString();
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            return null;
        }
        Iterator formsets = v.iterator();
        while (formsets.hasNext()) {
            FormSet set = (FormSet)formsets.next();
            if (set == null || set.getForm(formKey) == null) continue;
            return set.getForm(formKey);
        }
        return null;
    }

    public void process() {
        this.hFormSets.setFast(true);
        this.hConstants.setFast(true);
        this.hActions.setFast(true);
        this.internalProcessForms();
    }

    public void processForms() {
        this.internalProcessForms();
    }

    private void internalProcessForms() {
        String defaultKey = defaultLocale.toString();
        Iterator i = this.hFormSets.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals(defaultKey)) continue;
            List formsets = (List)this.hFormSets.get((Object)key);
            Iterator formsetsIterator = formsets.iterator();
            while (formsetsIterator.hasNext()) {
                FormSet fs = (FormSet)formsetsIterator.next();
                Iterator x = fs.getForms().keySet().iterator();
                while (x.hasNext()) {
                    String formKey = (String)x.next();
                    Form form = (Form)fs.getForms().get(formKey);
                    Form newForm = new Form();
                    newForm.setName(form.getName());
                    Form defaultForm = this.get(defaultLocale, formKey);
                    Iterator defaultFields = defaultForm.getFields().iterator();
                    while (defaultFields.hasNext()) {
                        Field defaultField = (Field)defaultFields.next();
                        String fieldKey = defaultField.getKey();
                        if (form.containsField(fieldKey)) {
                            newForm.addField(form.getField(fieldKey));
                            continue;
                        }
                        Field field = this.getClosestLocaleField(fs, formKey, fieldKey);
                        newForm.addField((Field)field.clone());
                    }
                    fs.addForm(newForm);
                }
            }
        }
        i = this.hFormSets.values().iterator();
        while (i.hasNext()) {
            List formsets = (List)i.next();
            Iterator formsetsIterator = formsets.iterator();
            while (formsetsIterator.hasNext()) {
                FormSet fs = (FormSet)formsetsIterator.next();
                if (fs.isProcessed()) continue;
                fs.process((Map)this.hConstants);
            }
        }
    }

    protected Field getClosestLocaleField(FormSet fs, String formKey, String fieldKey) {
        Form form;
        Field field = null;
        String language = fs.getLanguage();
        String country = fs.getCountry();
        String variant = fs.getVariant();
        if (!(GenericValidator.isBlankOrNull(language) || GenericValidator.isBlankOrNull(country) || GenericValidator.isBlankOrNull(variant))) {
            form = this.getForm(language, country, variant, formKey);
            field = form.getField(fieldKey);
        }
        if (field == null && !GenericValidator.isBlankOrNull(language) && !GenericValidator.isBlankOrNull(country)) {
            form = this.getForm(language, country, null, formKey);
            field = form.getField(fieldKey);
        }
        if (field == null && !GenericValidator.isBlankOrNull(language)) {
            form = this.getForm(language, null, null, formKey);
            field = form.getField(fieldKey);
        }
        if (field == null) {
            form = this.getForm(defaultLocale, formKey);
            field = form.getField(fieldKey);
        }
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

