/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.Point;
import org.postgresql.util.PGtokenizer;

public class LineString
extends Geometry {
    Point[] points;

    public LineString() {
        this.type = Geometry.LINESTRING;
    }

    public LineString(Point[] points) {
        this();
        this.points = points;
        this.dimension = points[0].dimension;
    }

    public LineString(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("LINESTRING") == 0) {
            value = value.substring(10).trim();
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value), ',');
        int npoints = t.getSize();
        this.points = new Point[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new Point(t.getToken(p));
            ++p;
        }
        this.dimension = this.points[0].dimension;
    }

    public String toString() {
        return "LINESTRING " + this.getValue();
    }

    public String getValue() {
        StringBuffer b = new StringBuffer("(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].getValue());
            ++p;
        }
        b.append(")");
        return b.toString();
    }

    public int numPoints() {
        return this.points.length;
    }

    public Point getPoint(int idx) {
        if (idx >= 0 & idx < this.points.length) {
            return this.points[idx];
        }
        return null;
    }
}

