/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgresql.util.PGobject;

public class PGgeometry
extends PGobject {
    Geometry geom;

    public PGgeometry() {
    }

    public PGgeometry(Geometry geom) {
        this.geom = geom;
    }

    public PGgeometry(String value) throws SQLException {
        this.setValue(value);
    }

    public void setValue(String value) throws SQLException {
        if ((value = value.trim()).startsWith("MULTIPOLYGON")) {
            this.geom = new MultiPolygon(value);
        } else if (value.startsWith("MULTILINESTRING")) {
            this.geom = new MultiLineString(value);
        } else if (value.startsWith("MULTIPOINT")) {
            this.geom = new MultiPoint(value);
        } else if (value.startsWith("POLYGON")) {
            this.geom = new Polygon(value);
        } else if (value.startsWith("LINESTRING")) {
            this.geom = new LineString(value);
        } else if (value.startsWith("POINT")) {
            this.geom = new Point(value);
        } else {
            throw new SQLException("Unknown type: " + value);
        }
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public int getGeoType() {
        return this.geom.type;
    }

    public String toString() {
        return this.geom.toString();
    }

    public String getValue() {
        return this.geom.toString();
    }

    public Object clone() {
        PGgeometry obj = new PGgeometry(this.geom);
        obj.setType(this.type);
        return obj;
    }
}

