/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.responses.decoration;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wms.responses.MapDecoration;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.LegendUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private static final int TITLE_INDENT = 4;
    private static SLDStyleFactory styleFactory = new SLDStyleFactory();
    private Color bgcolor = Color.WHITE;
    private Color fgcolor = Color.BLACK;
    private static final GeometryFactory geomFac = new GeometryFactory();
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;
    private static final StyledShapePainter shapePainter = new StyledShapePainter(null);

    @Override
    public void loadOptions(Map<String, String> options) {
        Color tmp = LegendDecoration.parseColor(options.get("bgcolor"));
        if (tmp != null) {
            this.bgcolor = tmp;
        }
        if ((tmp = LegendDecoration.parseColor(options.get("fgcolor"))) != null) {
            this.fgcolor = tmp;
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContext) {
        int x = 0;
        int y = 0;
        Catalog catalog = this.findCatalog(mapContext);
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont().deriveFont(1));
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)mapContext.getRequest().getWidth(), new HashMap());
        for (MapLayer layer : mapContext.getLayers()) {
            SimpleFeatureType type = (SimpleFeatureType)layer.getFeatureSource().getSchema();
            if (!LegendDecoration.isGridLayer(type)) {
                try {
                    Dimension legend = this.getLegendSize(type, layer.getStyle(), scaleDenominator, g2d);
                    x = Math.max(x, legend.width);
                    x = Math.max(x, 4 + metrics.stringWidth(this.findTitle(layer, catalog)));
                    y += legend.height + metrics.getHeight();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error sizing legend for " + layer);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "Skipping raster layer: " + layer);
        }
        return new Dimension(x += metrics.getDescent(), y);
    }

    private Catalog findCatalog(WMSMapContext mapContext) {
        return mapContext.getRequest().getWMS().getData().getCatalog();
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext mapContext) throws Exception {
        Catalog catalog = this.findCatalog(mapContext);
        Dimension d = this.findOptimalSize(g2d, mapContext);
        Rectangle bgRect = new Rectangle(0, 0, d.width, d.height);
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)mapContext.getRequest().getWidth(), new HashMap());
        Color oldColor = g2d.getColor();
        AffineTransform oldTransform = (AffineTransform)g2d.getTransform().clone();
        Font oldFont = g2d.getFont();
        Stroke oldStroke = g2d.getStroke();
        g2d.translate(paintArea.getX(), paintArea.getY());
        WMS wms = mapContext.getRequest().getWMS();
        AffineTransform tx = new AffineTransform();
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont().deriveFont(1));
        double scaleFactor = paintArea.getWidth() / d.getWidth();
        scaleFactor = Math.min(scaleFactor, paintArea.getHeight() / d.getHeight());
        if (scaleFactor < 1.0) {
            g2d.scale(scaleFactor, scaleFactor);
        }
        AffineTransform bgTransform = g2d.getTransform();
        g2d.setColor(this.bgcolor);
        g2d.fill(bgRect);
        g2d.setColor(this.fgcolor);
        for (MapLayer layer : mapContext.getLayers()) {
            SimpleFeatureType type = (SimpleFeatureType)layer.getFeatureSource().getSchema();
            if (!LegendDecoration.isGridLayer(type)) {
                try {
                    g2d.translate(0, metrics.getHeight());
                    g2d.setFont(g2d.getFont().deriveFont(1));
                    g2d.drawString(this.findTitle(layer, catalog), 4, 0 - metrics.getDescent());
                    g2d.setFont(g2d.getFont().deriveFont(0));
                    Dimension dim = this.drawLegend(type, layer.getStyle(), scaleDenominator, g2d);
                    g2d.translate(0.0, dim.getHeight());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Couldn't make a legend for " + type.getName(), e);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "Skipping raster layer " + type.getName() + " in legend decoration");
        }
        g2d.setTransform(bgTransform);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(new Rectangle(bgRect.x, bgRect.y, bgRect.width - 1, bgRect.height - 1));
        g2d.setStroke(oldStroke);
        g2d.setTransform(oldTransform);
        g2d.setFont(oldFont);
        g2d.setColor(oldColor);
    }

    private String findTitle(MapLayer layer, Catalog catalog) {
        String[] nameparts = layer.getTitle().split(":");
        ResourceInfo resource = nameparts.length > 1 ? catalog.getResourceByName(nameparts[0], nameparts[1], ResourceInfo.class) : catalog.getResourceByName(nameparts[0], ResourceInfo.class);
        return resource != null ? resource.getTitle() : layer.getTitle();
    }

    public Dimension getLegendSize(SimpleFeatureType layer, Style style, double scaleDenominator, Graphics2D g2d) throws WmsException {
        SimpleFeature sampleFeature = LegendDecoration.createSampleFeature(layer);
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        Rule[] applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
        int ruleCount = applicableRules.length;
        int w = 20;
        int h = 20;
        FontMetrics metrics = g2d.getFontMetrics();
        float totalHeight = 0.0f;
        float totalWidth = 0.0f;
        for (int i = 0; i < ruleCount; ++i) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (!(symbolizer instanceof RasterSymbolizer)) continue;
                throw new IllegalStateException("It is not legal to have a RasterSymbolizer here");
            }
            String label = applicableRules[i].getTitle();
            if (label == null) {
                label = applicableRules[i].getName();
            }
            if (label == null) {
                label = "";
            }
            float heightIncrement = Math.max(20, metrics.getHeight());
            totalHeight += heightIncrement;
            totalWidth = Math.max(totalWidth, (float)(20 + metrics.getDescent() + metrics.stringWidth(label)));
        }
        return new Dimension((int)totalWidth, (int)totalHeight);
    }

    public Dimension drawLegend(SimpleFeatureType layer, Style style, double scaleDenominator, Graphics2D g2d) throws WmsException {
        SimpleFeature sampleFeature = LegendDecoration.createSampleFeature(layer);
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        Rule[] applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
        int ruleCount = applicableRules.length;
        int w = 20;
        int h = 20;
        FontMetrics metrics = g2d.getFontMetrics();
        AffineTransform oldTransform = g2d.getTransform();
        Composite oldComposite = g2d.getComposite();
        float totalHeight = 0.0f;
        float totalWidth = 0.0f;
        for (int i = 0; i < ruleCount; ++i) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (symbolizer instanceof RasterSymbolizer) {
                    throw new IllegalStateException("It is not legal to have a RasterSymbolizer here");
                }
                Style2D style2d = styleFactory.createStyle((Object)sampleFeature, symbolizer, (Range)scaleRange);
                LiteShape2 shape = this.getSampleShape(symbolizer, 20, 20);
                if (style2d == null) continue;
                shapePainter.paint(g2d, shape, style2d, scaleDenominator);
            }
            String label = applicableRules[i].getTitle();
            if (label == null) {
                label = applicableRules[i].getName();
            }
            if (label == null) {
                label = "";
            }
            g2d.setColor(Color.BLACK);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.drawString(label, 20 + metrics.getDescent(), metrics.getHeight());
            float heightIncrement = Math.max(20, metrics.getHeight());
            g2d.translate(0.0, heightIncrement);
            totalHeight += heightIncrement;
            totalWidth = Math.max(totalWidth, (float)(20 + metrics.getDescent() + metrics.stringWidth(label)));
        }
        g2d.setTransform(oldTransform);
        g2d.setComposite(oldComposite);
        return new Dimension((int)totalWidth, (int)totalHeight);
    }

    private static SimpleFeature createSampleFeature(SimpleFeatureType schema) throws WmsException {
        SimpleFeature sampleFeature;
        try {
            sampleFeature = SimpleFeatureBuilder.template((SimpleFeatureType)schema, null);
        }
        catch (IllegalAttributeException e) {
            throw new WmsException(e);
        }
        return sampleFeature;
    }

    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad)), new Coordinate((double)((float)legendWidth - hpad), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad;
                float h = (float)legendHeight - 2.0f * vpad;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return sampleShape;
    }

    public static boolean isGridLayer(SimpleFeatureType layer) {
        for (PropertyDescriptor descriptor : layer.getDescriptors()) {
            PropertyType type = descriptor.getType();
            if (!type.getBinding().isAssignableFrom(AbstractGridCoverage2DReader.class)) continue;
            return true;
        }
        return false;
    }

    public static Color parseColor(String origInput) {
        if (origInput == null) {
            return null;
        }
        String input = origInput.trim();
        input = input.replaceFirst("\\A#", "");
        switch (input.length()) {
            case 1: 
            case 2: {
                return new Color(Integer.valueOf(input, 16));
            }
            case 3: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                return new Color(r, g, b);
            }
            case 4: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                int a = Integer.valueOf(input.substring(3, 4), 16);
                return new Color(r, g, b, a);
            }
            case 6: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            case 8: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                int a = Integer.valueOf(input.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
        }
        throw new RuntimeException("Couldn't decode color value: " + origInput + " (" + input + ")");
    }
}

