/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.operator.LookupDescriptor;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.responses.MapDecorationLayout;
import org.geoserver.wms.responses.MetatiledMapDecorationLayout;
import org.geoserver.wms.responses.decoration.WatermarkDecoration;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractRasterMapProducer;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.PaletteExtractor;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public abstract class DefaultRasterMapProducer
extends AbstractRasterMapProducer
implements RasterMapProducer,
ApplicationContextAware {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(DefaultRasterMapProducer.getTable());
    private WMS wms;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private MapDecorationLayout layout;
    private boolean tiled = false;
    private ApplicationContext applicationContext;

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public DefaultRasterMapProducer() {
        this(DEFAULT_MAP_FORMAT, (WMS)null);
    }

    public DefaultRasterMapProducer(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public DefaultRasterMapProducer(String mime, WMS wms) {
        super(mime);
        this.wms = wms;
    }

    public DefaultRasterMapProducer(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.formatImageOutputStream(this.image, out);
    }

    public void produceMap() throws WmsException {
        GetMapRequest request;
        String antialias;
        try {
            this.findDecorationLayout(this.mapContext);
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        Rectangle paintArea = new Rectangle(0, 0, this.mapContext.getMapWidth(), this.mapContext.getMapHeight());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + paintArea.width + "x" + paintArea.height + " image");
        }
        if ((antialias = (String)(request = this.mapContext.getRequest()).getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel palette = null;
        InverseColorMapOp paletteInverter = this.mapContext.getPaletteInverter();
        boolean transparent = this.mapContext.isTransparent();
        Color bgColor = this.mapContext.getBgColor();
        if (paletteInverter != null && AA_NONE.equals(antialias)) {
            palette = paletteInverter.getIcm();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
            MapLayer[] layers = this.mapContext.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                pe.visit(layers[i].getStyle());
                if (!pe.canComputePalette()) break;
            }
            if (pe.canComputePalette()) {
                palette = pe.getPalette();
            }
        }
        boolean useAlpha = transparent || MetatileMapProducer.isRequestTiled(request, this);
        RenderedImage preparedImage = this.prepareImage(paintArea.width, paintArea.height, palette, useAlpha);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphic = ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.wms != null && "Nearest".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (this.wms != null && "Bilinear".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (this.wms != null && "Bicubic".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphic.setRenderingHints(hintsMap);
        RenderingHints hints = new RenderingHints(hintsMap);
        this.renderer = new ShapefileRenderer();
        this.renderer.setContext((MapContext)this.mapContext);
        this.renderer.setJava2DHints(hints);
        if (this.renderer instanceof ShapefileRenderer && LOGGER.isLoggable(Level.FINE)) {
            this.renderer.addRenderListener(new RenderListener(){

                public void featureRenderer(SimpleFeature feature) {
                }

                public void errorOccurred(Exception e) {
                    LOGGER.log(Level.FINE, "Rendering error occurred", e);
                }
            });
        }
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        rendererParams.put("maxFiltersToSendToDatastore", new Integer(20));
        rendererParams.put("scaleComputationMethod", "OGC");
        if (AA_NONE.equals(antialias)) {
            rendererParams.put("textRenderingMethod", "STRING");
        } else {
            rendererParams.put("textRenderingMethod", "OUTLINE");
        }
        if (DefaultWebMapService.isNgLabellerEnabled()) {
            LabelCacheImpl labelCache = new LabelCacheImpl();
            labelCache.setOutlineRenderingEnabled(true);
            rendererParams.put("labelCache", labelCache);
        }
        if (!DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", false);
        }
        boolean kmplacemark = false;
        if (this.mapContext.getRequest().getFormatOptions().get("kmplacemark") != null) {
            kmplacemark = (Boolean)this.mapContext.getRequest().getFormatOptions().get("kmplacemark");
        }
        if (kmplacemark) {
            DuplicatingStyleVisitor dupVisitor = new DuplicatingStyleVisitor(){

                public void visit(PointSymbolizer ps) {
                    this.pages.push(null);
                }

                public void visit(TextSymbolizer ts) {
                    this.pages.push(null);
                }
            };
            MapLayer[] layers = this.mapContext.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Style style = layers[i].getStyle();
                style.accept((StyleVisitor)dupVisitor);
                Style copy = (Style)dupVisitor.getCopy();
                layers[i].setStyle(copy);
            }
        }
        this.renderer.setRendererHints(rendererParams);
        if (this.abortRequested) {
            graphic.dispose();
            return;
        }
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        this.renderer.paint(graphic, paintArea, dataArea);
        try {
            if (this.layout != null) {
                this.layout.paint(graphic, paintArea, this.mapContext);
            }
        }
        catch (Exception e) {
            throw new WmsException("Problem occurred while trying to watermark data", "", e);
        }
        graphic.dispose();
        if (!this.abortRequested) {
            this.image = palette != null && palette.getMapSize() < 256 ? this.optimizeSampleModel(preparedImage) : preparedImage;
        }
    }

    public void setDecorationLayout(MapDecorationLayout layout) {
        this.layout = layout;
    }

    public void findDecorationLayout(WMSMapContext mapContext) throws Exception {
        MapDecorationLayout.Block watermark;
        WMS wms;
        String layoutName = null;
        if (mapContext.getRequest().getFormatOptions() != null) {
            layoutName = (String)mapContext.getRequest().getFormatOptions().get("layout");
        }
        if (layoutName != null) {
            try {
                File layoutDir = GeoserverDataDirectory.findConfigDir((File)GeoserverDataDirectory.getGeoserverDataDirectory(), (String)"layouts");
                if (layoutDir != null) {
                    File layoutConfig = new File(layoutDir, layoutName + ".xml");
                    if (layoutConfig.exists() && layoutConfig.canRead()) {
                        this.layout = MapDecorationLayout.fromFile(layoutConfig, this.tiled);
                    } else {
                        LOGGER.log(Level.WARNING, "Unknown layout requested: " + layoutName);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No layout directory defined");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load layout: " + layoutName, e);
            }
        }
        if (this.layout == null) {
            MapDecorationLayout mapDecorationLayout = this.layout = this.tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        }
        if ((wms = mapContext.getRequest().getWMS()) != null && (watermark = DefaultRasterMapProducer.getWatermark(mapContext.getRequest().getWMS().getInfo())) != null) {
            this.layout.addBlock(watermark);
        }
    }

    public static MapDecorationLayout.Block getWatermark(WMSInfo wms) {
        WatermarkInfo watermark;
        WatermarkInfo watermarkInfo = watermark = wms == null ? null : wms.getWatermark();
        if (watermark != null && watermark.isEnabled()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("url", watermark.getURL());
            options.put("opacity", Float.toString((255.0f - (float)watermark.getTransparency()) / 2.55f));
            WatermarkDecoration d = new WatermarkDecoration();
            try {
                d.loadOptions(options);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Couldn't construct watermark from configuration", e);
                throw new WmsException(e);
            }
            MapDecorationLayout.Block.Position p = null;
            WatermarkInfo.Position wmPos = watermark.getPosition();
            switch (watermark.getPosition()) {
                case TOP_LEFT: {
                    p = MapDecorationLayout.Block.Position.UL;
                    break;
                }
                case TOP_CENTER: {
                    p = MapDecorationLayout.Block.Position.UC;
                    break;
                }
                case TOP_RIGHT: {
                    p = MapDecorationLayout.Block.Position.UR;
                    break;
                }
                case MID_LEFT: {
                    p = MapDecorationLayout.Block.Position.CL;
                    break;
                }
                case MID_CENTER: {
                    p = MapDecorationLayout.Block.Position.CC;
                    break;
                }
                case MID_RIGHT: {
                    p = MapDecorationLayout.Block.Position.CR;
                    break;
                }
                case BOT_LEFT: {
                    p = MapDecorationLayout.Block.Position.LL;
                    break;
                }
                case BOT_CENTER: {
                    p = MapDecorationLayout.Block.Position.LC;
                    break;
                }
                case BOT_RIGHT: {
                    p = MapDecorationLayout.Block.Position.LR;
                    break;
                }
                default: {
                    throw new WmsException("Unknown WatermarkInfo.Position value.  Something is seriously wrong.");
                }
            }
            return new MapDecorationLayout.Block(d, p, null, new Point(0, 0));
        }
        return null;
    }

    public void setMetatiled(boolean tiled) {
        this.tiled = tiled;
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, palette, transparent);
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage) {
        return ImageUtils.forceIndexed8Bitmask(originalImage, this.mapContext.getPaletteInverter());
    }

    private RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)IDENTITY_TABLE, (RenderingHints)hints);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

