/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.map.kml.KMLNetworkLinkTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducer;

public class KMLReflector {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.kml");
    public static final Integer KMSCORE = new Integer(50);
    public static final Boolean KMATTR = Boolean.TRUE;
    public static final Boolean KMPLACEMARK = Boolean.FALSE;
    public static final String FORMAT = "application/vnd.google-earth.kml+xml";
    private static Map<String, Map<String, String>> MODES;
    WebMapService wms;

    public KMLReflector(WebMapService wms) {
        this.wms = wms;
    }

    public void wms(GetMapRequest request, HttpServletResponse response) throws Exception {
        KMLReflector.doWms(request, response, this.wms);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doWms(GetMapRequest request, HttpServletResponse response, WebMapService wms) throws Exception {
        Boolean superoverlay;
        String submode;
        StringBuffer filename = new StringBuffer();
        boolean containsRasterData = false;
        boolean isRegionatingFriendly = true;
        for (int i = 0; i < request.getLayers().length; ++i) {
            MapLayerInfo layer = request.getLayers()[i];
            String name = layer.getName();
            boolean bl = containsRasterData = containsRasterData || layer.getType() == MapLayerInfo.TYPE_RASTER || layer.getType() == MapLayerInfo.TYPE_BASEMAP;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                System.out.println(layer.getFeature().getFeatureSource().getClass());
                isRegionatingFriendly = isRegionatingFriendly && layer.getFeature().getFeatureSource().getQueryCapabilities().isReliableFIDSupported();
            } else if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getRemoteFeatureSource().getQueryCapabilities().isReliableFIDSupported();
            }
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(name + "_");
        }
        String mode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "mode", isRegionatingFriendly ? "superoverlay" : "refresh");
        if (!MODES.containsKey(mode)) {
            throw new WmsException("Unknown KML mode: " + mode);
        }
        HashMap<String, String> modeOptions = new HashMap<String, String>(MODES.get(mode));
        if ("superoverlay".equals(mode)) {
            submode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "superoverlay_mode", "auto");
            if ("raster".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "raster");
            } else if ("overview".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "overview");
            } else if ("hybrid".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "hybrid");
            } else {
                if (!"auto".equalsIgnoreCase(submode)) throw new WmsException("Unknown overlay mode: " + submode);
                modeOptions.put("overlaymode", "auto");
            }
        } else if ("refresh".equals(mode)) {
            submode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "refresh_mode", null);
        } else if ("download".equals(mode)) {
            submode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "download_mode", null);
        }
        if (request.getWidth() < 1) {
            request.setWidth(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        if (request.getHeight() < 1) {
            request.setHeight(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        request.setSRS("EPSG:4326");
        wms.reflect(request);
        Map fo = request.getFormatOptions();
        KMLReflector.merge(fo, modeOptions);
        if (fo.get("kmattr") == null) {
            fo.put("kmattr", KMATTR);
        }
        if (fo.get("kmscore") == null) {
            fo.put("kmscore", KMSCORE);
        }
        if (fo.get("kmplacemark") == null) {
            fo.put("kmplacemark", KMPLACEMARK);
        }
        if ((superoverlay = (Boolean)fo.get("superoverlay")) == null) {
            superoverlay = Boolean.FALSE;
        }
        String formatExtension = ".kmz";
        if (superoverlay.booleanValue()) {
            request.setFormat("application/vnd.google-earth.kmz+xml");
            request.setBbox(KMLUtils.expandToTile(request.getBbox()));
        } else if (mode.equals("refresh") || containsRasterData) {
            request.setFormat("application/vnd.google-earth.kmz+xml");
        } else if (!Arrays.asList(KMZMapProducer.OUTPUT_FORMATS).contains(request.getFormat())) {
            request.setFormat(FORMAT);
            formatExtension = ".kml";
        }
        response.setContentType(request.getFormat());
        filename.setLength(filename.length() - 1);
        response.setHeader("Content-Disposition", "attachment; filename=" + filename.toString() + formatExtension);
        if ("download".equals(mode)) {
            GetMapResponse wmsResponse = wms.getMap(request);
            wmsResponse.execute(request);
            wmsResponse.writeTo((OutputStream)response.getOutputStream());
            return;
        } else {
            KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer();
            transformer.setIndentation(3);
            Charset encoding = request.getWMS().getCharSet();
            transformer.setEncoding(encoding);
            transformer.setEncodeAsRegion(superoverlay);
            transformer.transform((Object)request, (OutputStream)response.getOutputStream());
        }
    }

    private static String caseInsensitiveParam(Map params, String paramname, String defaultValue) {
        String value = defaultValue;
        for (Map.Entry o : params.entrySet()) {
            Map.Entry entry = o;
            if (!(entry.getKey() instanceof String) || !paramname.equalsIgnoreCase((String)entry.getKey())) continue;
            Object obj = entry.getValue();
            value = obj instanceof String[] ? ((String[])obj)[0].toLowerCase() : value;
        }
        return value;
    }

    private static void merge(Map options, Map addition) {
        for (Map.Entry o : addition.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue() == null) {
                options.remove(entry.getKey());
                continue;
            }
            options.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        HashMap<String, Map<String, String>> temp = new HashMap<String, Map<String, String>>();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("superoverlay", true);
        temp.put("superoverlay", options);
        options = new HashMap();
        options.put("superoverlay", false);
        options.put("regionatemode", null);
        options.put("kmscore", null);
        temp.put("download", options);
        options = new HashMap();
        options.put("superoverlay", false);
        temp.put("refresh", options);
        MODES = temp;
    }
}

