/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.validation;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Locale;
import org.geotools.validation.dto.ArgumentDTO;
import org.vfny.geoserver.config.validation.TestConfig;

public class ArgumentConfig {
    private String name;
    private boolean _final;
    private Object value;

    public ArgumentConfig() {
    }

    public ArgumentConfig(ArgumentConfig dto) {
        this.name = dto.getName();
        this._final = this.isFinal();
        this.value = dto.getValue();
    }

    public ArgumentConfig(ArgumentDTO dto) {
        this.name = dto.getName();
        this._final = this.isFinal();
        this.value = dto.getValue();
    }

    public Object clone() {
        return new ArgumentConfig(this);
    }

    public boolean equals(Object obj) {
        boolean r = true;
        if (obj == null || !(obj instanceof ArgumentConfig)) {
            return false;
        }
        ArgumentConfig dto = (ArgumentConfig)obj;
        boolean bl = r = r && dto.isFinal() == this._final;
        if (this.name != null) {
            r = r && this.name.equals(dto.getName());
        } else if (dto.getName() != null) {
            return false;
        }
        if (this.value != null) {
            r = r && this.value.equals(dto.getValue());
        } else if (dto.getValue() != null) {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.value != null) {
            r *= this.value.hashCode();
        }
        return r;
    }

    public ArgumentDTO toDTO() {
        ArgumentDTO dto = new ArgumentDTO();
        dto.setFinal(this._final);
        dto.setName(this.name);
        dto.setValue(this.value);
        return dto;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value should only be set when it has a value");
        }
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getDisplayName(PropertyDescriptor pd) {
        String r = "";
        r = pd.getDisplayName();
        return r;
    }

    public static synchronized void loadPropertyLists(TestConfig testConfig, Locale lc, List attributeKeys, List attributeHelps, List attributeValues) {
        if (!lc.equals(Locale.getDefault())) {
            Locale.setDefault(lc);
            Introspector.flushCaches();
        }
        PropertyDescriptor[] pd = testConfig.getPropertyDescriptors();
        for (int i = 0; i < pd.length; ++i) {
            PropertyDescriptor property = pd[i];
            String propertyName = property.getName();
            String displayName = ArgumentConfig.getDisplayName(property);
            String description = ArgumentConfig.getDescription(property);
            attributeKeys.add(propertyName);
            attributeHelps.add(description);
            attributeValues.add(testConfig.getArgStringValue(propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getDescription(PropertyDescriptor pd) {
        String r = "";
        r = pd.getShortDescription();
        return r;
    }
}

