/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected int headPos = -1;
    protected ObjectArray parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int objectId;
    private int currentRowNumber;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract LocalResult queryMeta() throws SQLException;

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() throws SQLException {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw Message.getSQLException(90067);
        }
        return SysProperties.RECOMPILE_ALWAYS || this.prepareAlways || this.modificationMetaId < database.getModificationMetaId();
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long l) {
        this.modificationMetaId = l;
    }

    public void setParameterList(ObjectArray objectArray) {
        this.parameters = objectArray;
    }

    public ObjectArray getParameters() {
        return this.parameters;
    }

    protected void checkParameters() throws SQLException {
        for (int i = 0; this.parameters != null && i < this.parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.parameters.get(i);
            parameter.checkSet();
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() throws SQLException {
    }

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public LocalResult query(int n) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getCurrentObjectId() {
        return this.objectId;
    }

    protected int getObjectId(boolean bl, boolean bl2) {
        Database database = this.session.getDatabase();
        int n = this.objectId;
        if (n == 0) {
            n = database.allocateObjectId(bl, bl2);
        }
        this.objectId = 0;
        return n;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCanceled() throws SQLException {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.command != null ? this.command : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    public void setHeadPos(int n) {
        this.headPos = n;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l, int n) throws SQLException {
        if (this.session.getTrace().isInfoEnabled()) {
            String string;
            long l2 = System.currentTimeMillis() - l;
            if (this.parameters.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.parameters.size() * 10);
                stringBuffer.append(" {");
                for (int i = 0; i < this.parameters.size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(i + 1);
                    stringBuffer.append(": ");
                    Expression expression = (Expression)this.parameters.get(i);
                    Value value = expression.getValue(this.session);
                    stringBuffer.append(value.getTraceSQL());
                }
                stringBuffer.append("}");
                string = stringBuffer.toString();
            } else {
                string = "";
            }
            this.session.getTrace().infoSQL(this.sqlStatement, string, n, l2);
        }
    }

    public void setPrepareAlways(boolean bl) {
        this.prepareAlways = bl;
    }

    protected void setCurrentRowNumber(int n) {
        this.currentRowNumber = n;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected String getSQL(Value[] valueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < valueArray.length; ++i) {
            Value value;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if ((value = valueArray[i]) == null) continue;
            stringBuffer.append(value.getSQL());
        }
        return stringBuffer.toString();
    }

    protected String getSQL(Expression[] expressionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if ((expression = expressionArray[i]) == null) continue;
            stringBuffer.append(expression.getSQL());
        }
        return stringBuffer.toString();
    }

    protected SQLException setRow(SQLException sQLException, int n, String string) {
        if (sQLException instanceof JdbcSQLException) {
            JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.sqlStatement != null) {
                stringBuffer.append(this.sqlStatement);
            }
            stringBuffer.append(" -- ");
            if (n > 0) {
                stringBuffer.append("row #").append(n + 1).append(" ");
            }
            stringBuffer.append("(").append(string).append(")");
            jdbcSQLException.setSQL(stringBuffer.toString());
        }
        return sQLException;
    }
}

