/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.UndoLogRecord;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.ObjectArray;

public class UndoLog {
    private Database database;
    private ObjectArray records = new ObjectArray();
    private FileStore file;
    private DataPage rowBuff;
    private int memoryUndo;

    public UndoLog(Session session) {
        this.database = session.getDatabase();
    }

    public int size() {
        if (SysProperties.CHECK && this.memoryUndo > this.records.size()) {
            Message.throwInternalError();
        }
        return this.records.size();
    }

    public void clear() {
        this.records.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getLast() throws SQLException {
        int n = this.records.size() - 1;
        UndoLogRecord undoLogRecord = (UndoLogRecord)this.records.get(n);
        if (undoLogRecord.isStored()) {
            int n2 = Math.max(0, n - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord undoLogRecord2 = null;
            for (int i = n2; i <= n; ++i) {
                UndoLogRecord undoLogRecord3 = (UndoLogRecord)this.records.get(i);
                if (!undoLogRecord3.isStored()) continue;
                undoLogRecord3.load(this.rowBuff, this.file);
                ++this.memoryUndo;
                if (undoLogRecord2 != null) continue;
                undoLogRecord2 = undoLogRecord3;
            }
            undoLogRecord2.seek(this.file);
        }
        return undoLogRecord;
    }

    public void removeLast(boolean bl) {
        int n = this.records.size() - 1;
        UndoLogRecord undoLogRecord = (UndoLogRecord)this.records.remove(n);
        if (!undoLogRecord.isStored()) {
            --this.memoryUndo;
        }
        if (bl && n > 1024 && (n & 0x3FF) == 0) {
            this.records.trimToSize();
        }
    }

    public void add(UndoLogRecord undoLogRecord) throws SQLException {
        this.records.add(undoLogRecord);
        if (!undoLogRecord.isStored()) {
            ++this.memoryUndo;
        }
        if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent()) {
            if (this.file == null) {
                String string = this.database.createTempFile();
                this.file = this.database.openFile(string, "rw", false);
                this.file.seek(48L);
                DataPage dataPage = this.rowBuff = DataPage.create((DataHandler)this.database, 512);
                for (int i = 0; i < this.records.size(); ++i) {
                    UndoLogRecord undoLogRecord2 = (UndoLogRecord)this.records.get(i);
                    this.saveIfPossible(undoLogRecord2, dataPage);
                }
            } else {
                this.saveIfPossible(undoLogRecord, this.rowBuff);
            }
            this.file.autoDelete();
        }
    }

    private void saveIfPossible(UndoLogRecord undoLogRecord, DataPage dataPage) throws SQLException {
        if (!undoLogRecord.isStored() && undoLogRecord.canStore()) {
            undoLogRecord.save(dataPage, this.file);
            --this.memoryUndo;
        }
    }
}

