/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.web.ConnectionInfo;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcDriverUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.SortedProperties;
import org.h2.util.Tool;

public class Shell
extends Tool {
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private BufferedReader reader;
    private Connection conn;
    private Statement stat;
    private boolean listMode;
    private int maxColumnSize = 100;
    private char boxVertical = (char)124;
    static /* synthetic */ Class class$java$lang$System;

    public static void main(String[] stringArray) throws SQLException {
        new Shell().run(stringArray);
    }

    public void setErr(PrintStream printStream) {
        this.err = printStream;
    }

    public void setIn(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setInReader(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
    }

    public void run(String[] stringArray) throws SQLException {
        String string = null;
        String string2 = "";
        String string3 = "";
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-driver")) {
                String string5 = stringArray[++i];
                ClassUtils.loadUserClass(string5);
                continue;
            }
            this.throwUnsupportedOption(string4);
        }
        if (string != null) {
            Driver.load();
            this.conn = DriverManager.getConnection(string, string2, string3);
            this.stat = this.conn.createStatement();
        }
        this.promptLoop();
    }

    private void showHelp() {
        this.println("Commands are case insensitive; SQL statements end with ';'");
        this.println("help or ?      Display this help");
        this.println("list           Toggle result list mode");
        this.println("maxwidth       Set maximum column width (default is 100)");
        this.println("show           List all tables");
        this.println("describe       Describe a table");
        this.println("quit or exit   Close the connection and exit");
        this.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptLoop() {
        this.println("");
        this.println("Welcome to H2 Shell " + Constants.getFullVersion());
        this.println("Exit with Ctrl+C");
        if (this.conn != null) {
            this.showHelp();
        }
        String string = null;
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.in));
        }
        block17: while (true) {
            try {
                while (true) {
                    Object object;
                    String string2;
                    if (this.conn == null) {
                        this.connect();
                        this.showHelp();
                    }
                    if (string == null) {
                        this.print("sql> ");
                    } else {
                        this.print("...> ");
                    }
                    String string3 = this.readLine();
                    if (string3 == null) break block17;
                    String string4 = string3.trim();
                    if (string4.length() == 0) continue;
                    boolean bl = string4.endsWith(";");
                    if (bl) {
                        string3 = string3.substring(0, string3.lastIndexOf(59));
                    }
                    if ("EXIT".equals(string2 = string4.toUpperCase()) || "QUIT".equals(string2)) break block17;
                    if ("HELP".equals(string2) || "?".equals(string2)) {
                        this.showHelp();
                        continue;
                    }
                    if ("LIST".equals(string2)) {
                        this.listMode = !this.listMode;
                        this.println("Result list mode is now " + (this.listMode ? "on" : "off"));
                        continue;
                    }
                    if (string2.startsWith("DESCRIBE")) {
                        object = string2.substring("DESCRIBE".length()).trim();
                        if (((String)object).length() == 0) {
                            this.println("Usage: describe [<schema name>.]<table name>");
                            continue;
                        }
                        String string5 = null;
                        int n = ((String)object).indexOf(46);
                        if (n >= 0) {
                            string5 = ((String)object).substring(0, n);
                            object = ((String)object).substring(n + 1);
                        }
                        PreparedStatement preparedStatement = null;
                        ResultSet resultSet = null;
                        try {
                            String string6 = "SELECT CAST(COLUMN_NAME AS VARCHAR(32)) \"Column Name\", CAST(TYPE_NAME AS VARCHAR(14)) \"Type\", NUMERIC_PRECISION \"Precision\", CAST(IS_NULLABLE AS VARCHAR(8)) \"Nullable\", CAST(COLUMN_DEFAULT AS VARCHAR(20)) \"Default\" FROM INFORMATION_SCHEMA.COLUMNS WHERE UPPER(TABLE_NAME)=?";
                            if (string5 != null) {
                                string6 = string6 + " AND UPPER(TABLE_SCHEMA)=?";
                            }
                            string6 = string6 + " ORDER BY ORDINAL_POSITION";
                            preparedStatement = this.conn.prepareStatement(string6);
                            preparedStatement.setString(1, ((String)object).toUpperCase());
                            if (string5 != null) {
                                preparedStatement.setString(2, string5.toUpperCase());
                            }
                            resultSet = preparedStatement.executeQuery();
                            this.printResult(resultSet, false);
                        }
                        catch (SQLException sQLException) {
                            try {
                                this.println("Exception: " + sQLException.toString());
                                sQLException.printStackTrace(this.err);
                            }
                            catch (Throwable throwable) {
                                JdbcUtils.closeSilently(resultSet);
                                JdbcUtils.closeSilently(preparedStatement);
                                throw throwable;
                            }
                            JdbcUtils.closeSilently(resultSet);
                            JdbcUtils.closeSilently(preparedStatement);
                            continue;
                        }
                        JdbcUtils.closeSilently(resultSet);
                        JdbcUtils.closeSilently(preparedStatement);
                        continue;
                    }
                    if (string2.startsWith("SHOW")) {
                        object = null;
                        try {
                            object = this.stat.executeQuery("SELECT CAST(TABLE_SCHEMA AS VARCHAR(32)) \"Schema\", TABLE_NAME \"Table Name\" FROM INFORMATION_SCHEMA.TABLES ORDER BY TABLE_SCHEMA, TABLE_NAME");
                            this.printResult((ResultSet)object, false);
                        }
                        catch (SQLException sQLException) {
                            this.println("Exception: " + sQLException.toString());
                            sQLException.printStackTrace(this.err);
                        }
                        finally {
                            JdbcUtils.closeSilently((ResultSet)object);
                        }
                        continue;
                    }
                    if (string2.startsWith("MAXWIDTH")) {
                        string2 = string2.substring("MAXWIDTH".length()).trim();
                        try {
                            this.maxColumnSize = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.println("Usage: maxwidth <integer value>");
                        }
                        this.println("Maximum column width is now " + this.maxColumnSize);
                        continue;
                    }
                    string = string == null ? string3 : string + "\n" + string3;
                    if (!bl) continue;
                    this.execute(string);
                    string = null;
                }
            }
            catch (SQLException sQLException) {
                this.println("SQL Exception: " + sQLException.getMessage());
                string = null;
                continue;
            }
            catch (IOException iOException) {
                this.println(iOException.getMessage());
            }
            catch (Exception exception) {
                this.println("Exception: " + exception.toString());
                exception.printStackTrace(this.err);
            }
            break;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.println("Connection closed");
            }
            catch (SQLException sQLException) {
                this.println("SQL Exception: " + sQLException.getMessage());
                sQLException.printStackTrace(this.err);
            }
        }
    }

    private void connect() throws IOException, SQLException {
        Object object;
        String string = FileUtils.getFileInUserHome(".h2.server.properties");
        String string2 = "jdbc:h2:~/test";
        String string3 = "sa";
        String string4 = null;
        try {
            String string5;
            object = SortedProperties.loadProperties(string);
            String string6 = null;
            boolean bl = false;
            int n = 0;
            while ((string5 = ((Properties)object).getProperty(String.valueOf(n))) != null) {
                bl = true;
                string6 = string5;
                ++n;
            }
            if (bl) {
                ConnectionInfo connectionInfo = new ConnectionInfo(string6);
                string2 = connectionInfo.url;
                string3 = connectionInfo.user;
                string4 = connectionInfo.driver;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.println("[Enter]   " + string2);
        this.print("URL       ");
        string2 = this.readLine(string2);
        if (string4 == null) {
            string4 = JdbcDriverUtils.getDriver(string2);
        }
        if (string4 != null) {
            this.println("[Enter]   " + string4);
        }
        this.print("Driver    ");
        string4 = this.readLine(string4);
        this.println("[Enter]   " + string3);
        this.print("User      ");
        string3 = this.readLine(string3);
        this.println("[Enter]   Hide");
        this.print("Password  ");
        object = this.readLine();
        if (((String)object).length() == 0) {
            object = this.readPassword();
        }
        this.conn = JdbcUtils.getConnection(string4, string2, string3, (String)object);
        this.stat = this.conn.createStatement();
        this.println("Connected");
    }

    protected void print(String string) {
        this.out.print(string);
        this.out.flush();
    }

    private void println(String string) {
        this.out.println(string);
        this.out.flush();
    }

    private String readPassword() throws IOException {
        try {
            Method method = (class$java$lang$System == null ? (class$java$lang$System = Shell.class$("java.lang.System")) : class$java$lang$System).getMethod("console", new Class[0]);
            Object object = method.invoke(null, (Object[])null);
            Method method2 = object.getClass().getMethod("readPassword", new Class[0]);
            this.print("Password  ");
            char[] cArray = (char[])method2.invoke(object, (Object[])null);
            return cArray == null ? null : new String(cArray);
        }
        catch (Exception exception) {
            class PasswordHider
            extends Thread {
                volatile boolean stop;

                PasswordHider() {
                }

                public void run() {
                    while (!this.stop) {
                        Shell.this.print("\b\b><");
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            PasswordHider passwordHider = new PasswordHider();
            passwordHider.start();
            this.print("Password  > ");
            String string = this.readLine();
            passwordHider.stop = true;
            try {
                passwordHider.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.print("\b\b");
            return string;
        }
    }

    private String readLine(String string) throws IOException {
        String string2 = this.readLine();
        return string2.length() == 0 ? string : string2;
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        if (string == null) {
            throw new IOException("Aborted");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String string) {
        ResultSet resultSet;
        block7: {
            boolean bl;
            long l = System.currentTimeMillis();
            try {
                bl = this.stat.execute(string);
            }
            catch (SQLException sQLException) {
                this.println("Error: " + sQLException.toString());
                return;
            }
            resultSet = null;
            try {
                if (bl) {
                    resultSet = this.stat.getResultSet();
                    int n = this.printResult(resultSet, this.listMode);
                    l = System.currentTimeMillis() - l;
                    this.println("(" + n + (n == 1 ? " row, " : " rows, ") + l + " ms)");
                    break block7;
                }
                int n = this.stat.getUpdateCount();
                l = System.currentTimeMillis() - l;
                this.println("(Update count: " + n + ", " + l + " ms)");
            }
            catch (SQLException sQLException) {
                try {
                    this.println("Error: " + sQLException.toString());
                    sQLException.printStackTrace(this.err);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(resultSet);
                    throw throwable;
                }
                JdbcUtils.closeSilently(resultSet);
            }
        }
        JdbcUtils.closeSilently(resultSet);
    }

    private int printResult(ResultSet resultSet, boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string = resultSetMetaData.getColumnLabel(i + 1);
            int n4 = string.length();
            if (!bl) {
                n4 = Math.max(n4, resultSetMetaData.getColumnDisplaySize(i + 1));
                n4 = Math.min(this.maxColumnSize, n4);
            }
            if (string.length() > n4) {
                string = string.substring(0, n4);
            }
            stringArray[i] = string;
            nArray[i] = n4;
            n = Math.max(n, n4);
            n3 += n4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(this.boxVertical);
                }
                String string = stringArray[i];
                stringBuffer.append(string);
                if (i >= n2 - 1) continue;
                for (int j = string.length(); j < nArray[i]; ++j) {
                    stringBuffer.append(' ');
                }
            }
            this.println(stringBuffer.toString());
        }
        int n5 = 0;
        while (resultSet.next()) {
            int n6;
            int n7;
            ++n5;
            stringBuffer.setLength(0);
            if (bl) {
                if (n5 > 1) {
                    this.println("");
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    if (n7 > 0) {
                        stringBuffer.append('\n');
                    }
                    String string = stringArray[n7];
                    stringBuffer.append(string);
                    for (n6 = string.length(); n6 < n; ++n6) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(": ");
                    stringBuffer.append(resultSet.getString(n7 + 1));
                }
            } else {
                for (n7 = 0; n7 < n2; ++n7) {
                    String string;
                    if (n7 > 0) {
                        stringBuffer.append(this.boxVertical);
                    }
                    if ((string = resultSet.getString(n7 + 1)) == null) {
                        string = "null";
                    }
                    n6 = nArray[n7];
                    if (!bl && string.length() > n6) {
                        string = string.substring(0, n6);
                    }
                    stringBuffer.append(string);
                    if (n7 >= n2 - 1) continue;
                    for (int i = string.length(); i < n6; ++i) {
                        stringBuffer.append(' ');
                    }
                }
            }
            this.println(stringBuffer.toString());
        }
        if (n5 == 0 && bl) {
            for (int i = 0; i < n2; ++i) {
                String string = stringArray[i];
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            this.println(stringBuffer.toString());
        }
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

