/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.index.rtree.RTree;
import org.geotools.index.rtree.cachefs.FileSystemPageStore;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

public class ShapeFileIndexer
implements FileWriter {
    private IndexType idxType;
    private int max = 50;
    private int min = 25;
    private short split = 1;
    private String byteOrder;
    private ShpFiles shpFiles;

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || (args.length - 1) % 2 != 0) {
            ShapeFileIndexer.usage();
        }
        long start = System.currentTimeMillis();
        ShapeFileIndexer idx = new ShapeFileIndexer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                idx.setIdxType(IndexType.valueOf(args[++i]));
                continue;
            }
            if (args[i].equals("-M")) {
                idx.setMax(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-m")) {
                idx.setMin(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-s")) {
                idx.setSplit(Short.parseShort(args[++i]));
                continue;
            }
            if (args[i].equals("-b")) {
                idx.setByteOrder(args[++i]);
                continue;
            }
            if (!args[i].toLowerCase().endsWith(".shp")) {
                System.out.println("File extension must be '.shp'");
                System.exit(1);
            }
            idx.setShapeFileName(new ShpFiles(args[i]));
        }
        try {
            System.out.print("Indexing ");
            int cnt = idx.index(true, new NullProgressListener());
            System.out.println();
            System.out.print(cnt + " features indexed ");
            System.out.println("in " + (System.currentTimeMillis() - start) + "ms.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            ShapeFileIndexer.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: ShapeFileIndexer -t <QIX | GRX> [-M <max entries per node>] [-m <min entries per node>] [-s <split algorithm>] [-b <byte order NL | NM>] <shape file>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("\t-t Index type: RTREE or QUADTREE");
        System.out.println();
        System.out.println("Following options apllies only to RTREE:");
        System.out.println("\t-M maximum number of entries per node");
        System.out.println("\t-m minimum number of entries per node");
        System.out.println("\t-s split algorithm to use");
        System.out.println();
        System.out.println("Following options apllies only to QUADTREE:");
        System.out.println("\t-b byte order to use: NL = LSB; NM = MSB (default)");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int index(boolean verbose, ProgressListener listener) throws MalformedURLException, IOException, TreeException, StoreException, LockTimeoutException {
        if (this.shpFiles == null) {
            throw new IOException("You have to set a shape file name!");
        }
        cnt = 0;
        reader = null;
        storage = this.shpFiles.getStorageFile(this.idxType.shpFileType);
        treeFile = storage.getFile();
        try {
            reader = new ShapefileReader(this.shpFiles, true, false);
            switch (1.$SwitchMap$org$geotools$data$shapefile$indexed$IndexType[this.idxType.ordinal()]) {
                case 1: {
                    cnt = this.buildRTree(reader, treeFile, verbose);
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 2: {
                    cnt = this.buildQuadTree(reader, treeFile, verbose);
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalArgumentException("NONE is not a legal index choice");
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        storage.replaceOriginal();
        return cnt;
    }

    private int buildRTree(ShapefileReader reader, File rtreeFile, boolean verbose) throws TreeException, LockTimeoutException, IOException {
        DataDefinition keyDef = new DataDefinition("US-ASCII");
        keyDef.addField(Integer.class);
        keyDef.addField(Long.class);
        FileSystemPageStore fps = new FileSystemPageStore(rtreeFile, keyDef, this.max, this.min, this.split);
        RTree rtree = new RTree(fps);
        ShapefileReader.Record record = null;
        Data data = null;
        int cnt = 0;
        while (reader.hasNext()) {
            record = reader.nextRecord();
            data = new Data(keyDef);
            data.addValue(new Integer(++cnt));
            data.addValue(new Long(record.offset()));
            rtree.insert(new Envelope(record.minX, record.maxX, record.minY, record.maxY), data);
            if (!verbose || cnt % 500 != 0) continue;
            System.out.print('.');
        }
        rtree.close();
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildQuadTree(ShapefileReader reader, File file, boolean verbose) throws IOException, StoreException {
        byte order = 0;
        if (this.byteOrder == null || this.byteOrder.equalsIgnoreCase("NM")) {
            order = 2;
        } else if (this.byteOrder.equalsIgnoreCase("NL")) {
            order = 1;
        } else {
            throw new StoreException("Asked byte order '" + this.byteOrder + "' must be 'NL' or 'NM'!");
        }
        IndexFile shpIndex = new IndexFile(this.shpFiles, false);
        QuadTree tree = null;
        int cnt = 0;
        int numRecs = shpIndex.getRecordCount();
        ShapefileHeader header = reader.getHeader();
        Envelope bounds = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
        tree = new QuadTree(numRecs, this.max, bounds, shpIndex);
        try {
            ShapefileReader.Record rec = null;
            while (reader.hasNext()) {
                rec = reader.nextRecord();
                tree.insert(cnt++, new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY));
                if (verbose && cnt % 1000 == 0) {
                    System.out.print('.');
                }
                if (cnt % 100000 != 0) continue;
                System.out.print('\n');
            }
            if (verbose) {
                System.out.println("done");
            }
            FileSystemIndexStore store = new FileSystemIndexStore(file, order);
            store.store(tree);
        }
        finally {
            tree.close();
        }
        return cnt;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public void setMin(int i) {
        this.min = i;
    }

    public void setSplit(short s) {
        this.split = s;
    }

    public void setShapeFileName(ShpFiles shpFiles) {
        this.shpFiles = shpFiles;
    }

    public void setIdxType(IndexType indexType) {
        this.idxType = indexType;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String id() {
        return this.getClass().getName();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$geotools$data$shapefile$indexed$IndexType;

        static {
            $SwitchMap$org$geotools$data$shapefile$indexed$IndexType = new int[IndexType.values().length];
            try {
                1.$SwitchMap$org$geotools$data$shapefile$indexed$IndexType[IndexType.EXPERIMENTAL_UNSUPPORTED_GRX.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$geotools$data$shapefile$indexed$IndexType[IndexType.QIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

