/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output.spi;

import it.geosolutions.imageio.stream.output.FileImageOutputStreamExtImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.stream.ImageOutputStream;

public class URLImageOutputStreamSpi
extends ImageOutputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.output.spi");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class outputClass = URL.class;

    public URLImageOutputStreamSpi() {
        super(vendorName, version, outputClass);
    }

    public String getDescription(Locale locale) {
        return "Service provider for writing to a URL";
    }

    public ImageOutputStream createOutputStreamInstance(Object output, boolean useCache, File cacheDir) {
        block8: {
            if (!(output instanceof URL)) {
                return null;
            }
            URL outputURL = (URL)output;
            if (outputURL.getProtocol().compareToIgnoreCase("file") == 0) {
                try {
                    File tempFile = new File(URLDecoder.decode(outputURL.getFile(), "UTF-8"));
                    return new FileImageOutputStreamExtImpl(tempFile);
                }
                catch (UnsupportedEncodingException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return null;
    }
}

