/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.medialib.codec.g3fax.Decoder;
import java.io.IOException;

public class TIFFCodecLibFaxDecompressor
extends TIFFFaxDecompressor {
    private static final boolean DEBUG = false;
    private Object decoder;

    public TIFFCodecLibFaxDecompressor(int bilevelCompression) {
        block4: {
            this.decoder = null;
            try {
                if (bilevelCompression == 3) {
                    Decoder decoder = new Decoder();
                    this.decoder = decoder;
                    break block4;
                }
                if (bilevelCompression == 4) {
                    com.sun.medialib.codec.g4fax.Decoder decoder = new com.sun.medialib.codec.g4fax.Decoder();
                    this.decoder = decoder;
                    break block4;
                }
                throw new RuntimeException("Unknown compression = " + bilevelCompression);
            }
            catch (Throwable e) {
                throw new RuntimeException("CodecLib not available");
            }
        }
    }

    public final synchronized void decodeRaw(byte[] b, int dstOffset, int pixelBitStride, int scanlineStride) throws IOException {
        com.sun.medialib.codec.g4fax.Decoder decoder;
        int bytesPerRow = (this.srcWidth + 7) / 8;
        byte[] image = null;
        byte[] code = new byte[this.byteCount];
        this.stream.seek(this.offset);
        this.stream.readFully(code, 0, this.byteCount);
        if (this.fillOrder == 2) {
            for (int i = 0; i < this.byteCount; ++i) {
                code[i] = flipTable[code[i] & 0xFF];
            }
        }
        image = dstOffset == 0 && bytesPerRow == scanlineStride ? b : new byte[this.srcWidth * this.srcHeight];
        if (this.compression == 4) {
            decoder = (com.sun.medialib.codec.g4fax.Decoder)this.decoder;
            int result = -1;
            try {
                result = decoder.decode(image, code, this.srcWidth, this.srcHeight, 0);
            }
            catch (Throwable t) {
                ((TIFFImageReader)this.reader).forwardWarningMessage("codecLib T.6 decompressor failed; falling back to Java.");
                result = -1;
            }
            if (result == -1) {
                super.decodeRaw(b, dstOffset, pixelBitStride, scanlineStride);
                return;
            }
        } else {
            decoder = (Decoder)this.decoder;
            int decodingFlags = 0;
            decodingFlags = this.oneD == 1 ? 2 | 4 : 1 | 4;
            if (this.fillBits == 1) {
                decodingFlags |= 0x10;
            }
            int result = -1;
            try {
                result = decoder.decode(image, code, this.srcWidth, this.srcHeight, decodingFlags);
            }
            catch (Throwable t) {
                ((TIFFImageReader)this.reader).forwardWarningMessage("codecLib T.4 decompressor failed; falling back to Java.");
                result = -1;
            }
            if (result == -1) {
                super.decodeRaw(b, dstOffset, pixelBitStride, scanlineStride);
                return;
            }
        }
        if (image != b) {
            int srcOffset = 0;
            for (int row = 0; row < this.srcHeight; ++row) {
                System.arraycopy(image, srcOffset, b, dstOffset, bytesPerRow);
                srcOffset += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

