/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFUtils {
    public static boolean has(EObject eobject, String property) {
        return EMFUtils.feature(eobject, property) != null;
    }

    public static void set(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        eobject.eSet(feature, value);
    }

    public static Object get(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eGet(feature);
    }

    public static void add(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature != null && EMFUtils.isCollection(eobject, property)) {
            Collection collection = (Collection)EMFUtils.get(eobject, property);
            collection.addAll(EMFUtils.collection(value));
        }
    }

    private static Collection collection(Object value) {
        if (null == value) {
            return Collections.EMPTY_LIST;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                Object val = Array.get(value, i);
                list.add(val);
            }
            return list;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    public static boolean isCollection(EObject eobject, String property) {
        Object o = EMFUtils.get(eobject, property);
        if (o != null) {
            return o instanceof Collection;
        }
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature == null) {
            return false;
        }
        return EList.class.isAssignableFrom(feature.getEType().getInstanceClass());
    }

    public static EStructuralFeature feature(EObject eobject, String property) {
        EStructuralFeature feature2 = eobject.eClass().getEStructuralFeature(property);
        if (feature2 != null) {
            return feature2;
        }
        for (EStructuralFeature feature2 : eobject.eClass().getEAllStructuralFeatures()) {
            if (!feature2.getName().equalsIgnoreCase(property)) continue;
            return feature2;
        }
        return null;
    }

    public static List features(EObject eobject, Class propertyType) {
        ArrayList<EStructuralFeature> match = new ArrayList<EStructuralFeature>();
        EList features = eobject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.getEType().getInstanceClass().isAssignableFrom(propertyType)) continue;
            match.add(feature);
        }
        return match;
    }

    public static void set(List objects, String property, List values) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, values.get(i));
        }
    }

    public static void set(List objects, String property, Object value) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, value);
        }
    }

    public static List get(List objects, String property) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EStructuralFeature feature = EMFUtils.feature(eobject, property);
            values.add(eobject.eGet(feature));
        }
        return values;
    }

    public static boolean isSet(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eIsSet(feature);
    }

    public static boolean isSet(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnset(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (!EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static EObject clone(EObject prototype, EFactory factory) {
        EObject clone = factory.create(prototype.eClass());
        for (EStructuralFeature feature : clone.eClass().getEStructuralFeatures()) {
            clone.eSet(feature, prototype.eGet(feature));
        }
        return clone;
    }

    public static void copy(EObject source, EObject target) {
        for (EStructuralFeature feature : source.eClass().getEStructuralFeatures()) {
            target.eSet(feature, source.eGet(feature));
        }
    }
}

