/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.ext.servlet.ServletContextAdapter;
import com.noelios.restlet.http.HttpServerHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;

public class ServerServlet
extends HttpServlet {
    private static final String NAME_APPLICATION_ATTRIBUTE = "org.restlet.attribute.application";
    private static final String NAME_APPLICATION_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.application";
    private static final String NAME_COMPONENT_ATTRIBUTE = "org.restlet.attribute.component";
    private static final String NAME_COMPONENT_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.component";
    private static final String NAME_SERVER_ATTRIBUTE = "org.restlet.attribute.server";
    private static final String NAME_SERVER_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.server";
    private static final long serialVersionUID = 1L;
    private transient Application application = null;
    private transient Component component = null;
    private transient HttpServerHelper helper = null;

    public Application createApplication(Context context) {
        Restlet application = null;
        String applicationClassName = this.getInitParameter("org.restlet.application", null);
        if (applicationClassName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> targetClass = loader != null ? Class.forName(applicationClassName, false, loader) : Class.forName(applicationClassName);
                try {
                    application = (Application)targetClass.getConstructor(Context.class).newInstance(context);
                }
                catch (NoSuchMethodException e) {
                    this.log("[Noelios Restlet Engine] - The ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context. The empty constructor and the context setter wille used instead. " + applicationClassName, e);
                    application = (Application)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't find the target class. Please check that your classpath includes " + applicationClassName, e);
            }
            catch (InstantiationException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check this class has an empty constructor " + applicationClassName, e);
            }
            catch (IllegalAccessException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check that you have to proper access rights to " + applicationClassName, e);
            }
            catch (NoSuchMethodException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + applicationClassName, e);
            }
            catch (InvocationTargetException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. An exception was thrown while creating " + applicationClassName, e);
            }
            if (application != null) {
                application.setContext(new ServletContextAdapter((Servlet)this, (Application)application, context));
            }
        }
        return application;
    }

    public HttpServerHelper createServer(HttpServletRequest request) {
        HttpServerHelper result = null;
        Component component = this.getComponent();
        Application application = this.getApplication();
        if (component != null && application != null) {
            Server server = new Server(component.getContext(), (List<Protocol>)null, request.getLocalAddr(), request.getLocalPort(), (Restlet)component);
            result = new HttpServerHelper(server);
            String uriPattern = request.getContextPath() + request.getServletPath();
            component.getDefaultHost().attach(uriPattern, application);
        }
        return result;
    }

    public void destroy() {
        if (this.getApplication() != null && this.getApplication().isStarted()) {
            try {
                this.getApplication().stop();
            }
            catch (Exception e) {
                this.log("Error during the stopping of the Restlet Application", e);
            }
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application getApplication() {
        Application result = this.application;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            String applicationAttributeName = this.getInitParameter(NAME_APPLICATION_ATTRIBUTE, NAME_APPLICATION_ATTRIBUTE_DEFAULT);
            result = (Application)this.getServletContext().getAttribute(applicationAttributeName);
            if (result == null) {
                result = this.createApplication(this.getComponent().getContext());
                this.getServletContext().setAttribute(applicationAttributeName, (Object)result);
            }
            this.application = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponent() {
        Component result = this.component;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            String componentAttributeName = this.getInitParameter(NAME_COMPONENT_ATTRIBUTE, NAME_COMPONENT_ATTRIBUTE_DEFAULT);
            result = (Component)this.getServletContext().getAttribute(componentAttributeName);
            if (result == null) {
                result = new Component();
                this.getServletContext().setAttribute(componentAttributeName, (Object)result);
            }
            this.component = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public String getInitParameter(String name, String defaultValue) {
        String result = this.getServletConfig().getInitParameter(name);
        if (result == null) {
            result = this.getServletConfig().getServletContext().getInitParameter(name);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpServerHelper getServer(HttpServletRequest request) {
        HttpServerHelper result = this.helper;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            String serverAttributeName = this.getInitParameter(NAME_SERVER_ATTRIBUTE, NAME_SERVER_ATTRIBUTE_DEFAULT);
            result = (HttpServerHelper)this.getServletContext().getAttribute(serverAttributeName);
            if (result == null) {
                result = this.createServer(request);
                this.getServletContext().setAttribute(serverAttributeName, (Object)result);
            }
            this.helper = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public void init() throws ServletException {
        if (this.getApplication() != null && this.getApplication().isStopped()) {
            try {
                this.getApplication().start();
            }
            catch (Exception e) {
                this.log("Error during the starting of the Restlet Application", e);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServerHelper helper = this.getServer(request);
        if (helper != null) {
            helper.handle(new ServletCall(helper.getServer(), request, response));
        } else {
            this.log("[Noelios Restlet Engine] - Unable to get the Restlet HTTP server connector. Status code 500 returned.");
            response.sendError(500);
        }
    }
}

