/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.xml.Configuration;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GML2EncodingUtils {
    static final int LON_LAT = 0;
    static final int LAT_LON = 1;
    static final int INAPPLICABLE = 2;

    public static String epsgCode(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        for (Identifier id : crs.getIdentifiers()) {
            if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
            return id.getCode();
        }
        return null;
    }

    public static String crs(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs);
    }

    public static String toURI(CoordinateReferenceSystem crs) {
        String code = GML2EncodingUtils.epsgCode(crs);
        int axisOrder = GML2EncodingUtils.axisOrder(crs);
        if (code != null) {
            if (axisOrder == 0 || axisOrder == 2) {
                return "http://www.opengis.net/gml/srs/epsg.xml#" + code;
            }
            return "urn:x-ogc:def:crs:EPSG:" + code;
        }
        return null;
    }

    static int axisOrder(CoordinateReferenceSystem crs) {
        CoordinateSystem cs = null;
        if (crs instanceof ProjectedCRS) {
            ProjectedCRS pcrs = (ProjectedCRS)crs;
            cs = pcrs.getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return 2;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals((Object)AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals((Object)AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            if (longitudeDim < latitudeDim) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static CoordinateReferenceSystem getCRS(Geometry g) {
        if (g.getUserData() == null) {
            return null;
        }
        if (g.getUserData() instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)g.getUserData();
        }
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (CoordinateReferenceSystem)userData.get(CoordinateReferenceSystem.class);
        }
        return null;
    }

    public static String getID(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:id");
    }

    public static String getName(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:name");
    }

    public static String getDescription(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:description");
    }

    static String getMetadata(Geometry g, String metadata) {
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (String)userData.get(metadata);
        }
        return null;
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value) {
        SimpleFeature feature = (SimpleFeature)object;
        SimpleFeatureType featureType = feature.getFeatureType();
        String namespace = featureType.getName().getNamespaceURI();
        String typeName = featureType.getTypeName();
        Element encoding = document.createElementNS(namespace, typeName);
        encoding.setAttributeNS("http://www.opengis.net/gml", "id", feature.getID());
        return encoding;
    }

    public static Object AbstractFeatureType_getProperty(Object object, QName name, Configuration configuration) {
        SimpleFeature feature = (SimpleFeature)object;
        if (GML.name.equals(name)) {
            return feature.getAttribute("name");
        }
        if (GML.description.equals(name)) {
            return feature.getAttribute("description");
        }
        if (GML.location.equals(name)) {
            return feature.getAttribute("location");
        }
        if (GML.boundedBy.equals(name) && !configuration.hasProperty(GMLConfiguration.NO_FEATURE_BOUNDS)) {
            BoundingBox bounds = feature.getBounds();
            if (bounds.isEmpty() && feature.getDefaultGeometry() == null) {
                return null;
            }
            return feature.getBounds();
        }
        return null;
    }
}

