/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import javax.xml.namespace.QName;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GMLAbstractFeatureTypeBinding
extends AbstractComplexBinding {
    FeatureTypeCache ftCache;
    BindingWalkerFactory bwFactory;
    Configuration configuration;

    public GMLAbstractFeatureTypeBinding(FeatureTypeCache ftCache, BindingWalkerFactory bwFactory, Configuration configuration) {
        this.ftCache = ftCache;
        this.bwFactory = bwFactory;
        this.configuration = configuration;
    }

    public QName getTarget() {
        return GML.AbstractFeatureType;
    }

    public Class getType() {
        return SimpleFeature.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return GML2ParsingUtils.parseFeature(instance, node, value, this.ftCache, this.bwFactory);
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        return GML2EncodingUtils.AbstractFeatureType_encode(object, document, value);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        SimpleFeature feature = (SimpleFeature)object;
        if (GML.name.equals(name)) {
            return feature.getAttribute("name");
        }
        if (GML.description.equals(name)) {
            return feature.getAttribute("description");
        }
        if (GML.location.equals(name)) {
            return feature.getAttribute("location");
        }
        if (GML.boundedBy.equals(name) && !this.configuration.hasProperty(GMLConfiguration.NO_FEATURE_BOUNDS)) {
            return feature.getBounds();
        }
        return null;
    }
}

