/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.protocol;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.protocol.wfs.Version;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.protocol.ConnectionFactory;

public abstract class WFSProtocolHandler {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private Version wfsVersion;
    protected final ConnectionFactory connectionFac;

    public WFSProtocolHandler(Version version, ConnectionFactory connectionFac) {
        this.wfsVersion = version;
        this.connectionFac = connectionFac;
    }

    public Version getVersion() {
        return this.wfsVersion;
    }

    public abstract boolean supports(WFSOperationType var1, HttpMethod var2);

    public abstract URL getOperationURL(WFSOperationType var1, HttpMethod var2) throws UnsupportedOperationException;

    public String getEncoding() {
        return this.connectionFac.getEncoding().name();
    }

    public HttpURLConnection createDescribeFeatureTypeConnection(String typeName, HttpMethod method) throws IOException, IllegalArgumentException {
        URL query = HttpMethod.POST == method ? this.getOperationURL(WFSOperationType.DESCRIBE_FEATURETYPE, HttpMethod.POST) : this.getDescribeFeatureTypeURLGet(typeName);
        if (query == null) {
            return null;
        }
        return this.connectionFac.getConnection(query, method);
    }

    public URL getDescribeFeatureTypeURLGet(String typeName) throws MalformedURLException {
        URL getUrl = this.getOperationURL(WFSOperationType.DESCRIBE_FEATURETYPE, HttpMethod.GET);
        Logging.getLogger((String)"org.geotools.data.communication").fine("Output: " + getUrl);
        String query = getUrl.getQuery();
        query = query == null ? null : query.toUpperCase();
        String url = getUrl.toString();
        if (query == null || "".equals(query)) {
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            url = url + "SERVICE=WFS";
        } else if (query.indexOf("SERVICE=WFS") == -1) {
            url = url + "&SERVICE=WFS";
        }
        if (query == null || query.indexOf("VERSION") == -1) {
            url = url + "&VERSION=" + (Object)((Object)this.getVersion());
        }
        if (query == null || query.indexOf("REQUEST") == -1) {
            url = url + "&REQUEST=DescribeFeatureType";
        }
        url = url + "&TYPENAME=" + typeName;
        getUrl = new URL(url);
        return getUrl;
    }
}

