/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.RasterLayerLegendHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultRasterLegendProducer
implements GetLegendGraphicProducer {
    private static final Logger LOGGER = Logging.getLogger((String)DefaultRasterLegendProducer.class.getPackage().getName());
    private static final SLDStyleFactory styleFactory = new SLDStyleFactory();
    static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter = new StyledShapePainter(null);
    private static final GeometryFactory geomFac = new GeometryFactory();
    private BufferedImage legendGraphic;
    private boolean renderingStopRequested;
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;

    @Override
    public void produceLegendGraphic(GetLegendGraphicRequest request) throws WmsException {
        FeatureType layer = request.getLayer();
        if (LegendUtils.checkGridLayer(layer)) {
            RasterLayerLegendHelper rasterLegendHelper = new RasterLayerLegendHelper(request);
            this.legendGraphic = rasterLegendHelper.getLegend();
            return;
        }
        Feature temp = this.createSampleFeature(layer);
        if (!(temp instanceof SimpleFeature)) {
            throw new WmsException("");
        }
        SimpleFeature sampleFeature = (SimpleFeature)temp;
        Style gt2Style = request.getStyle();
        FeatureTypeStyle[] ftStyles = gt2Style.getFeatureTypeStyles();
        double scaleDenominator = request.getScale();
        Rule[] applicableRules = request.getRule() != null ? new Rule[]{request.getRule()} : LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
        int ruleCount = applicableRules.length;
        ArrayList<RenderedImage> legendsStack = new ArrayList<RenderedImage>(ruleCount);
        int w = request.getWidth();
        int h = request.getHeight();
        Color bgColor = LegendUtils.getBackgroundColor(request);
        for (int i = 0; i < ruleCount; ++i) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            boolean transparent = request.isTransparent();
            BufferedImage image = ImageUtils.createImage(w, h, null, transparent);
            HashMap hintsMap = new HashMap();
            Graphics2D graphics = ImageUtils.prepareTransparency(transparent, bgColor, image, hintsMap);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (symbolizer instanceof RasterSymbolizer) {
                    throw new IllegalStateException("It is not legal to have a RasterSymbolizer here");
                }
                Style2D style2d = styleFactory.createStyle((Object)sampleFeature, symbolizer, (Range)scaleRange);
                LiteShape2 shape = this.getSampleShape(symbolizer, w, h);
                if (style2d == null) continue;
                shapePainter.paint(graphics, shape, style2d, scaleDenominator);
            }
            legendsStack.add(image);
            graphics.dispose();
        }
        this.legendGraphic = DefaultRasterLegendProducer.mergeLegends(legendsStack, applicableRules, request);
    }

    private static BufferedImage mergeLegends(List<RenderedImage> imageStack, Rule[] rules, GetLegendGraphicRequest req) {
        BufferedImage finalLegend;
        String aaVal;
        Font labelFont = LegendUtils.getLabelFont(req);
        boolean useAA = false;
        if (req.getLegendOptions().get("fontAntiAliasing") instanceof String && ((aaVal = (String)req.getLegendOptions().get("fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase("1"))) {
            useAA = true;
        }
        boolean forceLabelsOn = false;
        boolean forceLabelsOff = false;
        if (req.getLegendOptions().get("forceLabels") instanceof String) {
            String forceLabelsOpt = (String)req.getLegendOptions().get("forceLabels");
            if (forceLabelsOpt.equalsIgnoreCase("on")) {
                forceLabelsOn = true;
            } else if (forceLabelsOpt.equalsIgnoreCase("off")) {
                forceLabelsOff = true;
            }
        }
        if (imageStack.size() == 0) {
            throw new IllegalArgumentException("No legend graphics passed");
        }
        if (imageStack.size() == 1 && !forceLabelsOn) {
            finalLegend = (BufferedImage)imageStack.get(0);
        } else {
            int imgCount = imageStack.size();
            String[] labels = new String[imgCount];
            BufferedImage img = (BufferedImage)imageStack.get(0);
            int totalHeight = 0;
            int totalWidth = 0;
            int[] rowHeights = new int[imgCount];
            BufferedImage[] labelsGraphics = new BufferedImage[imgCount];
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                if (forceLabelsOff) {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = img.getHeight();
                    totalHeight += img.getHeight();
                    continue;
                }
                Rule rule = rules[i];
                labels[i] = rule.getTitle();
                if (labels[i] == null) {
                    labels[i] = rule.getName();
                }
                if (labels[i] == null) {
                    labels[i] = "";
                }
                Graphics2D g = img.createGraphics();
                g.setFont(labelFont);
                if (useAA) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel;
                    labelsGraphics[i] = renderedLabel = LegendUtils.renderLabel(labels[i], g, req);
                    Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, renderedLabel.getWidth(), renderedLabel.getHeight());
                    totalWidth = (int)Math.ceil(Math.max((double)img.getWidth() + ((RectangularShape)bounds).getWidth(), (double)totalWidth));
                    rowHeights[i] = (int)Math.ceil(Math.max((double)img.getHeight(), ((RectangularShape)bounds).getHeight()));
                } else {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = (int)Math.ceil(img.getHeight());
                    labelsGraphics[i] = null;
                }
                totalHeight += rowHeights[i];
            }
            boolean transparent = req.isTransparent();
            Color backgroundColor = LegendUtils.getBackgroundColor(req);
            HashMap hintsMap = new HashMap();
            finalLegend = ImageUtils.createImage(totalWidth += 2, totalHeight, null, transparent);
            Graphics2D finalGraphics = ImageUtils.prepareTransparency(transparent, backgroundColor, finalLegend, hintsMap);
            int topOfRow = 0;
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                int y = topOfRow;
                if (img.getHeight() < rowHeights[i]) {
                    y += (int)((double)(rowHeights[i] - img.getHeight()) / 2.0);
                }
                finalGraphics.drawImage((Image)img, 0, y, null);
                if (forceLabelsOff) {
                    topOfRow += rowHeights[i];
                    continue;
                }
                finalGraphics.setFont(labelFont);
                if (useAA) {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel = labelsGraphics[i];
                    y = topOfRow;
                    if (renderedLabel.getHeight() < rowHeights[i]) {
                        y += (int)((double)(rowHeights[i] - renderedLabel.getHeight()) / 2.0);
                    }
                    finalGraphics.drawImage((Image)renderedLabel, img.getWidth(), y, null);
                    renderedLabel.flush();
                    labelsGraphics[i] = null;
                }
                topOfRow += rowHeights[i];
            }
            finalGraphics.dispose();
        }
        return finalLegend;
    }

    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad)), new Coordinate((double)((float)legendWidth - hpad), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad;
                float h = (float)legendHeight - 2.0f * vpad;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return sampleShape;
    }

    private Feature createSampleFeature(FeatureType schema) throws WmsException {
        SimpleFeature sampleFeature;
        try {
            if (!(schema instanceof SimpleFeatureType)) {
                throw new UnsupportedOperationException("Sample non-simple feature not yet supported.");
            }
            sampleFeature = SimpleFeatureBuilder.template((SimpleFeatureType)((SimpleFeatureType)schema), null);
        }
        catch (IllegalAttributeException e) {
            throw new WmsException(e);
        }
        return sampleFeature;
    }

    public BufferedImage getLegendGraphic() {
        if (this.legendGraphic == null) {
            throw new IllegalStateException();
        }
        return this.legendGraphic;
    }

    @Override
    public void abort() {
        this.renderingStopRequested = true;
    }

    public boolean isAborter() {
        return this.renderingStopRequested;
    }
}

