/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.WMS;
import org.geoserver.wms.responses.MapDecorationLayout;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractRasterMapProducer;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;
import org.vfny.geoserver.wms.responses.MaxErrorEnforcer;
import org.vfny.geoserver.wms.responses.RenderExceptionStrategy;
import org.vfny.geoserver.wms.responses.map.pdf.PDFMaxSizeEnforcer;

class PDFMapProducer
extends AbstractRasterMapProducer
implements RasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.pdf");
    static final int KB = 1024;
    static final String MIME_TYPE = "application/pdf";
    WMS wms;

    public PDFMapProducer(WMS wms) {
        super(MIME_TYPE);
        this.wms = wms;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        int width = this.mapContext.getMapWidth();
        int height = this.mapContext.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        try {
            Rectangle pageSize = new Rectangle((float)width, (float)height);
            Document document = new Document(pageSize);
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            FontFactory.registerDirectories();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PdfGraphics2D graphic = (PdfGraphics2D)tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
            if (!this.mapContext.isTransparent()) {
                graphic.setColor(this.mapContext.getBgColor());
                graphic.fillRect(0, 0, width, height);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("setting to transparent");
                }
                int type = 2;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
                Color c = new Color(this.mapContext.getBgColor().getRed(), this.mapContext.getBgColor().getGreen(), this.mapContext.getBgColor().getBlue(), 0);
                graphic.setBackground(this.mapContext.getBgColor());
                graphic.setColor(c);
                graphic.fillRect(0, 0, width, height);
                type = 3;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
            }
            java.awt.Rectangle paintArea = new java.awt.Rectangle(width, height);
            this.renderer = new StreamingRenderer();
            this.renderer.setContext((MapContext)this.mapContext);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderer.setJava2DHints(hints);
            HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
            rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
            rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
            rendererParams.put("optimizeFTSRendering", Boolean.FALSE);
            if (!DefaultWebMapService.isLineWidthOptimizationEnabled()) {
                rendererParams.put("lineWidthOptimization", Boolean.valueOf(false));
            }
            this.renderer.setRendererHints(rendererParams);
            ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
            AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)dataArea, (java.awt.Rectangle)paintArea);
            if (this.abortRequested) {
                graphic.dispose();
                document.close();
                return;
            }
            int maxErrors = this.wms.getMaxRenderingErrors();
            MaxErrorEnforcer errorChecker = new MaxErrorEnforcer(this.renderer, maxErrors);
            RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy(this.renderer);
            this.renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
            int maxMemory = this.wms.getMaxRequestMemory() * 1024;
            PDFMaxSizeEnforcer memoryChecker = new PDFMaxSizeEnforcer(this.renderer, graphic, maxMemory);
            this.renderer.paint((Graphics2D)graphic, paintArea, at);
            MapDecorationLayout.Block watermark = DefaultRasterMapProducer.getWatermark(this.mapContext.getRequest().getWMS().getServiceInfo());
            if (watermark != null) {
                MapDecorationLayout layout = new MapDecorationLayout();
                layout.paint((Graphics2D)graphic, paintArea, this.mapContext);
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                Exception renderError = nonIgnorableExceptionListener.getException();
                throw new WmsException("Rendering process failed", "internalError", renderError);
            }
            if (errorChecker.exceedsMaxErrors()) {
                throw new WmsException("More than " + maxErrors + " rendering errors occurred, bailing out", "internalError", errorChecker.getLastException());
            }
            if (memoryChecker.exceedsMaxSize()) {
                long kbMax = maxMemory / 1024;
                throw new WmsException("Rendering request used more memory than the maximum allowed:" + kbMax + "KB");
            }
            graphic.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
            writer.flush();
            writer.close();
        }
        catch (DocumentException t) {
            throw new WmsException("Error setting up the PDF", "internalError", (Exception)((Object)t));
        }
    }

    public void produceMap() throws WmsException {
    }

    public String getContentDisposition() {
        if (this.mapContext.getLayer(0) != null) {
            try {
                String title = this.mapContext.getLayer(0).getFeatureSource().getSchema().getName().getLocalPart();
                if (title != null && !title.equals("")) {
                    return "attachment; filename=" + title + ".pdf";
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return "attachment; filename=geoserver.pdf";
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
    }
}

