/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.svg.AbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGWriter
extends OutputStreamWriter {
    private static final Logger LOGGER = Logging.getLogger((String)SVGWriter.class.getPackage().getName());
    private static DecimalFormat formatter;
    private HashMap writers;
    private double minY;
    private double maxY;
    private int coordsSkipCount;
    private int coordsWriteCount;
    private SVGFeatureWriterHandler writerHandler = new SVGFeatureWriterHandler();
    private SVGFeatureWriter featureWriter = null;
    private double minCoordDistance;
    private String attributeStyle;
    private boolean pointsAsCircles;
    private WMSMapContext mapContext;

    public SVGWriter(OutputStream out, WMSMapContext mapContext) {
        super(out);
        this.mapContext = mapContext;
        ReferencedEnvelope space = mapContext.getAreaOfInterest();
        this.minY = space.getMinY();
        this.maxY = space.getMaxY();
        this.initWriters();
    }

    private void initWriters() {
        this.writers = new HashMap();
        this.writers.put(Point.class, new PointWriter());
        this.writers.put(LineString.class, new LineStringWriter());
        this.writers.put(LinearRing.class, new LineStringWriter());
        this.writers.put(Polygon.class, new PolygonWriter());
        this.writers.put(MultiPoint.class, new MultiPointWriter());
        this.writers.put(MultiLineString.class, new MultiLineStringWriter());
        this.writers.put(MultiPolygon.class, new MultiPolygonWriter());
    }

    public void setAttributeStyle(String attributeName) {
        this.attributeStyle = attributeName;
    }

    public void setPointsAsCircles(boolean asCircles) {
        this.pointsAsCircles = asCircles;
    }

    public void setGeometryType(Class gtype) {
        this.featureWriter = (SVGFeatureWriter)this.writers.get(gtype);
        if (this.featureWriter == null) {
            if (gtype == Geometry.class) {
                this.featureWriter = new GeometryWriter();
            } else {
                throw new IllegalArgumentException("No SVG Feature writer defined for " + gtype);
            }
        }
    }

    public void setWriterHandler(SVGFeatureWriterHandler handler) {
        this.writerHandler = handler;
    }

    public void setMinCoordDistance(double minCoordDistance) {
        this.minCoordDistance = minCoordDistance;
    }

    public double getY(double y) {
        return this.maxY - y + this.minY;
    }

    public double getX(double x) {
        return x;
    }

    public void setMaximunFractionDigits(int numDigits) {
        formatter.setMaximumFractionDigits(numDigits);
    }

    public int getMaximunFractionDigits() {
        return formatter.getMaximumFractionDigits();
    }

    public void setMinimunFractionDigits(int numDigits) {
        formatter.setMinimumFractionDigits(numDigits);
    }

    public int getMinimunFractionDigits() {
        return formatter.getMinimumFractionDigits();
    }

    public void write(double d) throws IOException {
        this.write(formatter.format(d));
    }

    public void write(char c) throws IOException {
        super.write(c);
    }

    public void newline() throws IOException {
        super.write(10);
    }

    public void writeFeatures(SimpleFeatureType featureType, FeatureIterator<SimpleFeature> reader, String style) throws IOException, AbortedException {
        try {
            Class gtype = featureType.getGeometryDescriptor().getType().getBinding();
            boolean doCollect = false;
            this.setGeometryType(gtype);
            this.setPointsAsCircles("#circle".equals(style));
            style = style != null && !"#circle".equals(style) && style.startsWith("#") ? style.substring(1) : null;
            this.setAttributeStyle(style);
            this.setUpWriterHandler(featureType, doCollect);
            if (doCollect) {
                this.write("<path ");
                this.write("d=\"");
            }
            while (reader.hasNext()) {
                SimpleFeature ft = (SimpleFeature)reader.next();
                this.writeFeature(ft);
                ft = null;
            }
            if (doCollect) {
                this.write("\"/>\n");
            }
            LOGGER.fine("encoded " + featureType.getTypeName());
        }
        catch (NoSuchElementException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void setUpWriterHandler(SimpleFeatureType featureType, boolean doCollect) throws IOException {
        if (doCollect) {
            this.writerHandler = new CollectSVGHandler(this.featureWriter);
            LOGGER.finer("Established a collecting features writer handler");
        } else {
            this.writerHandler = new SVGFeatureWriterHandler();
            String typeName = featureType.getTypeName();
            ArrayList atts = new ArrayList(0);
            if (atts.contains("#FID")) {
                this.writerHandler = new FIDSVGHandler(this.writerHandler);
                atts.remove("#FID");
                LOGGER.finer("Added FID handler decorator");
            }
            if (atts.contains("#BOUNDS")) {
                this.writerHandler = new BoundsSVGHandler(this.writerHandler);
                atts.remove("#BOUNDS");
                LOGGER.finer("Added BOUNDS handler decorator");
            }
            if (atts.size() > 0) {
                this.writerHandler = new AttributesSVGHandler(this.writerHandler);
                LOGGER.finer("Added ATTRIBUTES handler decorator");
            }
        }
    }

    public void writeFeature(SimpleFeature ft) throws IOException {
        this.writerHandler.startFeature(this.featureWriter, ft);
        this.writerHandler.startGeometry(this.featureWriter, ft);
        this.writerHandler.writeGeometry(this.featureWriter, ft);
        this.writerHandler.endGeometry(this.featureWriter, ft);
        this.writerHandler.endFeature(this.featureWriter, ft);
    }

    static {
        Locale locale = new Locale("en", "US");
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(locale);
        decimalSymbols.setDecimalSeparator('.');
        formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(decimalSymbols);
        formatter.setGroupingSize(0);
        formatter.setDecimalSeparatorAlwaysShown(false);
        formatter.setDecimalFormatSymbols(null);
        formatter.setMaximumFractionDigits(5);
        formatter.setMinimumFractionDigits(0);
    }

    private class MultiPolygonWriter
    extends PolygonWriter {
        protected void writeGeometry(Geometry geom) throws IOException {
            MultiPolygon mpoly = (MultiPolygon)geom;
            for (int i = 0; i < mpoly.getNumGeometries(); ++i) {
                super.writeGeometry(mpoly.getGeometryN(i));
            }
        }
    }

    private class PolygonWriter
    extends SVGFeatureWriter {
        protected void startElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write("<path");
        }

        protected void startGeometry(Geometry geom) throws IOException {
            SVGWriter.this.write(" d=\"");
        }

        protected void writeGeometry(Geometry geom) throws IOException {
            Polygon poly = (Polygon)geom;
            LineString shell = poly.getExteriorRing();
            int nHoles = poly.getNumInteriorRing();
            this.writeClosedPathContent(shell.getCoordinates());
            for (int i = 0; i < nHoles; ++i) {
                this.writeClosedPathContent(poly.getInteriorRingN(i).getCoordinates());
            }
        }
    }

    private class MultiLineStringWriter
    extends LineStringWriter {
        protected void writeGeometry(Geometry geom) throws IOException {
            MultiLineString ml = (MultiLineString)geom;
            for (int i = 0; i < ml.getNumGeometries(); ++i) {
                super.writeGeometry(ml.getGeometryN(i));
            }
        }
    }

    private class LineStringWriter
    extends SVGFeatureWriter {
        protected void startElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write("<path");
        }

        protected void startGeometry(Geometry geom) throws IOException {
            SVGWriter.this.write(" d=\"");
        }

        protected void writeGeometry(Geometry geom) throws IOException {
            this.writePathContent(((LineString)geom).getCoordinates());
        }
    }

    private class GeometryWriter
    extends SVGFeatureWriter {
        SVGFeatureWriter delegate;

        private GeometryWriter() {
        }

        protected void startElement(SimpleFeature feature) throws IOException {
            Geometry g = (Geometry)feature.getDefaultGeometry();
            this.delegate = null;
            if (g != null) {
                this.delegate = (SVGFeatureWriter)SVGWriter.this.writers.get(g.getClass());
            }
            if (this.delegate == null) {
                throw new IllegalArgumentException("No SVG Feature writer defined for " + g);
            }
            this.delegate.startElement(feature);
        }

        protected void startGeometry(Geometry geom) throws IOException {
            this.delegate.startGeometry(geom);
        }

        protected void writeGeometry(Geometry geom) throws IOException {
            this.delegate.writeGeometry(geom);
        }
    }

    private class MultiPointWriter
    extends PointWriter {
        protected void startElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write("<g ");
        }

        protected void startGeometry(Geometry geom) throws IOException {
            SVGWriter.this.write("/>\n");
        }

        protected void writeGeometry(Geometry geom) throws IOException {
            MultiPoint mp = (MultiPoint)geom;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                super.startElement(null);
                super.writeGeometry(mp.getGeometryN(i));
                super.endGeometry(mp.getGeometryN(i));
                super.endElement(null);
            }
        }

        protected void endElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write("</g>\n");
        }
    }

    private class PointWriter
    extends SVGFeatureWriter {
        protected void startElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write(SVGWriter.this.pointsAsCircles ? "<circle r='0.25%' fill='blue'" : "<use");
        }

        protected void startGeometry(Geometry geom) throws IOException {
        }

        protected void writeBounds(Envelope env) throws IOException {
        }

        protected void writeGeometry(Geometry geom) throws IOException {
            Point p = (Point)geom;
            if (SVGWriter.this.pointsAsCircles) {
                SVGWriter.this.write(" cx=\"");
                SVGWriter.this.write(SVGWriter.this.getX(p.getX()));
                SVGWriter.this.write("\" cy=\"");
                SVGWriter.this.write(SVGWriter.this.getY(p.getY()));
            } else {
                SVGWriter.this.write(" x=\"");
                SVGWriter.this.write(SVGWriter.this.getX(p.getX()));
                SVGWriter.this.write("\" y=\"");
                SVGWriter.this.write(SVGWriter.this.getY(p.getY()));
                SVGWriter.this.write("\" xlink:href=\"#point");
            }
        }
    }

    private abstract class SVGFeatureWriter {
        private SVGFeatureWriter() {
        }

        protected abstract void startElement(SimpleFeature var1) throws IOException;

        protected abstract void startGeometry(Geometry var1) throws IOException;

        protected abstract void writeGeometry(Geometry var1) throws IOException;

        protected void endGeometry(Geometry geom) throws IOException {
            SVGWriter.this.write("\"");
        }

        protected void endElement(SimpleFeature feature) throws IOException {
            SVGWriter.this.write("/>\n");
        }

        protected void writePathContent(Coordinate[] coords) throws IOException {
            SVGWriter.this.write('M');
            Coordinate prev = coords[0];
            Coordinate curr = null;
            SVGWriter.this.write(SVGWriter.this.getX(prev.x));
            SVGWriter.this.write(' ');
            SVGWriter.this.write(SVGWriter.this.getY(prev.y));
            int nCoords = coords.length;
            SVGWriter.this.write('l');
            for (int i = 1; i < nCoords; ++i) {
                curr = coords[i];
                if (i > 3 && prev.distance(curr) <= SVGWriter.this.minCoordDistance) {
                    ++SVGWriter.this.coordsSkipCount;
                    continue;
                }
                ++SVGWriter.this.coordsWriteCount;
                SVGWriter.this.write(SVGWriter.this.getX(curr.x) - SVGWriter.this.getX(prev.x));
                SVGWriter.this.write(' ');
                SVGWriter.this.write(SVGWriter.this.getY(curr.y) - SVGWriter.this.getY(prev.y));
                SVGWriter.this.write(' ');
                prev = curr;
            }
        }

        protected void writeClosedPathContent(Coordinate[] coords) throws IOException {
            this.writePathContent(coords);
            SVGWriter.this.write('Z');
        }
    }

    public class AttributesSVGHandler
    extends SVGFeatureWriterHandler {
        private SVGFeatureWriterHandler handler;

        public AttributesSVGHandler(SVGFeatureWriterHandler handler) {
            this.handler = handler;
        }

        public void startFeature(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            this.handler.startFeature(featureWriter, ft);
            SimpleFeatureType type = ft.getFeatureType();
            int numAtts = type.getAttributeCount();
            for (int i = 0; i < numAtts; ++i) {
                Object value = ft.getAttribute(i);
                if (value == null || value instanceof Geometry) continue;
                SVGWriter.this.write(' ');
                SVGWriter.this.write(type.getDescriptor(i).getName().getLocalPart());
                SVGWriter.this.write("=\"");
                this.encodeAttribute(String.valueOf(value));
                SVGWriter.this.write('\"');
            }
        }

        private void encodeAttribute(String inData) throws IOException {
            if (inData == null) {
                return;
            }
            int length = inData.length();
            for (int i = 0; i < length; ++i) {
                char charToCompare = inData.charAt(i);
                if (charToCompare == '\"') {
                    SVGWriter.this.write("&quot;");
                    continue;
                }
                if (charToCompare > '\u007f') {
                    this.writeUnicodeEscapeSequence(charToCompare);
                    continue;
                }
                SVGWriter.this.write(charToCompare);
            }
        }

        private void writeUnicodeEscapeSequence(char c) throws IOException {
            SVGWriter.this.write("&#x");
            String hex = Integer.toHexString(c);
            int pendingZeros = 4 - hex.length();
            for (int i = 0; i < pendingZeros; ++i) {
                SVGWriter.this.write('0');
            }
            SVGWriter.this.write(hex);
            SVGWriter.this.write(';');
        }
    }

    public class BoundsSVGHandler
    extends SVGFeatureWriterHandler {
        private SVGFeatureWriterHandler handler;

        public BoundsSVGHandler(SVGFeatureWriterHandler handler) {
            this.handler = handler;
        }

        public void startFeature(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            this.handler.startFeature(featureWriter, ft);
            Geometry geom = (Geometry)ft.getDefaultGeometry();
            Envelope env = geom.getEnvelopeInternal();
            SVGWriter.this.write(" bounds=\"");
            SVGWriter.this.write(env.getMinX());
            SVGWriter.this.write(' ');
            SVGWriter.this.write(env.getMinY());
            SVGWriter.this.write(' ');
            SVGWriter.this.write(env.getMaxX());
            SVGWriter.this.write(' ');
            SVGWriter.this.write(env.getMaxY());
            SVGWriter.this.write('\"');
        }
    }

    public class FIDSVGHandler
    extends SVGFeatureWriterHandler {
        private SVGFeatureWriterHandler handler;

        public FIDSVGHandler(SVGFeatureWriterHandler handler) {
            this.handler = handler;
        }

        public void startFeature(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            this.handler.startFeature(featureWriter, ft);
            SVGWriter.this.write(" id=\"");
            try {
                SVGWriter.this.write(ft.getID());
            }
            catch (IOException ex) {
                System.err.println("error getting fid from " + ft);
                throw ex;
            }
            SVGWriter.this.write("\"");
        }
    }

    public class CollectSVGHandler
    extends SVGFeatureWriterHandler {
        private SVGFeatureWriter featureWriter;

        public CollectSVGHandler(SVGFeatureWriter featureWriter) {
            this.featureWriter = featureWriter;
        }

        public void writeFeature(SimpleFeature ft) throws IOException {
            this.featureWriter.writeGeometry((Geometry)ft.getDefaultGeometry());
            SVGWriter.this.write('\n');
        }
    }

    public class SVGFeatureWriterHandler {
        public void startFeature(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            featureWriter.startElement(ft);
        }

        public void endFeature(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            featureWriter.endElement(ft);
        }

        public void startGeometry(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            featureWriter.startGeometry((Geometry)ft.getDefaultGeometry());
        }

        public void writeGeometry(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            featureWriter.writeGeometry((Geometry)ft.getDefaultGeometry());
        }

        public void endGeometry(SVGFeatureWriter featureWriter, SimpleFeature ft) throws IOException {
            featureWriter.endGeometry((Geometry)ft.getDefaultGeometry());
        }
    }
}

