/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.util.Vector;
import org.gdal.gdal.Band;
import org.gdal.gdal.Driver;
import org.gdal.gdal.GCP;
import org.gdal.gdal.MajorObject;
import org.gdal.gdal.gdalJNI;

public class Dataset
extends MajorObject {
    private long swigCPtr;

    protected Dataset(long cPtr, boolean cMemoryOwn) {
        super(gdalJNI.SWIGDatasetUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Dataset obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            gdalJNI.delete_Dataset(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtrAndDisown(Dataset obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return Dataset.getCPtr(obj);
    }

    public int getRasterXSize() {
        return gdalJNI.Dataset_RasterXSize_get(this.swigCPtr, this);
    }

    public int getRasterYSize() {
        return gdalJNI.Dataset_RasterYSize_get(this.swigCPtr, this);
    }

    public int getRasterCount() {
        return gdalJNI.Dataset_RasterCount_get(this.swigCPtr, this);
    }

    public Driver GetDriver() {
        long cPtr = gdalJNI.Dataset_GetDriver(this.swigCPtr, this);
        return cPtr == 0L ? null : new Driver(cPtr, false);
    }

    public Band GetRasterBand(int nBand) {
        long cPtr = gdalJNI.Dataset_GetRasterBand(this.swigCPtr, this, nBand);
        return cPtr == 0L ? null : new Band(cPtr, false);
    }

    public String GetProjection() {
        return gdalJNI.Dataset_GetProjection(this.swigCPtr, this);
    }

    public String GetProjectionRef() {
        return gdalJNI.Dataset_GetProjectionRef(this.swigCPtr, this);
    }

    public int SetProjection(String prj) {
        return gdalJNI.Dataset_SetProjection(this.swigCPtr, this, prj);
    }

    public void GetGeoTransform(double[] argout) {
        gdalJNI.Dataset_GetGeoTransform(this.swigCPtr, this, argout);
    }

    public int SetGeoTransform(double[] argin) {
        return gdalJNI.Dataset_SetGeoTransform(this.swigCPtr, this, argin);
    }

    public int BuildOverviews(String resampling, int[] overviewlist) {
        return gdalJNI.Dataset_BuildOverviews(this.swigCPtr, this, resampling, overviewlist);
    }

    public int GetGCPCount() {
        return gdalJNI.Dataset_GetGCPCount(this.swigCPtr, this);
    }

    public String GetGCPProjection() {
        return gdalJNI.Dataset_GetGCPProjection(this.swigCPtr, this);
    }

    public void GetGCPs(Vector nGCPs) {
        gdalJNI.Dataset_GetGCPs(this.swigCPtr, this, nGCPs);
    }

    public int SetGCPs(int nGCPs, GCP pGCPs, String pszGCPProjection) {
        return gdalJNI.Dataset_SetGCPs(this.swigCPtr, this, nGCPs, GCP.getCPtr(pGCPs), pGCPs, pszGCPProjection);
    }

    public void FlushCache() {
        gdalJNI.Dataset_FlushCache(this.swigCPtr, this);
    }

    public int AddBand(int datatype, Vector options) {
        return gdalJNI.Dataset_AddBand(this.swigCPtr, this, datatype, options);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, char[] buf_len, int[] buf_xsize, int[] buf_ysize, int[] buf_type, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_len, buf_xsize, buf_ysize, buf_type, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, char[][] buf_len, int[] buf_xsize, int[] buf_ysize, int[] buf_type, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_len, buf_xsize, buf_ysize, buf_type, band_list);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int bands, byte[] buf) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, bands, buf);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int bands, int[] bandsMap, int pixelSpace, int lineSpace, int bandSpace, byte[] buf) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, bands, bandsMap, pixelSpace, lineSpace, bandSpace, buf);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int bands, int pixelSpace, int lineSpace, int bandSpace, byte[] buf) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_2(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, bands, pixelSpace, lineSpace, bandSpace, buf);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int bands, byte[] buf) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, bands, buf);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int bands, int pixelSpace, int lineSpace, int bandSpace, byte[] buf) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, bands, pixelSpace, lineSpace, bandSpace, buf);
    }
}

