/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeRemovalReporter
implements CatalogVisitor {
    Catalog catalog;
    Map<CatalogInfo, ModificationType> objects;
    Map<LayerGroupInfo, Set<LayerInfo>> groups;

    public CascadeRemovalReporter(Catalog catalog) {
        this.catalog = catalog;
        this.reset();
    }

    @Override
    public void visit(Catalog catalog) {
    }

    public void reset() {
        this.objects = new HashMap<CatalogInfo, ModificationType>();
        this.groups = new HashMap<LayerGroupInfo, Set<LayerInfo>>();
    }

    public <T> List<T> getObjects(Class<T> catalogClass, ModificationType ... modifications) {
        ArrayList<CatalogInfo> result = new ArrayList<CatalogInfo>();
        List<ModificationType> mods = modifications == null || modifications.length == 0 ? null : Arrays.asList(modifications);
        for (CatalogInfo ci : this.objects.keySet()) {
            if (catalogClass != null && !catalogClass.isAssignableFrom(ci.getClass()) || mods != null && !mods.contains((Object)this.objects.get(ci))) continue;
            result.add(ci);
        }
        return result;
    }

    public void removeAll(Collection<? extends CatalogInfo> objects) {
        for (CatalogInfo catalogInfo : objects) {
            this.objects.remove(catalogInfo);
        }
    }

    void add(CatalogInfo ci, ModificationType type) {
        ModificationType oldType = this.objects.get(ci);
        if (oldType == null || oldType.compareTo(type) > 0) {
            this.objects.put(ci, type);
        }
    }

    @Override
    public void visit(WorkspaceInfo workspace) {
        List<StoreInfo> stores = this.catalog.getStoresByWorkspace(workspace, StoreInfo.class);
        for (StoreInfo storeInfo : stores) {
            storeInfo.accept(this);
        }
        this.add(workspace, ModificationType.DELETE);
    }

    @Override
    public void visit(NamespaceInfo namespace) {
        this.add(namespace, ModificationType.DELETE);
    }

    @Override
    public void visit(DataStoreInfo dataStore) {
        this.visitStore(dataStore);
    }

    @Override
    public void visit(CoverageStoreInfo coverageStore) {
        this.visitStore(coverageStore);
    }

    void visitStore(StoreInfo dataStore) {
        List<ResourceInfo> resources = this.catalog.getResourcesByStore(dataStore, ResourceInfo.class);
        for (ResourceInfo ri : resources) {
            List<LayerInfo> layers = this.catalog.getLayers(ri);
            for (LayerInfo li : layers) {
                li.accept(this);
            }
        }
        this.add(dataStore, ModificationType.DELETE);
    }

    @Override
    public void visit(FeatureTypeInfo featureType) {
        this.add(featureType, ModificationType.DELETE);
    }

    @Override
    public void visit(CoverageInfo coverage) {
        this.add(coverage, ModificationType.DELETE);
    }

    @Override
    public void visit(LayerInfo layer) {
        this.add(layer.getResource(), ModificationType.DELETE);
        this.add(layer, ModificationType.DELETE);
        for (LayerGroupInfo group : this.catalog.getLayerGroups()) {
            if (!group.getLayers().contains(layer)) continue;
            Set<LayerInfo> layers = this.groups.get(group);
            if (layers == null) {
                layers = new HashSet<LayerInfo>();
                this.groups.put(group, layers);
            }
            layers.add(layer);
            if (layers.size() == new HashSet<LayerInfo>(group.getLayers()).size()) {
                this.add(group, ModificationType.DELETE);
                continue;
            }
            this.add(group, ModificationType.GROUP_CHANGED);
        }
    }

    @Override
    public void visit(StyleInfo style) {
        List<LayerInfo> layer = this.catalog.getLayers();
        for (LayerInfo li : layer) {
            if (style.equals(li.getDefaultStyle())) {
                this.add(li, ModificationType.STYLE_RESET);
                continue;
            }
            if (!li.getStyles().contains(style)) continue;
            this.add(li, ModificationType.EXTRA_STYLE_REMOVED);
        }
        List<LayerGroupInfo> groups = this.catalog.getLayerGroups();
        for (LayerGroupInfo group : groups) {
            if (!group.getStyles().contains(style)) continue;
            this.add(group, ModificationType.GROUP_CHANGED);
        }
        this.add(style, ModificationType.DELETE);
    }

    @Override
    public void visit(LayerGroupInfo layerGroup) {
        this.add(layerGroup, ModificationType.DELETE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModificationType {
        DELETE,
        STYLE_RESET,
        EXTRA_STYLE_REMOVED,
        GROUP_CHANGED;

    }
}

