/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.catalog.util.LegacyCatalogReader;
import org.geoserver.catalog.util.LegacyFeatureTypeInfoReader;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.GeoServerPersister;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerLoader
implements BeanPostProcessor,
DisposableBean,
ApplicationContextAware {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    GeoServerResourceLoader resourceLoader;
    GeoServer geoserver;
    XStreamPersisterFactory xpf = new XStreamPersisterFactory();
    static boolean legacy = false;

    public GeoServerLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        GeoserverDataDirectory.init((WebApplicationContext)applicationContext);
    }

    public void setXStreamPeristerFactory(XStreamPersisterFactory xpf) {
        this.xpf = xpf;
    }

    public static void setLegacy(boolean legacy) {
        GeoServerLoader.legacy = legacy;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Catalog) {
            if (bean instanceof Wrapper && ((Wrapper)bean).isWrapperFor(Catalog.class)) {
                return bean;
            }
            try {
                Catalog catalog = (Catalog)bean;
                XStreamPersister xp = this.xpf.createXMLPersister();
                xp.setCatalog(catalog);
                this.loadCatalog(catalog, xp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (bean instanceof GeoServer) {
            this.geoserver = (GeoServer)bean;
            try {
                this.loadGeoServer(this.geoserver, this.xpf.createXMLPersister());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return bean;
    }

    protected void loadCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        File f = this.resourceLoader.find("catalog.xml");
        if (f == null) {
            CatalogImpl catalog2 = (CatalogImpl)this.readCatalog(xp);
            ((CatalogImpl)catalog).sync(catalog2);
        } else {
            CatalogImpl catalog2 = (CatalogImpl)this.readLegacyCatalog(f, xp);
            ((CatalogImpl)catalog).sync(catalog2);
        }
        this.initializeStyles(catalog);
        if (!legacy) {
            catalog.addListener(new GeoServerPersister(this.resourceLoader, xp));
        }
    }

    protected void loadGeoServer(final GeoServer geoServer, XStreamPersister xp) throws Exception {
        final List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
        geoServer.addListener(new ConfigurationListenerAdapter(){

            public void handlePostServiceChange(ServiceInfo service) {
                for (XStreamServiceLoader l : loaders) {
                    if (!l.getServiceClass().isInstance(service)) continue;
                    try {
                        l.save(service, geoServer);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
        File f = this.resourceLoader.find("services.xml");
        if (f == null) {
            BufferedInputStream in;
            f = this.resourceLoader.find("global.xml");
            if (f != null) {
                in = new BufferedInputStream(new FileInputStream(f));
                GeoServerInfoImpl global = (GeoServerInfoImpl)this.xpf.createXMLPersister().load(in, GeoServerInfo.class);
                if (global.getMetadata() == null) {
                    global.setMetadata(new MetadataMap());
                }
                if (global.getClientProperties() == null) {
                    global.setClientProperties(new HashMap<Object, Object>());
                }
                geoServer.setGlobal(global);
            }
            if ((f = this.resourceLoader.find("logging.xml")) != null) {
                in = new BufferedInputStream(new FileInputStream(f));
                LoggingInfo logging = this.xpf.createXMLPersister().load(in, LoggingInfo.class);
                geoServer.setLogging(logging);
            }
            for (XStreamServiceLoader l : loaders) {
                try {
                    Object s = l.load(geoServer);
                    geoServer.add((ServiceInfo)s);
                    LOGGER.info("Loaded service '" + s.getId() + "', " + (s.isEnabled() ? "enabled" : "disabled"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
            geoServer.addListener(p);
            new LegacyConfigurationImporter(geoServer).imprt(this.resourceLoader.getBaseDirectory());
            geoServer.removeListener(p);
            f.renameTo(new File(f.getParentFile(), "services.xml.old"));
        }
        List initializers = GeoServerExtensions.extensions(GeoServerInitializer.class);
        for (GeoServerInitializer initer : initializers) {
            try {
                initer.initialize(geoServer);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        geoServer.addListener(new GeoServerPersister(this.resourceLoader, xp));
    }

    protected void initialize() {
        LegacyCatalogImporter catalogImporter = new LegacyCatalogImporter();
        catalogImporter.setResourceLoader(this.resourceLoader);
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper && ((Wrapper)((Object)catalog)).isWrapperFor(Catalog.class)) {
            catalog = ((Wrapper)((Object)catalog)).unwrap(Catalog.class);
        }
        catalogImporter.setCatalog(catalog);
        try {
            catalogImporter.imprt(this.resourceLoader.getBaseDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LegacyConfigurationImporter importer = new LegacyConfigurationImporter();
        importer.setConfiguration(this.geoserver);
        try {
            importer.imprt(this.resourceLoader.getBaseDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List initializers = GeoServerExtensions.extensions(GeoServerInitializer.class);
        for (GeoServerInitializer initer : initializers) {
            try {
                initer.initialize(this.geoserver);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        List catalogListeners = GeoServerExtensions.extensions(CatalogListener.class);
        for (CatalogListener l : catalogListeners) {
            catalog.addListener(l);
        }
        List configListeners = GeoServerExtensions.extensions(ConfigurationListener.class);
        for (ConfigurationListener l : configListeners) {
            this.geoserver.addListener(l);
        }
    }

    void initializeStyles(Catalog catalog) throws IOException {
        if (catalog.getStyleByName("point") == null) {
            this.initializeStyle(catalog, "point", "default_point.sld");
        }
        if (catalog.getStyleByName("line") == null) {
            this.initializeStyle(catalog, "line", "default_line.sld");
        }
        if (catalog.getStyleByName("polygon") == null) {
            this.initializeStyle(catalog, "polygon", "default_line.sld");
        }
        if (catalog.getStyleByName("raster") == null) {
            this.initializeStyle(catalog, "raster", "default_raster.sld");
        }
    }

    void initializeStyle(Catalog catalog, String styleName, String sld) throws IOException {
        if (this.resourceLoader.find(new String[]{"styles", sld}) == null) {
            FileUtils.copyURLToFile((URL)this.getClass().getResource(sld), (File)new File(this.resourceLoader.find("styles"), sld));
        }
        StyleInfo s = catalog.getFactory().createStyle();
        s.setName(styleName);
        s.setFilename(sld);
        catalog.add(s);
    }

    public void reload() throws Exception {
        this.destroy();
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper) {
            catalog = ((Wrapper)((Object)this.geoserver.getCatalog())).unwrap(Catalog.class);
        }
        XStreamPersister xp = this.xpf.createXMLPersister();
        xp.setCatalog(catalog);
        this.loadCatalog(catalog, xp);
        this.loadGeoServer(this.geoserver, xp);
    }

    public void persist() throws Exception {
        XStreamPersister p = this.xpf.createXMLPersister();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.resourceLoader.createFile("catalog2.xml")));
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper) {
            catalog = ((Wrapper)((Object)catalog)).unwrap(Catalog.class);
        }
        p.save(catalog, out);
        out.flush();
        out.close();
        File workspaces = this.resourceLoader.findOrCreateDirectory("workspaces");
        for (ResourceInfo r : catalog.getResources(ResourceInfo.class)) {
            String dirName;
            File dir;
            WorkspaceInfo ws = r.getStore().getWorkspace();
            File file = new File(workspaces, ws.getName());
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(dir = new File(file, dirName = r.getStore().getName() + "_" + r.getNativeName())).exists()) {
                dir.mkdir();
            }
            File info = new File(dir, "resource.xml");
            try {
                this.persist(p, r, info);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error persisting '" + r.getName() + "'", e);
            }
            LayerInfo l = catalog.getLayers(r).get(0);
            try {
                this.persist(p, l, new File(dir, "layer.xml"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error persisting layer '" + l.getName() + "'", e);
            }
        }
        try {
            this.persist(p, this.geoserver.getGlobal(), this.resourceLoader.createFile("global.xml"));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error persisting global configuration.", e);
        }
        Collection<? extends ServiceInfo> services = this.geoserver.getServices();
        List loaders = GeoServerExtensions.extensions(ServiceLoader.class);
        block9: for (ServiceInfo serviceInfo : services) {
            for (ServiceLoader loader : loaders) {
                if (!loader.getServiceClass().isInstance(serviceInfo)) continue;
                try {
                    loader.save(serviceInfo, this.geoserver);
                    continue block9;
                }
                catch (Throwable t) {
                    LOGGER.warning("Error persisting service: " + serviceInfo.getId());
                    LOGGER.log(Level.INFO, "", t);
                }
            }
        }
    }

    Catalog readCatalog(XStreamPersister xp) throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        catalog.setResourceLoader(this.resourceLoader);
        xp.setCatalog(catalog);
        CatalogFactory factory = catalog.getFactory();
        File styles = this.resourceLoader.find("styles");
        for (File sf : this.list(styles, (IOFileFilter)new SuffixFileFilter(".xml"))) {
            try {
                if (new File(styles, sf.getName() + ".xml").exists()) continue;
                StyleInfo s = this.depersist(xp, sf, StyleInfo.class);
                catalog.add(s);
                LOGGER.info("Loaded style '" + s.getName() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load style from file '" + sf.getName() + "'", e);
            }
        }
        File workspaces = this.resourceLoader.find("workspaces");
        if (workspaces != null) {
            File dws = new File(workspaces, "default.xml");
            WorkspaceInfo defaultWorkspace = null;
            if (dws.exists()) {
                try {
                    defaultWorkspace = this.depersist(xp, dws, WorkspaceInfo.class);
                    LOGGER.info("Loaded default workspace " + defaultWorkspace.getName());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load default workspace", e);
                }
            } else {
                LOGGER.warning("No default workspace was found.");
            }
            for (File wsd : this.list(workspaces, DirectoryFileFilter.INSTANCE)) {
                File f = new File(wsd, "workspace.xml");
                if (!f.exists()) continue;
                WorkspaceInfo ws = null;
                try {
                    ws = this.depersist(xp, f, WorkspaceInfo.class);
                    catalog.add(ws);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load workspace '" + wsd.getName() + "'", e);
                    continue;
                }
                LOGGER.info("Loaded workspace '" + ws.getName() + "'");
                File nsf = new File(wsd, "namespace.xml");
                NamespaceInfo ns = null;
                if (nsf.exists()) {
                    try {
                        ns = this.depersist(xp, nsf, NamespaceInfo.class);
                        catalog.add(ns);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to load namespace for '" + wsd.getName() + "'", e);
                    }
                }
                if (defaultWorkspace != null) {
                    if (!ws.getName().equals(defaultWorkspace.getName())) continue;
                    catalog.setDefaultWorkspace(ws);
                    if (ns == null) continue;
                    catalog.setDefaultNamespace(ns);
                    continue;
                }
                defaultWorkspace = catalog.getDefaultWorkspace();
                if (defaultWorkspace == null) continue;
                try {
                    this.persist(xp, defaultWorkspace, dws);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to persist default workspace '" + wsd.getName() + "'", e);
                }
            }
            for (File wsd : this.list(workspaces, DirectoryFileFilter.INSTANCE)) {
                for (File sd : this.list(wsd, DirectoryFileFilter.INSTANCE)) {
                    LayerInfo l;
                    File f = new File(sd, "datastore.xml");
                    if (f.exists()) {
                        DataStoreInfo ds;
                        block44: {
                            ds = null;
                            try {
                                ds = this.depersist(xp, f, DataStoreInfo.class);
                                catalog.add(ds);
                                LOGGER.info("Loaded data store '" + ds.getName() + "'");
                                if (!ds.isEnabled()) break block44;
                                try {
                                    ds.getDataStore(null);
                                }
                                catch (Throwable t) {
                                    LOGGER.warning("Error connecting to '" + ds.getName() + "'. Disabling.");
                                    LOGGER.log(Level.INFO, "", t);
                                    ds.setError(t);
                                    ds.setEnabled(false);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Failed to load data store '" + sd.getName() + "'", e);
                                continue;
                            }
                        }
                        for (File ftd : this.list(sd, DirectoryFileFilter.INSTANCE)) {
                            f = new File(ftd, "featuretype.xml");
                            if (f.exists()) {
                                FeatureTypeInfo ft = null;
                                try {
                                    ft = this.depersist(xp, f, FeatureTypeInfo.class);
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load feature type '" + ftd.getName() + "'", e);
                                    continue;
                                }
                                catalog.add(ft);
                                LOGGER.info("Loaded feature type '" + ds.getName() + "'");
                                f = new File(ftd, "layer.xml");
                                if (!f.exists()) continue;
                                try {
                                    l = this.depersist(xp, f, LayerInfo.class);
                                    catalog.add(l);
                                    LOGGER.info("Loaded layer '" + l.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load layer for feature type '" + ft.getName() + "'", e);
                                }
                                continue;
                            }
                            LOGGER.warning("Ignoring feature type directory " + ftd.getAbsolutePath());
                        }
                        continue;
                    }
                    f = new File(sd, "coveragestore.xml");
                    if (f.exists()) {
                        CoverageStoreInfo cs = null;
                        try {
                            cs = this.depersist(xp, f, CoverageStoreInfo.class);
                            catalog.add(cs);
                            LOGGER.info("Loaded coverage store '" + cs.getName() + "'");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to load coverage store '" + sd.getName() + "'", e);
                            continue;
                        }
                        for (File cd : this.list(sd, DirectoryFileFilter.INSTANCE)) {
                            f = new File(cd, "coverage.xml");
                            if (f.exists()) {
                                CoverageInfo c = null;
                                try {
                                    c = this.depersist(xp, f, CoverageInfo.class);
                                    catalog.add(c);
                                    LOGGER.info("Loaded coverage '" + cs.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load coverage '" + cd.getName() + "'", e);
                                    continue;
                                }
                                f = new File(cd, "layer.xml");
                                if (!f.exists()) continue;
                                try {
                                    l = this.depersist(xp, f, LayerInfo.class);
                                    catalog.add(l);
                                    LOGGER.info("Loaded layer '" + l.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load layer coverage '" + c.getName() + "'", e);
                                }
                                continue;
                            }
                            LOGGER.warning("Ignoring coverage directory " + cd.getAbsolutePath());
                        }
                        continue;
                    }
                    LOGGER.warning("Ignoring store directory '" + sd.getName() + "'");
                }
            }
        } else {
            LOGGER.warning("No 'workspaces' directory found, unable to load any stores.");
        }
        File layergroups = this.resourceLoader.find("layergroups");
        if (layergroups != null) {
            for (File lgf : this.list(layergroups, (IOFileFilter)new SuffixFileFilter(".xml"))) {
                try {
                    LayerGroupInfo lg = this.depersist(xp, lgf, LayerGroupInfo.class);
                    catalog.add(lg);
                    LOGGER.info("Loaded layer group '" + lg.getName() + "'");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load layer group '" + lgf.getName() + "'", e);
                }
            }
        }
        return catalog;
    }

    Catalog readLegacyCatalog(File f, XStreamPersister xp) throws Exception {
        CatalogImpl catalog2 = new CatalogImpl();
        catalog2.setResourceLoader(this.resourceLoader);
        GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
        if (!legacy) {
            catalog2.addListener(p);
        }
        LegacyCatalogImporter importer = new LegacyCatalogImporter(catalog2);
        importer.setResourceLoader(this.resourceLoader);
        importer.imprt(this.resourceLoader.getBaseDirectory());
        if (!legacy) {
            catalog2.removeListener(p);
        }
        if (!legacy) {
            File featureTypesDir = this.resourceLoader.find("featureTypes");
            if (featureTypesDir != null) {
                LegacyCatalogReader creader = new LegacyCatalogReader();
                creader.read(f);
                Map<String, Map<String, Object>> dataStores = creader.dataStores();
                for (File featureTypeDir : featureTypesDir.listFiles()) {
                    File featureTypeInfo;
                    if (!featureTypeDir.isDirectory() || !(featureTypeInfo = new File(featureTypeDir, "info.xml")).exists()) continue;
                    LegacyFeatureTypeInfoReader reader = new LegacyFeatureTypeInfoReader();
                    reader.read(featureTypeInfo);
                    Map<String, Object> dataStore = dataStores.get(reader.dataStore());
                    if (dataStore == null) continue;
                    String namespace = (String)dataStore.get("namespace");
                    File destFeatureTypeDir = this.resourceLoader.find(new String[]{"workspaces", namespace, reader.dataStore(), reader.name()});
                    if (destFeatureTypeDir == null) continue;
                    for (File file : featureTypeDir.listFiles()) {
                        if (!file.isFile() || featureTypeInfo.equals(file)) continue;
                        FileUtils.copyFile((File)file, (File)new File(destFeatureTypeDir, file.getName()));
                    }
                }
            }
            f.renameTo(new File(f.getParentFile(), "catalog.xml.old"));
        }
        return catalog2;
    }

    void persist(XStreamPersister xp, Object obj, File f) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        xp.save(obj, out);
        out.flush();
        out.close();
    }

    <T> T depersist(XStreamPersister xp, File f, Class<T> clazz) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        T obj = xp.load(in, clazz);
        in.close();
        return obj;
    }

    Collection<File> list(File d, IOFileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : d.listFiles()) {
            if (!filter.accept(f)) continue;
            files.add(f);
        }
        return files;
    }

    public void destroy() throws Exception {
        this.geoserver.dispose();
    }
}

