/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geoserver.feature.DecoratingFeatureCollection;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReprojectingFeatureCollection
extends DecoratingFeatureCollection {
    SimpleFeatureType schema;
    CoordinateReferenceSystem target;
    CoordinateReferenceSystem defaultSource;
    HashMap transformers;
    Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);

    public ReprojectingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, CoordinateReferenceSystem target) throws SchemaException, OperationNotFoundException, FactoryRegistryException, FactoryException {
        super(delegate);
        this.target = target;
        this.schema = FeatureTypes.transform((SimpleFeatureType)((SimpleFeatureType)delegate.getSchema()), (CoordinateReferenceSystem)target);
        this.transformers = new HashMap();
        CoordinateReferenceSystem source = ((SimpleFeatureType)delegate.getSchema()).getCoordinateReferenceSystem();
        if (source == null) {
            throw new RuntimeException("Source was null in trying to create a reprojected feature collection!");
        }
        MathTransform2D tx = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints).createOperation(source, target).getMathTransform();
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        transformer.setMathTransform((MathTransform)tx);
        this.transformers.put(source, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        FeatureIterator<SimpleFeature> it = this.features();
        try {
            while (it.hasNext()) {
                visitor.visit(it.next());
            }
        }
        finally {
            this.close(it);
        }
    }

    public void setDefaultSource(CoordinateReferenceSystem defaultSource) {
        this.defaultSource = defaultSource;
    }

    public FeatureIterator<SimpleFeature> features() {
        return new ReprojectingFeatureIterator((FeatureIterator<SimpleFeature>)this.delegate.features());
    }

    public Iterator iterator() {
        return new ReprojectingIterator(this.delegate.iterator());
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        if (iterator instanceof ReprojectingFeatureIterator) {
            this.delegate.close(((ReprojectingFeatureIterator)iterator).getDelegate());
        }
        iterator.close();
    }

    public void close(Iterator iterator) {
        if (iterator instanceof ReprojectingIterator) {
            this.delegate.close(((ReprojectingIterator)iterator).getDelegate());
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> subCollection(Filter filter) {
        FeatureCollection sub = this.delegate.subCollection(filter);
        if (sub != null) {
            try {
                ReprojectingFeatureCollection wrapper = new ReprojectingFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)sub, this.target);
                wrapper.setDefaultSource(this.defaultSource);
                return wrapper;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Object[] toArray() {
        Object[] array = this.delegate.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.reproject((SimpleFeature)array[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    public Object[] toArray(Object[] a) {
        Object[] array = this.delegate.toArray(a);
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.reproject((SimpleFeature)array[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds = null;
        Iterator i = this.iterator();
        try {
            if (!i.hasNext()) {
                bounds = new ReferencedEnvelope();
                bounds.setToNull();
            } else {
                SimpleFeature first = (SimpleFeature)i.next();
                bounds = new ReferencedEnvelope(first.getBounds());
            }
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                bounds.include(f.getBounds());
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
        finally {
            this.close(i);
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> collection() throws IOException {
        return this;
    }

    SimpleFeature reproject(SimpleFeature feature) throws IOException {
        Object[] attributes = new Object[this.schema.getAttributeCount()];
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor type = this.schema.getDescriptor(i);
            Object object = feature.getAttribute(type.getName());
            if (object instanceof Geometry) {
                Geometry geometry = (Geometry)object;
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)geometry.getUserData();
                if (crs == null && this.defaultSource != null) {
                    crs = this.defaultSource;
                }
                if (crs != null && !crs.equals(this.target)) {
                    GeometryCoordinateSequenceTransformer transformer = (GeometryCoordinateSequenceTransformer)this.transformers.get(crs);
                    if (transformer == null) {
                        MathTransform2D tx;
                        transformer = new GeometryCoordinateSequenceTransformer();
                        try {
                            tx = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints).createOperation(crs, this.target).getMathTransform();
                        }
                        catch (Exception e) {
                            String msg = "Could not transform for crs: " + crs;
                            throw (IOException)new IOException(msg).initCause(e);
                        }
                        transformer.setMathTransform((MathTransform)tx);
                        this.transformers.put(crs, transformer);
                    }
                    try {
                        object = transformer.transform(geometry);
                    }
                    catch (TransformException e) {
                        String msg = "Error occured transforming " + geometry.toString();
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                }
            }
            attributes[i] = object;
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])attributes, (String)feature.getID());
        }
        catch (IllegalAttributeException e) {
            String msg = "Error creating reprojeced feature";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReprojectingIterator
    implements Iterator<SimpleFeature> {
        Iterator<SimpleFeature> delegate;

        public ReprojectingIterator(Iterator<SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        public Iterator<SimpleFeature> getDelegate() {
            return this.delegate;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            SimpleFeature feature = this.delegate.next();
            try {
                return ReprojectingFeatureCollection.this.reproject(feature);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReprojectingFeatureIterator
    implements FeatureIterator<SimpleFeature> {
        FeatureIterator<SimpleFeature> delegate;

        public ReprojectingFeatureIterator(FeatureIterator<SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        public FeatureIterator<SimpleFeature> getDelegate() {
            return this.delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature feature = (SimpleFeature)this.delegate.next();
            try {
                return ReprojectingFeatureCollection.this.reproject(feature);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.delegate = null;
        }
    }
}

