/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.util.List;
import java.util.logging.Logger;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.LoggingInfo;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LoggingInitializer
implements GeoServerInitializer,
ApplicationContextAware {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.logging");
    GeoServerResourceLoader resourceLoader;
    Boolean relinquishLoggingControl;

    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void initialize(GeoServer geoServer) throws Exception {
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleLoggingChange(LoggingInfo logging, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                if (!LoggingInitializer.this.relinquishLoggingControl.booleanValue()) {
                    boolean reload = false;
                    String loggingLevel = logging.getLevel();
                    String loggingLocation = logging.getLocation();
                    Boolean stdOutLogging = logging.isStdOutLogging();
                    if (propertyNames.contains("level")) {
                        loggingLevel = (String)newValues.get(propertyNames.indexOf("level"));
                        reload = true;
                    }
                    if (propertyNames.contains("location")) {
                        loggingLocation = (String)newValues.get(propertyNames.indexOf("location"));
                        reload = true;
                    }
                    if (propertyNames.contains("stdOutLogging")) {
                        stdOutLogging = (Boolean)newValues.get(propertyNames.indexOf("stdOutLogging"));
                        reload = true;
                    }
                    if (reload) {
                        try {
                            LoggingUtils.initLogging(LoggingInitializer.this.resourceLoader, loggingLevel, stdOutLogging == false, loggingLocation);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String strValue = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ApplicationContext)applicationContext);
        this.relinquishLoggingControl = Boolean.valueOf(strValue);
    }
}

