/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.fs.FileSystem;
import org.h2.util.ByteUtils;
import org.h2.util.NetUtils;
import org.h2.util.RandomUtils;
import org.h2.util.SortedProperties;
import org.h2.value.Transfer;

public class FileLock {
    public static final int LOCK_NO = 0;
    public static final int LOCK_FILE = 1;
    public static final int LOCK_SOCKET = 2;
    private static final String MAGIC = "FileLock";
    private static final String FILE = "file";
    private static final String SOCKET = "socket";
    private static final int RANDOM_BYTES = 16;
    private static final int SLEEP_GAP = 25;
    private static final int TIME_GRANULARITY = 2000;
    volatile String fileName;
    volatile ServerSocket socket;
    FileSystem fs;
    int sleep;
    Trace trace;
    long lastWrite;
    private String method;
    private String ipAddress;
    private Properties properties;
    private boolean locked;
    private String uniqueId;

    public FileLock(TraceSystem traceSystem, int n) {
        this.trace = traceSystem.getTrace("fileLock");
        this.sleep = n;
    }

    public synchronized void lock(String string, boolean bl) throws SQLException {
        this.fs = FileSystem.getInstance(string);
        this.fileName = string;
        this.checkServer();
        if (this.locked) {
            throw Message.getInternalError("already locked");
        }
        if (bl) {
            this.lockSocket();
        } else {
            this.lockFile();
        }
        this.locked = true;
    }

    public synchronized void unlock() {
        if (!this.locked) {
            return;
        }
        try {
            if (this.fileName != null && this.load().equals(this.properties)) {
                this.fs.delete(this.fileName);
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            this.trace.debug("unlock", exception);
        }
        this.fileName = null;
        this.socket = null;
        this.locked = false;
    }

    public void addProperty(String string, String string2) throws SQLException {
        this.properties.put(string, string2);
        this.save();
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (this.locked) {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws SQLException {
        try {
            OutputStream outputStream = this.fs.openFileOutputStream(this.fileName, false);
            try {
                this.properties.setProperty("method", String.valueOf(this.method));
                this.properties.store(outputStream, MAGIC);
            }
            finally {
                outputStream.close();
            }
            this.lastWrite = this.fs.getLastModified(this.fileName);
            this.trace.debug("save " + this.properties);
        }
        catch (IOException iOException) {
            throw this.getException(iOException);
        }
    }

    private void checkServer() throws SQLException {
        Object object;
        Object object2;
        Properties properties = this.load();
        String string = properties.getProperty("server");
        if (string == null) {
            return;
        }
        boolean bl = false;
        String string2 = properties.getProperty("id");
        try {
            object2 = NetUtils.createSocket(string, 9092, false);
            object = new Transfer(null);
            ((Transfer)object).setSocket((Socket)object2);
            ((Transfer)object).init();
            ((Transfer)object).writeInt(6);
            ((Transfer)object).writeInt(6);
            ((Transfer)object).writeString(null);
            ((Transfer)object).writeString(null);
            ((Transfer)object).writeString(string2);
            ((Transfer)object).writeInt(14);
            ((Transfer)object).flush();
            int n = ((Transfer)object).readInt();
            if (n == 1) {
                bl = true;
            }
            ((Transfer)object).close();
            ((Socket)object2).close();
        }
        catch (IOException iOException) {
            return;
        }
        if (bl) {
            object2 = string + "/" + string2;
            object = Message.getSQLException(90020, "Server is running");
            ((JdbcSQLException)object).setPayload(object2);
            throw object;
        }
    }

    private Properties load() throws SQLException {
        try {
            SortedProperties sortedProperties = SortedProperties.loadProperties(this.fileName);
            this.trace.debug("load " + sortedProperties);
            return sortedProperties;
        }
        catch (IOException iOException) {
            throw this.getException(iOException);
        }
    }

    private void waitUntilOld() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            long l = this.fs.getLastModified(this.fileName);
            long l2 = System.currentTimeMillis() - l;
            if (l2 < -2000L) {
                throw this.error("Lock file modified in the future: dist=" + l2);
            }
            if (l2 < 25L) {
                try {
                    Thread.sleep(l2 + 1L);
                }
                catch (Exception exception) {
                    this.trace.debug("sleep", exception);
                }
                continue;
            }
            return;
        }
        throw this.error("Lock file recently modified");
    }

    private void setUniqueId() {
        byte[] byArray = RandomUtils.getSecureBytes(16);
        String string = ByteUtils.convertBytesToString(byArray);
        this.uniqueId = Long.toHexString(System.currentTimeMillis()) + string;
        this.properties.setProperty("id", this.uniqueId);
    }

    private void lockFile() throws SQLException {
        Object object;
        this.method = FILE;
        this.properties = new SortedProperties();
        this.setUniqueId();
        if (!this.fs.createNewFile(this.fileName)) {
            this.waitUntilOld();
            object = this.load().getProperty("method", FILE);
            if (!((String)object).equals(FILE)) {
                throw this.error("Unsupported lock method " + (String)object);
            }
            this.save();
            this.sleep(2 * this.sleep);
            if (!this.load().equals(this.properties)) {
                throw this.error("Locked by another process");
            }
            this.fs.delete(this.fileName);
            if (!this.fs.createNewFile(this.fileName)) {
                throw this.error("Another process was faster");
            }
        }
        this.save();
        this.sleep(25);
        if (!this.load().equals(this.properties)) {
            this.fileName = null;
            throw this.error("Concurrent update");
        }
        object = new Thread(new Runnable(){

            public void run() {
                try {
                    while (FileLock.this.fileName != null) {
                        try {
                            if (!FileLock.this.fs.exists(FileLock.this.fileName) || FileLock.this.fs.getLastModified(FileLock.this.fileName) != FileLock.this.lastWrite) {
                                FileLock.this.save();
                            }
                            Thread.sleep(FileLock.this.sleep);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            FileLock.this.trace.debug("watchdog", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    FileLock.this.trace.debug("watchdog", exception);
                }
            }
        });
        ((Thread)object).setName("H2 File Lock Watchdog " + this.fileName);
        ((Thread)object).setDaemon(true);
        ((Thread)object).setPriority(9);
        ((Thread)object).start();
    }

    private void lockSocket() throws SQLException {
        this.method = SOCKET;
        this.properties = new SortedProperties();
        this.setUniqueId();
        this.ipAddress = NetUtils.getLocalAddress();
        if (!this.fs.createNewFile(this.fileName)) {
            InetAddress inetAddress;
            this.waitUntilOld();
            long l = this.fs.getLastModified(this.fileName);
            Properties properties = this.load();
            String string = properties.getProperty("method", SOCKET);
            if (string.equals(FILE)) {
                this.lockFile();
                return;
            }
            if (!string.equals(SOCKET)) {
                throw this.error("Unsupported lock method " + string);
            }
            String string2 = properties.getProperty("ipAddress", this.ipAddress);
            if (!this.ipAddress.equals(string2)) {
                throw this.error("Locked by another computer: " + string2);
            }
            String string3 = properties.getProperty("port", "0");
            int n = Integer.parseInt(string3);
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw this.getException(unknownHostException);
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    Socket socket = new Socket(inetAddress, n);
                    socket.close();
                    throw this.error("Locked by another process");
                }
                catch (BindException bindException) {
                    throw this.error("Bind Exception");
                }
                catch (ConnectException connectException) {
                    this.trace.debug("lockSocket not connected " + string3, connectException);
                    continue;
                }
                catch (IOException iOException) {
                    throw this.error("IOException");
                }
            }
            if (l != this.fs.getLastModified(this.fileName)) {
                throw this.error("Concurrent update");
            }
            this.fs.delete(this.fileName);
            if (!this.fs.createNewFile(this.fileName)) {
                throw this.error("Another process was faster");
            }
        }
        try {
            this.socket = NetUtils.createServerSocket(0, false);
            int n = this.socket.getLocalPort();
            this.properties.setProperty("ipAddress", this.ipAddress);
            this.properties.setProperty("port", String.valueOf(n));
        }
        catch (Exception exception) {
            this.trace.debug("lock", exception);
            this.socket = null;
            this.lockFile();
            return;
        }
        this.save();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (FileLock.this.socket != null) {
                    try {
                        FileLock.this.trace.debug("watchdog accept");
                        Socket socket = FileLock.this.socket.accept();
                        socket.close();
                    }
                    catch (Exception exception) {
                        FileLock.this.trace.debug("watchdog", exception);
                    }
                }
                FileLock.this.trace.debug("watchdog end");
            }
        });
        thread.setDaemon(true);
        thread.setName("H2 File Lock Watchdog (Socket) " + this.fileName);
        thread.start();
    }

    private void sleep(int n) throws SQLException {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            throw this.getException(interruptedException);
        }
    }

    private SQLException getException(Throwable throwable) {
        return Message.getSQLException(8000, null, throwable);
    }

    private SQLException error(String string) {
        JdbcSQLException jdbcSQLException = Message.getSQLException(90020, string);
        String string2 = null;
        if (this.fileName != null) {
            try {
                Properties properties = this.load();
                string2 = properties.getProperty("server") + "/" + properties.getProperty("id");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        jdbcSQLException.setPayload(string2);
        return jdbcSQLException;
    }

    public static int getFileLockMethod(String string) throws SQLException {
        if (string == null || string.equalsIgnoreCase("FILE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("NO")) {
            return 0;
        }
        if (string.equalsIgnoreCase("SOCKET")) {
            return 2;
        }
        throw Message.getSQLException(90060, string);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }
}

