/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerPagingNavigator;
import org.geoserver.web.wicket.ParamResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeoServerTablePanel<T>
extends Panel {
    private static final int DEFAULT_ITEMS_PER_PAGE = 25;
    TextField filter;
    DataView dataView;
    WebMarkupContainer listContainer;
    Pager navigatorTop;
    Pager navigatorBottom;
    GeoServerDataProvider<T> dataProvider;
    Form filterForm;
    CheckBox selectAll;
    AjaxButton hiddenSubmit;
    boolean[] selection;
    boolean selectAllValue;

    public GeoServerTablePanel(String id, GeoServerDataProvider<T> dataProvider) {
        this(id, dataProvider, false);
    }

    public GeoServerTablePanel(String id, final GeoServerDataProvider<T> dataProvider, final boolean selectable) {
        super(id);
        this.dataProvider = dataProvider;
        this.selection = new boolean[25];
        this.listContainer = new WebMarkupContainer("listContainer");
        this.filterForm = new Form("filterForm");
        this.add((Component)this.filterForm);
        this.filter = new TextField("filter", (IModel)new Model());
        this.filterForm.add((Component)this.filter);
        this.filter.add((IBehavior)new SimpleAttributeModifier("title", (CharSequence)String.valueOf(new ResourceModel("GeoServerTablePanel.search", "Search").getObject())));
        this.hiddenSubmit = this.hiddenSubmit();
        this.filterForm.add((Component)this.hiddenSubmit);
        this.filterForm.setDefaultButton((IFormSubmittingComponent)this.hiddenSubmit);
        this.listContainer.setOutputMarkupId(true);
        this.add((Component)this.listContainer);
        this.dataView = new DataView("items", (IDataProvider)dataProvider){

            protected void populateItem(Item item) {
                final IModel itemModel = item.getModel();
                item.add((IBehavior)new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd")));
                WebMarkupContainer cnt = new WebMarkupContainer("selectItemContainer");
                cnt.add((Component)GeoServerTablePanel.this.selectOneCheckbox(item));
                cnt.setVisible(selectable);
                item.add((Component)cnt);
                item.add((Component)new ListView("itemProperties", dataProvider.getVisibleProperties()){

                    protected void populateItem(ListItem item) {
                        GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                        Component component = GeoServerTablePanel.this.getComponentForProperty("component", itemModel, property);
                        if (component == null) {
                            component = new Label("component", property.getModel(itemModel));
                        } else if (!"component".equals(component.getId())) {
                            throw new IllegalArgumentException("getComponentForProperty asked to build a component with id = 'component' for property '" + property.getName() + "', but got '" + component.getId() + "' instead");
                        }
                        item.add(component);
                    }
                });
            }
        };
        this.listContainer.add((Component)this.dataView);
        WebMarkupContainer cnt = new WebMarkupContainer("selectAllContainer");
        this.selectAll = this.selectAllCheckbox();
        cnt.add((Component)this.selectAll);
        cnt.setVisible(selectable);
        this.listContainer.add((Component)cnt);
        this.listContainer.add((Component)new ListView("sortableLinks", dataProvider.getVisibleProperties()){

            protected void populateItem(ListItem item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                IModel titleModel = GeoServerTablePanel.this.getPropertyTitle(property);
                if (property.getComparator() != null) {
                    Fragment f = new Fragment("header", "sortableHeader", (MarkupContainer)item);
                    AjaxLink link = GeoServerTablePanel.this.sortLink(dataProvider, item);
                    link.add((Component)new Label("label", titleModel));
                    f.add((Component)link);
                    item.add((Component)f);
                } else {
                    item.add((Component)new Label("header", titleModel));
                }
            }
        });
        this.dataView.setItemsPerPage(25);
        this.navigatorTop = new Pager("navigatorTop");
        this.filterForm.add((Component)this.navigatorTop);
        this.navigatorTop.setOutputMarkupId(true);
        this.navigatorBottom = new Pager("navigatorBottom");
        this.add((Component)this.navigatorBottom);
        this.navigatorBottom.setOutputMarkupId(true);
    }

    public Pager getTopPager() {
        return this.navigatorTop;
    }

    public Pager getBottomPager() {
        return this.navigatorBottom;
    }

    public GeoServerDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    protected void onSelectionUpdate(AjaxRequestTarget target) {
    }

    IModel getPropertyTitle(GeoServerDataProvider.Property<T> property) {
        String pageName = this.getPage().getClass().getSimpleName();
        ResourceModel resMod = new ResourceModel(pageName + ".th." + property.getName(), property.getName());
        return resMod;
    }

    public List<T> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        for (Item item : this.dataView) {
            if (this.selection[i]) {
                result.add(item.getModelObject());
            }
            ++i;
        }
        return result;
    }

    CheckBox selectAllCheckbox() {
        CheckBox sa = new CheckBox("selectAll", (IModel)new PropertyModel((Object)this, "selectAllValue"));
        sa.setOutputMarkupId(true);
        sa.add((IBehavior)new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                GeoServerTablePanel.this.setSelection(GeoServerTablePanel.this.selectAllValue);
                target.addComponent(this.getComponent());
                target.addComponent((Component)GeoServerTablePanel.this.listContainer);
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        });
        return sa;
    }

    CheckBox selectOneCheckbox(Item item) {
        CheckBox cb = new CheckBox("selectItem", (IModel)new SelectionModel(item.getIndex()));
        cb.setOutputMarkupId(true);
        cb.add((IBehavior)new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (Boolean.FALSE.equals(this.getComponent().getModelObject())) {
                    GeoServerTablePanel.this.selectAllValue = false;
                    target.addComponent((Component)GeoServerTablePanel.this.selectAll);
                }
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        });
        return cb;
    }

    void setSelection(boolean selected) {
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = selected;
        }
        this.selectAllValue = selected;
    }

    public void clearSelection() {
        this.setSelection(false);
    }

    public void selectAll() {
        this.setSelection(true);
    }

    AjaxButton hiddenSubmit() {
        return new AjaxButton("submit"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                GeoServerTablePanel.this.updateFilter(target, GeoServerTablePanel.this.filter.getModelObjectAsString());
            }
        };
    }

    public void setItemsPerPage(int items) {
        this.dataView.setItemsPerPage(items);
        this.selection = new boolean[items];
    }

    public GeoServerTablePanel<T> setFilterable(boolean filterable) {
        this.filterForm.setVisible(filterable);
        return this;
    }

    AjaxLink sortLink(final GeoServerDataProvider<T> dataProvider, ListItem item) {
        return new AjaxLink("link", item.getModel()){

            public void onClick(AjaxRequestTarget target) {
                SortParam currSort = dataProvider.getSort();
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)this.getModelObject();
                if (currSort == null || !property.getName().equals(currSort.getProperty())) {
                    dataProvider.setSort(new SortParam(property.getName(), true));
                } else {
                    dataProvider.setSort(new SortParam(property.getName(), !currSort.isAscending()));
                }
                GeoServerTablePanel.this.setSelection(false);
                target.addComponent((Component)GeoServerTablePanel.this.listContainer);
            }
        };
    }

    private void updateFilter(AjaxRequestTarget target, String flatKeywords) {
        if ("".equals(flatKeywords)) {
            this.dataProvider.setKeywords(null);
            this.filter.setModelObject((Object)"");
            this.dataView.setCurrentPage(0);
        } else {
            String[] keywords = flatKeywords.split("\\s+");
            this.dataProvider.setKeywords(keywords);
            this.dataView.setCurrentPage(0);
        }
        this.navigatorTop.updateMatched();
        this.navigatorBottom.updateMatched();
        this.setSelection(false);
        target.addComponent((Component)this.listContainer);
        target.addComponent((Component)this.navigatorTop);
        target.addComponent((Component)this.navigatorBottom);
    }

    public void setFilterVisible(boolean filterVisible) {
        this.filterForm.setVisible(filterVisible);
    }

    protected abstract Component getComponentForProperty(String var1, IModel var2, GeoServerDataProvider.Property<T> var3);

    IModel showingAllRecords(int first, int last, int size) {
        return new ParamResourceModel("showingAllRecords", (Component)this, first, last, size);
    }

    IModel matchedXOutOfY(int first, int last, int size, int fullSize) {
        return new ParamResourceModel("matchedXOutOfY", (Component)this, first, last, size, fullSize);
    }

    class SelectionModel
    implements IModel {
        int index;

        public SelectionModel(int index) {
            this.index = index;
        }

        public Object getObject() {
            return GeoServerTablePanel.this.selection[this.index];
        }

        public void setObject(Object object) {
            GeoServerTablePanel.this.selection[this.index] = (Boolean)object;
        }

        public void detach() {
        }
    }

    protected class Pager
    extends Panel {
        GeoServerPagingNavigator navigator;
        Label matched;

        Pager(String id) {
            super(id);
            this.navigator = this.updatingPagingNavigator();
            this.add((Component)this.navigator);
            this.matched = new Label("filterMatch", (IModel)new Model());
            this.add((Component)this.matched);
            this.updateMatched();
        }

        private GeoServerPagingNavigator updatingPagingNavigator() {
            return new GeoServerPagingNavigator("navigator", (IPageable)GeoServerTablePanel.this.dataView){

                protected void onAjaxEvent(AjaxRequestTarget target) {
                    super.onAjaxEvent(target);
                    GeoServerTablePanel.this.setSelection(false);
                    GeoServerTablePanel.this.navigatorTop.updateMatched();
                    GeoServerTablePanel.this.navigatorBottom.updateMatched();
                    target.addComponent((Component)GeoServerTablePanel.this.navigatorTop);
                    target.addComponent((Component)GeoServerTablePanel.this.navigatorBottom);
                }
            };
        }

        void updateMatched() {
            if (GeoServerTablePanel.this.dataProvider.getKeywords() == null) {
                this.matched.setModel(GeoServerTablePanel.this.showingAllRecords(this.first(), this.last(), GeoServerTablePanel.this.dataProvider.fullSize()));
            } else {
                this.matched.setModel(GeoServerTablePanel.this.matchedXOutOfY(this.first(), this.last(), GeoServerTablePanel.this.dataProvider.size(), GeoServerTablePanel.this.dataProvider.fullSize()));
            }
        }

        int first() {
            if (GeoServerTablePanel.this.dataView.getDataProvider().size() > 0) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * GeoServerTablePanel.this.dataView.getCurrentPage() + 1;
            }
            return 0;
        }

        int last() {
            int count = GeoServerTablePanel.this.dataView.getPageCount();
            int page = GeoServerTablePanel.this.dataView.getCurrentPage();
            if (page < count - 1) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * (page + 1);
            }
            return GeoServerTablePanel.this.dataView.getDataProvider().size();
        }
    }
}

