/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SRSProvider;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class SRSListPanel
extends Panel {
    GeoServerTablePanel<SRSProvider.SRS> table = new GeoServerTablePanel<SRSProvider.SRS>("table", (GeoServerDataProvider)new SRSProvider()){

        @Override
        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<SRSProvider.SRS> property) {
            SRSProvider.SRS srs = (SRSProvider.SRS)itemModel.getObject();
            if (SRSProvider.CODE.equals(property)) {
                Component linkForCode = SRSListPanel.this.createLinkForCode(id, itemModel);
                return linkForCode;
            }
            if (SRSProvider.DESCRIPTION.equals(property)) {
                String description = srs.getDescription();
                return new Label(id, description.trim());
            }
            throw new IllegalArgumentException("Unknown property: " + property);
        }
    };

    public SRSListPanel(String id) {
        super(id);
        this.add((Component)this.table);
    }

    public void setCompactMode(boolean compact) {
        this.table.getTopPager().setVisible(!compact);
    }

    protected Component createLinkForCode(String linkId, IModel itemModel) {
        return new SimpleAjaxLink(linkId, SRSProvider.CODE.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                SRSListPanel.this.onCodeClicked(target, this.getModelObjectAsString());
            }
        };
    }

    protected abstract void onCodeClicked(AjaxRequestTarget var1, String var2);
}

