/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Comparators {
    private static final Comparator<Collection<Comparable>> COLLECTIONS = new Collections();

    private Comparators() {
    }

    public static <T extends Comparable<T>> Comparator<List<T>> forLists() {
        return COLLECTIONS;
    }

    public static <T extends Comparable<T>> Comparator<SortedSet<T>> forSortedSets() {
        return COLLECTIONS;
    }

    public static <T extends Comparable<T>> Comparator<Collection<T>> forCollections() {
        return COLLECTIONS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Collections
    implements Comparator<Collection<Comparable>>,
    Serializable {
        private static final long serialVersionUID = -8926770873102046405L;

        private Collections() {
        }

        @Override
        public int compare(Collection<Comparable> c1, Collection<Comparable> c2) {
            Comparable e2;
            Comparable e1;
            int cmp;
            int c;
            Iterator<Comparable> i1 = c1.iterator();
            Iterator<Comparable> i2 = c2.iterator();
            do {
                boolean h1 = i1.hasNext();
                boolean h2 = i2.hasNext();
                if (!h1) {
                    return h2 ? -1 : 0;
                }
                if (h2) continue;
                return 1;
            } while ((c = (cmp = (e1 = i1.next()).compareTo(e2 = i2.next()))) == 0);
            return c;
        }
    }
}

