/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class GridOriginKvpParser
extends KvpParser {
    public GridOriginKvpParser() {
        super("GridOrigin", double[].class);
    }

    public Object parse(String value) throws Exception {
        List values = KvpUtils.readFlat((String)value);
        if (values.size() < 2) {
            throw new WcsException("Invalid grid origin, should have at least two values", WcsException.WcsExceptionCode.InvalidParameterValue, "GridOrigin");
        }
        Double[] origins = new Double[values.size()];
        for (int i = 0; i < origins.length; ++i) {
            try {
                origins[i] = Double.parseDouble((String)values.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new WcsException("Invalid ordinate " + origins[i], WcsException.WcsExceptionCode.InvalidParameterValue, "GridOrigin");
            }
        }
        return origins;
    }
}

