/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.CollectionSource;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.map.event.MapLayerListener;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapContext
implements MapContext {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    List<MapLayer> layerList = new ArrayList<MapLayer>();
    ReferencedEnvelope areaOfInterest;
    protected EventListenerList listenerList = null;
    protected MapLayerListener layerListener = new MapLayerListener(){

        public void layerChanged(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerShown(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerHidden(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerSelected(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerDeselected(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        private void fireAsListEvent(MapLayerEvent event) {
            MapLayer layer = (MapLayer)event.getSource();
            int position = DefaultMapContext.this.layerList.indexOf(layer);
            DefaultMapContext.this.fireMapLayerListListenerLayerChanged(new MapLayerListEvent((MapContext)DefaultMapContext.this, layer, position, event));
        }
    };
    protected String abstracts;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected String contactInformation;
    protected String[] keywords;
    protected String title;

    public DefaultMapContext() {
        this((CoordinateReferenceSystem)null);
    }

    public DefaultMapContext(CoordinateReferenceSystem crs) {
        this(null, null, null, null, null, crs);
    }

    public DefaultMapContext(MapLayer[] layers) {
        this(layers, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public DefaultMapContext(MapLayer[] layers, CoordinateReferenceSystem crs) {
        this(layers, null, null, null, null, crs);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords) {
        this(layers, title, contextAbstract, contactInformation, keywords, null);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords, CoordinateReferenceSystem crs) {
        this.setTitle(title);
        this.setAbstract(contextAbstract);
        this.setContactInformation(contactInformation);
        this.setKeywords(keywords);
        this.areaOfInterest = new ReferencedEnvelope(crs);
        this.addLayers(layers);
    }

    @Override
    public boolean addLayer(int index, MapLayer layer) {
        if (this.layerList.contains(layer)) {
            return false;
        }
        this.checkCRS(layer);
        this.layerList.add(index, layer);
        layer.addMapLayerListener(this.layerListener);
        this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent(this, layer, index));
        return true;
    }

    @Override
    public boolean addLayer(MapLayer layer) {
        if (this.layerList.contains(layer)) {
            return false;
        }
        this.checkCRS(layer);
        this.layerList.add(layer);
        layer.addMapLayerListener(this.layerListener);
        this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent(this, layer, this.indexOf(layer)));
        return true;
    }

    @Override
    public void addLayer(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, Style style) {
        this.checkCRS(featureSource);
        Style layerStyle = this.checkStyle(style, featureSource.getSchema());
        this.addLayer(new DefaultMapLayer(featureSource, layerStyle, ""));
    }

    public void addLayer(CollectionSource source, Style style) {
        this.addLayer(new DefaultMapLayer(source, style, ""));
    }

    @Override
    public void addLayer(GridCoverage gc, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        this.checkCRS(gc.getCoordinateReferenceSystem());
        try {
            this.addLayer(FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)gc)), style);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (FactoryRegistryException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
    }

    @Override
    public void addLayer(AbstractGridCoverage2DReader reader, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        this.checkCRS(reader.getCrs());
        try {
            this.addLayer(FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, null), style);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (FactoryRegistryException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
    }

    @Override
    public void addLayer(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, Style style) {
        Style layerStyle = this.checkStyle(style, collection.getSchema());
        this.addLayer(new DefaultMapLayer(collection, layerStyle, ""));
    }

    @Override
    public void addLayer(Collection collection, Style style) {
        if (collection instanceof FeatureCollection) {
            this.addLayer(new DefaultMapLayer((FeatureCollection)((Object)collection), style, ""));
            return;
        }
        this.addLayer(new DefaultMapLayer(collection, style, ""));
    }

    private void checkCRS(MapLayer layer) {
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = layer.getFeatureSource();
        if (featureSource != null) {
            this.checkCRS(featureSource);
        } else {
            CollectionSource source = layer.getSource();
            if (source != null) {
                this.checkCRS(source.getCRS());
            }
        }
    }

    private void checkCRS(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        if (featureSource != null) {
            this.checkCRS(featureSource.getSchema().getCoordinateReferenceSystem());
        }
    }

    private void checkCRS(CoordinateReferenceSystem crs) {
        if (crs != null && this.areaOfInterest.getCoordinateReferenceSystem() == null) {
            this.areaOfInterest = new ReferencedEnvelope(this.areaOfInterest, crs);
        }
    }

    private Style checkStyle(Style style, SimpleFeatureType featureType) {
        if (style != null) {
            return style;
        }
        Style defaultStyle = SLD.createSimpleStyle(featureType);
        if (defaultStyle == null) {
            throw new IllegalStateException("Failed to creaate a default style for the layer");
        }
        return defaultStyle;
    }

    @Override
    public boolean removeLayer(MapLayer layer) {
        int index = this.indexOf(layer);
        if (index == -1) {
            return false;
        }
        this.removeLayer(index);
        return true;
    }

    @Override
    public MapLayer removeLayer(int index) {
        MapLayer layer = this.layerList.remove(index);
        layer.removeMapLayerListener(this.layerListener);
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent(this, layer, index));
        return layer;
    }

    @Override
    public int addLayers(MapLayer[] layers) {
        if (layers == null || layers.length == 0) {
            return 0;
        }
        int layerAdded = 0;
        MapLayer lastLayer = null;
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            if (this.layerList.contains(layers[i])) continue;
            this.checkCRS(layers[i]);
            this.layerList.add(layers[i]);
            ++layerAdded;
            lastLayer = layers[i];
            layers[i].addMapLayerListener(this.layerListener);
        }
        if (layerAdded > 0) {
            int fromIndex = this.layerList.size() - layerAdded;
            int toIndex = this.layerList.size() - 1;
            if (layerAdded == 1) {
                this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent((MapContext)this, lastLayer, fromIndex, toIndex));
            } else {
                this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent((MapContext)this, null, fromIndex, toIndex));
            }
        }
        return layerAdded;
    }

    @Override
    public void removeLayers(MapLayer[] layers) {
        int i;
        if (layers == null || layers.length == 0 || this.layerList.size() == 0) {
            return;
        }
        int fromIndex = this.layerList.size();
        int toIndex = 0;
        int layersRemoved = 0;
        int length = layers.length;
        for (i = 0; i < length; ++i) {
            int index = this.layerList.indexOf(layers[i]);
            if (index == -1) continue;
            ++layersRemoved;
            if (index < fromIndex) {
                fromIndex = index;
            }
            if (index <= toIndex) continue;
            toIndex = index;
        }
        if (layersRemoved == 0) {
            return;
        }
        for (i = 0; i < layersRemoved; ++i) {
            if (!this.layerList.remove(layers[i])) continue;
            layers[i].removeMapLayerListener(this.layerListener);
        }
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent((MapContext)this, null, fromIndex, toIndex));
    }

    @Override
    public MapLayer[] getLayers() {
        MapLayer[] layers = new MapLayer[this.layerList.size()];
        return this.layerList.toArray(new MapLayer[0]);
    }

    @Override
    public MapLayer getLayer(int index) throws IndexOutOfBoundsException {
        return this.layerList.get(index);
    }

    @Override
    public int indexOf(MapLayer layer) {
        return this.layerList.indexOf(layer);
    }

    @Override
    public Iterator iterator() {
        return this.layerList.iterator();
    }

    @Override
    public ReferencedEnvelope getLayerBounds() throws IOException {
        ReferencedEnvelope result = null;
        CoordinateReferenceSystem crs = this.areaOfInterest.getCoordinateReferenceSystem();
        int length = this.layerList.size();
        for (int i = 0; i < length; ++i) {
            MapLayer layer = this.layerList.get(i);
            ReferencedEnvelope env = layer.getBounds();
            if (env == null) continue;
            try {
                CoordinateReferenceSystem sourceCrs = env.getCoordinateReferenceSystem();
                if (sourceCrs != null && crs != null && !CRS.equalsIgnoreMetadata((Object)sourceCrs, (Object)crs)) {
                    env = env.transform(crs, true);
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
            }
            catch (TransformException e) {
                LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
            }
            if (result == null) {
                result = env;
                continue;
            }
            result.expandToInclude(env);
        }
        return result;
    }

    @Override
    public ReferencedEnvelope getAreaOfInterest() {
        if (this.areaOfInterest.isEmpty()) {
            try {
                ReferencedEnvelope e = this.getLayerBounds();
                if (e == null) {
                    return null;
                }
                this.areaOfInterest = new ReferencedEnvelope(e, this.getCoordinateReferenceSystem());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't get layer bounds, and area of interest is not set", e);
                return null;
            }
        }
        return new ReferencedEnvelope(this.areaOfInterest);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.areaOfInterest.getCoordinateReferenceSystem();
    }

    @Override
    public void transform(AffineTransform transform) {
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        double[] coords = new double[]{this.areaOfInterest.getMinX(), this.areaOfInterest.getMinY(), this.areaOfInterest.getMaxX(), this.areaOfInterest.getMaxY()};
        transform.transform(coords, 0, coords, 0, 2);
        this.areaOfInterest = new ReferencedEnvelope(coords[0], coords[2], coords[1], coords[3], this.areaOfInterest.getCoordinateReferenceSystem());
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 1, oldAreaOfInterest, new ReferencedEnvelope(this.areaOfInterest)));
    }

    @Override
    public void moveLayer(int sourcePosition, int destPosition) {
        if (sourcePosition < 0 || sourcePosition >= this.layerList.size()) {
            throw new IndexOutOfBoundsException("Source position " + sourcePosition + " out of bounds");
        }
        if (destPosition < 0 || destPosition >= this.layerList.size()) {
            throw new IndexOutOfBoundsException("Destination position " + destPosition + " out of bounds");
        }
        MapLayer layer = this.layerList.remove(sourcePosition);
        this.layerList.add(destPosition, layer);
        this.fireMapLayerListListenerLayerMoved(new MapLayerListEvent((MapContext)this, layer, Math.min(sourcePosition, destPosition), Math.max(sourcePosition, destPosition)));
    }

    @Override
    public void clearLayerList() {
        int size = this.layerList.size();
        for (int i = 0; i < size; ++i) {
            MapLayer layer = this.layerList.get(i);
            layer.removeMapLayerListener(this.layerListener);
        }
        this.layerList.clear();
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent((MapContext)this, null, 0, 1));
    }

    @Override
    public int getLayerCount() {
        return this.layerList.size();
    }

    @Override
    public String getAbstract() {
        return this.abstracts;
    }

    @Override
    public void setAbstract(String abstractValue) {
        String oldAbstracts = this.abstracts;
        this.abstracts = abstractValue == null ? "" : abstractValue;
        this.propertyChangeSupport.firePropertyChange("abstract", oldAbstracts, this.abstracts);
    }

    @Override
    public String getContactInformation() {
        return this.contactInformation;
    }

    @Override
    public void setContactInformation(String contactInformation) {
        String oldContactInformation = this.contactInformation;
        this.contactInformation = contactInformation == null ? "" : contactInformation;
        this.propertyChangeSupport.firePropertyChange("contactInformation", oldContactInformation, contactInformation);
    }

    @Override
    public String[] getKeywords() {
        if (this.keywords.length == 0) {
            return this.keywords;
        }
        String[] copy = new String[this.keywords.length];
        System.arraycopy(this.keywords, 0, copy, 0, this.keywords.length);
        return copy;
    }

    @Override
    public void setKeywords(String[] keywords) {
        String[] oldKeywords = this.keywords;
        this.keywords = keywords == null ? new String[]{} : keywords;
        this.propertyChangeSupport.firePropertyChange("keywords", oldKeywords, keywords);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title == null ? "" : title;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    @Override
    public synchronized void addMapLayerListListener(MapLayerListListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(MapLayerListListener.class, listener);
    }

    @Override
    public synchronized void removeMapLayerListListener(MapLayerListListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(MapLayerListListener.class, listener);
    }

    private void fireMapLayerListListenerLayerAdded(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListListener.class) continue;
            ((MapLayerListListener)listeners[i + 1]).layerAdded(event);
        }
    }

    private void fireMapLayerListListenerLayerRemoved(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListListener.class) continue;
            ((MapLayerListListener)listeners[i + 1]).layerRemoved(event);
        }
    }

    private void fireMapLayerListListenerLayerChanged(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListListener.class) continue;
            ((MapLayerListListener)listeners[i + 1]).layerChanged(event);
        }
    }

    private void fireMapLayerListListenerLayerMoved(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListListener.class) continue;
            ((MapLayerListListener)listeners[i + 1]).layerMoved(event);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addMapBoundsListener(MapBoundsListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(MapBoundsListener.class, listener);
    }

    @Override
    public synchronized void removeMapBoundsListener(MapBoundsListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(MapBoundsListener.class, listener);
    }

    private void fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapBoundsListener.class) continue;
            ((MapBoundsListener)listeners[i + 1]).mapBoundsChanged(event);
        }
    }

    @Override
    public void setAreaOfInterest(Envelope areaOfInterest) throws IllegalArgumentException {
        CoordinateReferenceSystem crs = this.areaOfInterest.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        ReferencedEnvelope refEnv = new ReferencedEnvelope(areaOfInterest, crs);
        this.setAreaOfInterest(refEnv);
    }

    @Override
    public void setAreaOfInterest(Envelope areaOfInterest, CoordinateReferenceSystem crs) throws IllegalArgumentException {
        if (areaOfInterest == null) {
            throw new IllegalArgumentException("areaOfInterest should not be null");
        }
        this.setAreaOfInterest(new ReferencedEnvelope(areaOfInterest, crs));
    }

    @Override
    public void setAreaOfInterest(ReferencedEnvelope areaOfInterest) {
        if (areaOfInterest == null) {
            throw new IllegalArgumentException("areaOfInterest must not be null");
        }
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        CoordinateReferenceSystem oldCRS = this.areaOfInterest.getCoordinateReferenceSystem();
        this.areaOfInterest = new ReferencedEnvelope(areaOfInterest);
        int flags = 0;
        if (oldCRS != null) {
            if (!CRS.equalsIgnoreMetadata((Object)this.areaOfInterest.getCoordinateReferenceSystem(), (Object)oldCRS)) {
                flags |= 2;
            }
        } else if (this.areaOfInterest.getCoordinateReferenceSystem() != null) {
            flags |= 2;
        }
        if (!this.areaOfInterest.boundsEquals2D(oldAreaOfInterest, 1.0E-4)) {
            flags |= 1;
        }
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, flags, oldAreaOfInterest, new ReferencedEnvelope(this.areaOfInterest)));
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        CoordinateReferenceSystem oldCRS = this.areaOfInterest.getCoordinateReferenceSystem();
        if (oldCRS != null) {
            if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)oldCRS)) {
                this.areaOfInterest = this.areaOfInterest.transform(crs, true);
            }
        } else {
            this.areaOfInterest = new ReferencedEnvelope(this.areaOfInterest, crs);
        }
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 2, oldAreaOfInterest, new ReferencedEnvelope(this.areaOfInterest)));
    }
}

