/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.memory.CollectionSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.GeometryTransformationVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.SymbolizerAssociation;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamingRenderer
implements GTRenderer {
    private static final int defaultMaxFiltersToSendToDatastore = 5;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    int error = 0;
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private static final PropertyName gridPropertyName = filterFactory.property("grid");
    private static final PropertyName paramsPropertyName = filterFactory.property("params");
    private static final PropertyName defaultGeometryPropertyName = filterFactory.property("");
    private MapContext context;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private ReferencedEnvelope mapExtent;
    private ReferencedEnvelope originalMapExtent;
    private ProjectionHandler projectionHandler;
    private Rectangle screenSize;
    private boolean renderingStopRequested = false;
    private double scaleDenominator;
    private double generalizationDistance = 0.8;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    protected LabelCache labelCache = new LabelCacheImpl();
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private IndexedFeatureResults indexedFeatureResults;
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    private RenderingHints java2dHints;
    private boolean optimizedDataLoadingEnabledDEFAULT = true;
    private int renderingBufferDEFAULT = 0;
    private String scaleComputationMethodDEFAULT = "OGC";
    public static final String TEXT_RENDERING_STRING = "STRING";
    public static final String TEXT_RENDERING_OUTLINE = "OUTLINE";
    public static final String TEXT_RENDERING_KEY = "textRenderingMethod";
    private String textRenderingModeDEFAULT = "STRING";
    public static final String LINE_WIDTH_OPTIMIZATION_KEY = "lineWidthOptimization";
    public static final String OPTIMIZE_FTS_RENDERING_KEY = "optimizeFTSRendering";
    public static final String ADVANCED_PROJECTION_HANDLING_KEY = "advancedProjectionHandling";
    public static final String LABEL_CACHE_KEY = "labelCache";
    public static final String DPI_KEY = "dpi";
    public static final String DECLARED_SCALE_DENOM_KEY = "declaredScaleDenominator";
    public static final String OPTIMIZED_DATA_LOADING_KEY = "optimizedDataLoadingEnabled";
    public static final String SCALE_COMPUTATION_METHOD_KEY = "scaleComputationMethod";
    private Map rendererHints = null;
    private AffineTransform worldToScreenTransform = null;
    private CoordinateReferenceSystem destinationCrs;
    private boolean canTransform;
    private boolean inMemoryGeneralization = true;
    private static final Decimator NULL_DECIMATOR = new Decimator(-1.0, -1.0);

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    @Override
    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    @Override
    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Object feature) {
        if (!(feature instanceof SimpleFeature)) {
            return;
        }
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.featureRenderer((SimpleFeature)feature);
            }
        }
    }

    private void fireErrorEvent(Exception e) {
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.errorOccurred(e);
            }
        }
    }

    @Override
    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            Envelope mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea, AffineTransform worldToScreen) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.context.getCoordinateReferenceSystem()), worldToScreen);
    }

    private double computeScale(ReferencedEnvelope envelope, Rectangle paintArea, AffineTransform worldToScreen, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale(envelope, paintArea.width, paintArea.height, hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine(envelope.getCoordinateReferenceSystem(), worldToScreen, hints);
        }
        return RendererUtilities.calculateOGCScale(envelope, paintArea.width, hints);
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea, AffineTransform worldToScreen) {
        if (graphics == null || paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null && paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (worldToScreen == null && (worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea)) == null) {
            return;
        }
        this.destinationCrs = mapArea.getCoordinateReferenceSystem();
        this.mapExtent = new ReferencedEnvelope(mapArea);
        this.screenSize = paintArea;
        this.worldToScreenTransform = worldToScreen;
        this.error = 0;
        if (this.java2dHints != null) {
            graphics.setRenderingHints(this.java2dHints);
        }
        this.renderingStopRequested = false;
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(this.worldToScreenTransform);
            this.worldToScreenTransform = atg;
            graphics.setTransform(this.worldToScreenTransform);
        }
        if (this.isAdvancedProjectionHandlingEnabled()) {
            this.projectionHandler = ProjectionHandlerFinder.getHandler(this.mapExtent);
        }
        this.scaleDenominator = this.computeScale(mapArea, paintArea, this.worldToScreenTransform, this.rendererHints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Computed scale denominator: " + this.scaleDenominator);
        }
        int buffer = this.getRenderingBuffer();
        this.originalMapExtent = this.mapExtent;
        if (buffer > 0) {
            this.mapExtent = new ReferencedEnvelope(this.expandEnvelope(this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
        }
        MapLayer[] layers = this.context.getLayers();
        this.labelCache.start();
        if (this.labelCache instanceof LabelCacheImpl) {
            boolean outlineEnabled = TEXT_RENDERING_OUTLINE.equals(this.getTextRenderingMethod());
            ((LabelCacheImpl)this.labelCache).setOutlineRenderingEnabled(outlineEnabled);
        }
        int layersNumber = layers.length;
        for (int i = 0; i < layersNumber; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            this.labelCache.startLayer(i + "");
            try {
                this.processStylers(graphics, currLayer, this.worldToScreenTransform, this.destinationCrs, this.mapExtent, this.screenSize, i + "");
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                this.fireErrorEvent(new Exception(new StringBuffer("Exception rendering layer ").append(currLayer).toString(), t));
            }
            this.labelCache.endLayer(i + "", graphics, this.screenSize);
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Style cache hit ratio: ").append(this.styleFactory.getHitRatio()).append(" , hits ").append(this.styleFactory.getHits()).append(", requests ").append(this.styleFactory.getRequests()).toString());
        }
        if (this.error > 0) {
            LOGGER.warning(new StringBuffer("Number of Errors during paint(Graphics2D, AffineTransform) = ").append(this.error).toString());
        }
    }

    private Envelope expandEnvelope(Envelope envelope, AffineTransform worldToScreen, int buffer) {
        assert (buffer > 0);
        double bufferX = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleX0((AffineTransform)worldToScreen));
        double bufferY = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleY0((AffineTransform)worldToScreen));
        return new Envelope(envelope.getMinX() - bufferX, envelope.getMaxX() + bufferX, envelope.getMinY() - bufferY, envelope.getMaxY() + bufferY);
    }

    Collection queryLayer(MapLayer currLayer, CollectionSource source) {
        Collection results = null;
        DefaultQuery query = new DefaultQuery(DefaultQuery.ALL);
        Query definitionQuery = currLayer.getQuery();
        if (definitionQuery != Query.ALL) {
            query = query == Query.ALL ? new DefaultQuery(definitionQuery) : new DefaultQuery(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        results = source.content(query.getFilter());
        return results;
    }

    FeatureCollection<SimpleFeatureType, SimpleFeature> queryLayer(MapLayer currLayer, FeatureSource<SimpleFeatureType, SimpleFeature> source, SimpleFeatureType schema, LiteFeatureTypeStyle[] styles, Envelope mapArea, CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, GeometryDescriptor geometryAttribute, AffineTransform worldToScreenTransform) throws IllegalFilterException, IOException, IllegalAttributeException {
        CoordinateReferenceSystem crs;
        Query definitionQuery;
        String[] attributes;
        int buffer;
        Object results = null;
        DefaultQuery query = new DefaultQuery(DefaultQuery.ALL);
        Filter filter = null;
        if (this.getRenderingBuffer() == 0 && (buffer = this.findRenderingBuffer(styles)) > 0) {
            mapArea = this.expandEnvelope(mapArea, worldToScreenTransform, buffer);
            LOGGER.fine("Expanding rendering area by " + buffer + " pixels to consider stroke width");
        }
        if (styles == null) {
            List ats = schema.getAttributeDescriptors();
            int length = ats.size();
            attributes = new String[length];
            for (int t = 0; t < length; ++t) {
                attributes[t] = ((AttributeDescriptor)ats.get(t)).getLocalName();
            }
        } else {
            attributes = this.findStyleAttributes(styles, schema);
        }
        ReferencedEnvelope envelope = new ReferencedEnvelope(mapArea, mapCRS);
        if (this.isOptimizedDataLoadingEnabled()) {
            try {
                List<ReferencedEnvelope> envelopes = this.projectionHandler != null ? this.projectionHandler.getQueryEnvelopes(featCrs) : (mapCRS != null && featCrs != null && !CRS.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS) ? Collections.singletonList(envelope.transform(featCrs, true, 10)) : Collections.singletonList(envelope));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Querying layer " + schema.getTypeName() + " with bbox: " + envelope);
                }
                filter = this.createBBoxFilters(schema, attributes, envelopes);
                query = new DefaultQuery(schema.getTypeName());
                query.setFilter(filter);
                query.setPropertyNames(attributes);
                this.processRuleForQuery(styles, query);
            }
            catch (Exception e) {
                this.fireErrorEvent(new Exception("Error transforming bbox", e));
                this.canTransform = false;
                query = new DefaultQuery(schema.getTypeName());
                query.setPropertyNames(attributes);
                ReferencedEnvelope bounds = source.getBounds();
                if (bounds != null && envelope.intersects(bounds)) {
                    LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)", e);
                    filter = null;
                    filter = this.createBBoxFilters(schema, attributes, Collections.singletonList(envelope));
                    query.setFilter(filter);
                } else {
                    LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)", e);
                    query.setFilter((Filter)Filter.INCLUDE);
                }
                this.processRuleForQuery(styles, query);
            }
        }
        if ((definitionQuery = currLayer.getQuery()) != Query.ALL) {
            query = query == Query.ALL ? new DefaultQuery(definitionQuery) : new DefaultQuery(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        query.setCoordinateSystem(featCrs);
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        Set<RenderingHints.Key> fsHints = source.getSupportedHints();
        if ((fsHints.contains(Hints.GEOMETRY_DISTANCE) || fsHints.contains(Hints.GEOMETRY_SIMPLIFICATION)) && (crs = this.getNativeCRS(schema, Arrays.asList(attributes))) != null) {
            try {
                double distance;
                MathTransform2D mt = this.buildFullTransform(crs, mapCRS, worldToScreenTransform);
                double[] spans = Decimator.computeGeneralizationDistances(mt.inverse(), screenSize, this.generalizationDistance);
                double d = distance = spans[0] < spans[1] ? spans[0] : spans[1];
                if (fsHints.contains(Hints.GEOMETRY_SIMPLIFICATION)) {
                    hints.put((Object)Hints.GEOMETRY_SIMPLIFICATION, (Object)distance);
                    this.inMemoryGeneralization = false;
                } else if (fsHints.contains(Hints.GEOMETRY_DISTANCE)) {
                    hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)distance);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Error computing the generalization hints", e);
            }
        }
        query.setHints(hints);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        Filter simplifiedFilter = (Filter)query.getFilter().accept((FilterVisitor)simplifier, null);
        query.setFilter(simplifiedFilter);
        return source.getFeatures(query);
    }

    ReferencedEnvelope expandEnvelopeByTransformations(LiteFeatureTypeStyle[] styles, ReferencedEnvelope envelope) {
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = new ReferencedEnvelope(envelope);
        for (LiteFeatureTypeStyle lts : styles) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            rules.addAll(Arrays.asList(lts.ruleList));
            rules.addAll(Arrays.asList(lts.elseRules));
            for (Rule r : rules) {
                for (Symbolizer s : r.symbolizers()) {
                    if (s.getGeometry() == null) continue;
                    result.expandToInclude((ReferencedEnvelope)s.getGeometry().accept((ExpressionVisitor)visitor, (Object)envelope));
                }
            }
        }
        return result;
    }

    private MathTransform2D buildFullTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS, AffineTransform worldToScreenTransform) throws FactoryException {
        MathTransform2D mt = this.buildTransform(sourceCRS, destCRS);
        mt = mt != null && !mt.isIdentity() ? (MathTransform2D)ConcatenatedTransform.create((MathTransform)mt, (MathTransform)ProjectiveTransform.create((AffineTransform)worldToScreenTransform)) : (MathTransform2D)ProjectiveTransform.create((AffineTransform)worldToScreenTransform);
        return mt;
    }

    private MathTransform2D buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        MathTransform2D mt = sourceCRS == null || destCRS == null || CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS) ? null : (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return mt;
    }

    private CoordinateReferenceSystem getNativeCRS(SimpleFeatureType schema, List<String> attNames) {
        CoordinateReferenceSystem crs = null;
        for (AttributeDescriptor att : schema.getAttributeDescriptors()) {
            if (!attNames.contains(att.getLocalName()) || !(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            CoordinateReferenceSystem gdCrs = gd.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = gdCrs;
                continue;
            }
            if (gdCrs == null) {
                crs = null;
                break;
            }
            if (CRS.equalsIgnoreMetadata((Object)crs, (Object)gdCrs)) continue;
            crs = null;
            break;
        }
        return crs;
    }

    private void processRuleForQuery(LiteFeatureTypeStyle[] styles, DefaultQuery q) {
        block7: {
            try {
                int maxFilters = this.getMaxFiltersToSendToDatastore();
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                for (LiteFeatureTypeStyle style : styles) {
                    if (style.elseRules.length > 0) {
                        return;
                    }
                    for (Rule r : style.ruleList) {
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (filtersToDS.size() > maxFilters) {
                    return;
                }
                Object ruleFiltersCombined = filtersToDS.size() == 1 ? (Filter)filtersToDS.get(0) : filterFactory.or(filtersToDS);
                ruleFiltersCombined = filterFactory.and(q.getFilter(), (Filter)ruleFiltersCombined);
                q.setFilter((Filter)ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private int getMaxFiltersToSendToDatastore() {
        try {
            Integer result = (Integer)this.rendererHints.get("maxFiltersToSendToDatastore");
            if (result == null) {
                return 5;
            }
            return result;
        }
        catch (Exception e) {
            return 5;
        }
    }

    private boolean isOptimizedFTSRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(OPTIMIZE_FTS_RENDERING_KEY);
        if (result == null) {
            return true;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isAdvancedProjectionHandlingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_HANDLING_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private int findRenderingBuffer(LiteFeatureTypeStyle[] styles) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        for (int t = 0; t < styles.length; ++t) {
            int j;
            LiteFeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.elseRules;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
            rules = lfts.ruleList;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
        }
        if (!rbe.isEstimateAccurate()) {
            LOGGER.warning("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually");
        }
        return rbe.getBuffer();
    }

    private String[] findStyleAttributes(LiteFeatureTypeStyle[] styles, SimpleFeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        for (LiteFeatureTypeStyle lfts : styles) {
            int j;
            Rule[] rules = lfts.elseRules;
            int rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
            rules = lfts.ruleList;
            rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
        }
        String[] ftsAttributes = sae.getAttributeNames();
        LinkedList<String> atts = new LinkedList<String>(Arrays.asList(ftsAttributes));
        List attTypes = schema.getAttributeDescriptors();
        int attTypesLength = attTypes.size();
        for (int i = 0; i < attTypesLength; ++i) {
            String attName = ((AttributeDescriptor)attTypes.get(i)).getLocalName();
            if ((!attName.equalsIgnoreCase("grid") || atts.contains(attName)) && (!attName.equalsIgnoreCase("params") || atts.contains(attName))) continue;
            atts.add(attName);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("added attribute " + attName);
        }
        try {
            if (sae.getDefaultGeometryUsed() && !atts.contains(schema.getGeometryDescriptor().getLocalName())) {
                atts.add(schema.getGeometryDescriptor().getLocalName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ftsAttributes = new String[atts.size()];
        atts.toArray(ftsAttributes);
        return ftsAttributes;
    }

    private Filter createBBoxFilters(SimpleFeatureType schema, String[] attributes, List<ReferencedEnvelope> bboxes) throws IllegalFilterException {
        Object filter = Filter.INCLUDE;
        int length = attributes.length;
        for (int j = 0; j < length; ++j) {
            AttributeDescriptor attType = schema.getDescriptor(attributes[j]);
            if (attType == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("Could not find '").append(attributes[j]).append("' in the FeatureType (").append(schema.getTypeName()).append(")").toString());
                }
                throw new IllegalFilterException(new StringBuffer("Could not find '").append(attributes[j] + "' in the FeatureType (").append(schema.getTypeName()).append(")").toString());
            }
            if (!(attType instanceof GeometryDescriptor)) continue;
            FastBBOX gfilter = new FastBBOX(attType.getLocalName(), bboxes.get(0));
            filter = filter == Filter.INCLUDE ? gfilter : filterFactory.or((Filter)filter, (Filter)gfilter);
            if (bboxes.size() <= 0) continue;
            for (int k = 1; k < bboxes.size(); ++k) {
                filter = filterFactory.or((Filter)filter, (Filter)new FastBBOX(attType.getLocalName(), bboxes.get(k)));
            }
        }
        return filter;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private ArrayList createLiteFeatureTypeStyles(FeatureTypeStyle[] featureStyles, Object typeDescription, Graphics2D graphics) throws IOException {
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        int itemNumber = 0;
        for (FeatureTypeStyle fts : featureStyles) {
            LiteFeatureTypeStyle lfts;
            if (typeDescription == null || typeDescription.toString().indexOf(fts.getFeatureTypeName()) == -1) continue;
            Rule[] rules = fts.getRules();
            ruleList = new ArrayList();
            elseRuleList = new ArrayList();
            for (Rule r : rules) {
                if (!this.isWithInScale(r)) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
            if (itemNumber == 0 || !this.isOptimizedFTSRenderingEnabled()) {
                lfts = new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList);
            } else {
                BufferedImage image = graphics.getDeviceConfiguration().createCompatibleImage(this.screenSize.width, this.screenSize.height, 3);
                lfts = new LiteFeatureTypeStyle(image, graphics.getTransform(), ruleList, elseRuleList, this.java2dHints);
            }
            result.add(lfts);
            ++itemNumber;
        }
        return result;
    }

    private ArrayList createLiteFeatureTypeStyles(FeatureTypeStyle[] featureStyles, SimpleFeatureType ftype, Graphics2D graphics) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("creating rules for scale denominator - " + NumberFormat.getNumberInstance().format(this.scaleDenominator));
        }
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        int itemNumber = 0;
        for (FeatureTypeStyle fts : featureStyles) {
            LiteFeatureTypeStyle lfts;
            if (!this.isFeatureTypeStyleActive(ftype, fts)) continue;
            List[] splittedRules = this.splitRules(fts);
            List ruleList = splittedRules[0];
            List elseRuleList = splittedRules[1];
            if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
            if (itemNumber == 0 || !this.isOptimizedFTSRenderingEnabled()) {
                lfts = new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList);
            } else {
                BufferedImage image = graphics.getDeviceConfiguration().createCompatibleImage(this.screenSize.width, this.screenSize.height, 3);
                lfts = new LiteFeatureTypeStyle(image, graphics.getTransform(), ruleList, elseRuleList, this.java2dHints);
            }
            result.add(lfts);
            ++itemNumber;
        }
        return result;
    }

    private boolean isFeatureTypeStyleActive(SimpleFeatureType ftype, FeatureTypeStyle fts) {
        return ftype.getTypeName() != null && (ftype.getTypeName().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom((FeatureType)ftype, null, fts.getFeatureTypeName()));
    }

    private List[] splitRules(FeatureTypeStyle fts) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        Rule[] rules = fts.getRules();
        ruleList = new ArrayList();
        elseRuleList = new ArrayList();
        for (int j = 0; j < rules.length; ++j) {
            Rule r = rules[j];
            if (!this.isWithInScale(r)) continue;
            if (r.hasElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            ruleList.add(r);
        }
        return new List[]{ruleList, elseRuleList};
    }

    public int getMaxBackBufferMemory(int width, int height) {
        int maxBuffers = 0;
        for (MapLayer layer : this.context.getLayers()) {
            if (!layer.isVisible() || layer.getStyle().getFeatureTypeStyles().length < 2) continue;
            int currCount = 0;
            SimpleFeatureType ftype = (SimpleFeatureType)layer.getFeatureSource().getSchema();
            for (FeatureTypeStyle fts : layer.getStyle().getFeatureTypeStyles()) {
                if (!this.isFeatureTypeStyleActive(ftype, fts)) continue;
                List[] splittedRules = this.splitRules(fts);
                List ruleList = splittedRules[0];
                List elseRuleList = splittedRules[1];
                if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
                ++currCount;
            }
            if (--currCount <= maxBuffers) continue;
            maxBuffers = currCount;
        }
        return maxBuffers * width * height * 4;
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> prepFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> features, CoordinateReferenceSystem sourceCrs) {
        CoordinateReferenceSystem rCS = null;
        try {
            rCS = features.getSchema().getGeometryDescriptor().getType().getCoordinateReferenceSystem();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && CRS.equalsIgnoreMetadata((Object)rCS, (Object)sourceCrs))) {
            try {
                return new ForceCoordinateSystemFeatureResults(features, sourceCrs);
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, ee.getLocalizedMessage(), ee);
            }
        }
        return features;
    }

    private final void processStylers(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, Envelope mapArea, Rectangle screenSize, String layerId) throws IllegalFilterException, IOException, IllegalAttributeException {
        ArrayList lfts;
        FeatureTypeStyle[] featureStylers = currLayer.getStyle().getFeatureTypeStyles();
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = currLayer.getFeatureSource();
        Collection collection = null;
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = null;
        NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
        if (featureSource != null) {
            SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
            GeometryDescriptor geometryAttribute = schema.getGeometryDescriptor();
            CoordinateReferenceSystem sourceCrs = geometryAttribute.getType().getCoordinateReferenceSystem();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("processing ").append(featureStylers.length).append(" stylers for ").append(currLayer.getFeatureSource().getSchema().getName()).toString());
            }
            if ((lfts = this.createLiteFeatureTypeStyles(featureStylers, schema, graphics)).size() == 0) {
                return;
            }
            LiteFeatureTypeStyle[] featureTypeStyleArray = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]);
            this.inMemoryGeneralization = true;
            features = this.queryLayer(currLayer, featureSource, schema, featureTypeStyleArray, mapArea, destinationCrs, sourceCrs, screenSize, geometryAttribute, at);
            features = this.prepFeatureCollection(features, sourceCrs);
        } else {
            CollectionSource source = currLayer.getSource();
            collection = this.queryLayer(currLayer, currLayer.getSource());
            Object sourceCrs = null;
            lfts = this.createLiteFeatureTypeStyles(featureStylers, source.describe(), graphics);
        }
        if (lfts.size() == 0) {
            return;
        }
        if (this.isOptimizedFTSRenderingEnabled()) {
            this.drawOptimized(graphics, currLayer, at, destinationCrs, layerId, collection, features, scaleRange, lfts);
        } else {
            this.drawPlain(graphics, currLayer, at, destinationCrs, layerId, collection, features, scaleRange, lfts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPlain(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection collection, FeatureCollection features, NumberRange scaleRange, ArrayList lfts) {
        LiteFeatureTypeStyle[] fts_array;
        for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()])) {
            Iterator<Object> iterator = null;
            if (collection != null) {
                iterator = collection.iterator();
            }
            if (features != null) {
                iterator = features.iterator();
            }
            if (iterator == null) {
                return;
            }
            try {
                boolean clone = this.isCloningRequired(currLayer, fts_array);
                RenderableFeature rf = new RenderableFeature(currLayer, clone);
                while (iterator.hasNext() && !this.renderingStopRequested) {
                    try {
                        rf.setFeature(iterator.next());
                        this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                    }
                    catch (Throwable tr) {
                        LOGGER.log(Level.SEVERE, tr.getLocalizedMessage(), tr);
                        this.fireErrorEvent(new Exception("Error rendering feature", tr));
                    }
                }
            }
            finally {
                if (collection instanceof FeatureCollection) {
                    FeatureCollection resource = (FeatureCollection)((Object)collection);
                    resource.close(iterator);
                } else if (features != null) {
                    features.close(iterator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOptimized(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection collection, FeatureCollection features, NumberRange scaleRange, ArrayList lfts) {
        Iterator<Object> iterator = null;
        if (collection != null) {
            iterator = collection.iterator();
        }
        if (features != null) {
            iterator = features.iterator();
        }
        if (iterator == null) {
            return;
        }
        LiteFeatureTypeStyle[] fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]);
        try {
            boolean clone = this.isCloningRequired(currLayer, fts_array);
            RenderableFeature rf = new RenderableFeature(currLayer, clone);
            while (iterator.hasNext() && !this.renderingStopRequested) {
                try {
                    rf.setFeature(iterator.next());
                    for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array) {
                        this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                    }
                }
                catch (Throwable tr) {
                    LOGGER.log(Level.SEVERE, tr.getLocalizedMessage(), tr);
                    this.fireErrorEvent(new Exception("Error rendering feature", tr));
                }
            }
        }
        finally {
            if (collection instanceof FeatureCollection) {
                FeatureCollection resource = (FeatureCollection)((Object)collection);
                resource.close(iterator);
            } else if (features != null) {
                features.close(iterator);
            }
        }
        graphics.setComposite(AlphaComposite.getInstance(3));
        for (int t = 0; t < fts_array.length; ++t) {
            if (fts_array[t].myImage == null) continue;
            graphics.drawImage((Image)fts_array[t].myImage, 0, 0, null);
            fts_array[t].myImage.flush();
            fts_array[t].graphics.dispose();
        }
    }

    private boolean isCloningRequired(MapLayer layer, LiteFeatureTypeStyle[] lfts) {
        Set<RenderingHints.Key> hints = layer.getFeatureSource().getSupportedHints();
        if (!hints.contains(Hints.FEATURE_DETACHED)) {
            return true;
        }
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        FeatureType featureType = layer.getFeatureSource().getSchema();
        HashSet<String> plainGeometries = new HashSet<String>();
        HashSet<String> txGeometries = new HashSet<String>();
        for (LiteFeatureTypeStyle lft : lfts) {
            for (Rule r : lft.ruleList) {
                for (Symbolizer s : r.symbolizers()) {
                    String attribute;
                    if (s.getGeometry() == null) {
                        attribute = featureType.getGeometryDescriptor().getName().getLocalPart();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    if (s.getGeometry() instanceof PropertyName) {
                        attribute = ((PropertyName)s.getGeometry()).getPropertyName();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    Expression g = s.getGeometry();
                    extractor.clear();
                    g.accept((ExpressionVisitor)extractor, null);
                    Set<String> attributes = extractor.getAttributeNameSet();
                    for (String attribute2 : attributes) {
                        if (plainGeometries.contains(attribute2)) {
                            return true;
                        }
                        if (txGeometries.contains(attribute2)) {
                            return true;
                        }
                        txGeometries.add(attribute2);
                    }
                }
            }
        }
        return false;
    }

    private final void process(RenderableFeature rf, LiteFeatureTypeStyle style, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws TransformException, FactoryException {
        Symbolizer[] symbolizers;
        boolean doElse = true;
        Rule[] elseRuleList = style.elseRules;
        Rule[] ruleList = style.ruleList;
        Graphics2D graphics = style.graphics;
        for (Rule r : ruleList) {
            Filter filter = r.getFilter();
            if (filter != null && !filter.evaluate(rf.content)) continue;
            doElse = false;
            symbolizers = r.getSymbolizers();
            this.processSymbolizers(graphics, rf, symbolizers, scaleRange, at, destinationCrs, layerId);
        }
        if (doElse) {
            for (Rule r : elseRuleList) {
                symbolizers = r.getSymbolizers();
                this.processSymbolizers(graphics, rf, symbolizers, scaleRange, at, destinationCrs, layerId);
            }
        }
    }

    private final void processSymbolizers(Graphics2D graphics, RenderableFeature drawMe, Symbolizer[] symbolizers, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws TransformException, FactoryException {
        int length = symbolizers.length;
        for (int m = 0; m < length; ++m) {
            Symbolizer symbolizer = symbolizers[m];
            if (symbolizer instanceof RasterSymbolizer) {
                this.renderRaster(graphics, drawMe.content, (RasterSymbolizer)symbolizer, destinationCrs, (Range)scaleRange, at);
                continue;
            }
            LiteShape2 shape = drawMe.getShape(symbolizer, at);
            if (shape == null) continue;
            if (symbolizer instanceof TextSymbolizer && drawMe.content instanceof SimpleFeature) {
                this.labelCache.put(layerId, (TextSymbolizer)symbolizers[m], (SimpleFeature)drawMe.content, shape, (NumberRange<Double>)scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(drawMe.content, symbolizer, (Range)scaleRange);
            this.painter.paint(graphics, shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(drawMe.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderRaster(Graphics2D graphics, Object drawMe, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, Range scaleRange, AffineTransform worldToScreen) {
        Object grid = gridPropertyName.evaluate(drawMe);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("rendering Raster for feature ").append(drawMe.toString()).append(" - ").append(grid).toString());
        }
        GridCoverage2D coverage = null;
        try {
            GridCoverageRenderer gcr = new GridCoverageRenderer(destinationCRS, this.originalMapExtent, this.screenSize, worldToScreen, this.java2dHints);
            if (grid instanceof GridCoverage) {
                gcr.paint(graphics, (GridCoverage2D)grid, symbolizer);
            } else if (grid instanceof AbstractGridCoverage2DReader) {
                Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
                readGG.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.screenSize), (org.opengis.geometry.Envelope)this.mapExtent));
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)grid;
                Object params = paramsPropertyName.evaluate(drawMe);
                if (params != null) {
                    GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
                    int length = readParams.length;
                    if (length > 0) {
                        int i;
                        String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                        for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                        }
                        if (i < length) {
                            ((Parameter)readParams[i]).setValue((Object)readGG);
                            coverage = reader.read(readParams);
                        } else {
                            GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                            System.arraycopy(readParams, 0, readParams2, 0, length);
                            readParams2[length] = readGG;
                            coverage = reader.read(readParams2);
                        }
                    } else {
                        coverage = reader.read(new GeneralParameterValue[]{readGG});
                    }
                } else {
                    coverage = reader.read(new GeneralParameterValue[]{readGG});
                }
                try {
                    if (coverage != null) {
                        gcr.paint(graphics, coverage, symbolizer);
                    }
                }
                finally {
                    if (coverage != null) {
                        coverage.dispose(true);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Raster rendered");
            }
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent((Exception)((Object)e));
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent((Exception)((Object)e));
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
    }

    private Geometry findGeometry(Object drawMe, Symbolizer s) {
        Expression geomExpr = s.getGeometry();
        Geometry geom = geomExpr == null ? (drawMe instanceof SimpleFeature ? (Geometry)((SimpleFeature)drawMe).getDefaultGeometry() : (Geometry)defaultGeometryPropertyName.evaluate(drawMe, Geometry.class)) : (Geometry)geomExpr.evaluate(drawMe, Geometry.class);
        return geom;
    }

    private CoordinateReferenceSystem findGeometryCS(MapLayer currLayer, Object drawMe, Symbolizer s) {
        if (drawMe instanceof SimpleFeature) {
            SimpleFeature f = (SimpleFeature)drawMe;
            SimpleFeatureType schema = f.getFeatureType();
            Expression geometry = s.getGeometry();
            String geomName = null;
            if (geometry instanceof PropertyName) {
                geomName = ((PropertyName)geometry).getPropertyName();
                return this.getAttributeCRS(geomName, schema);
            }
            if (geometry == null) {
                return this.getAttributeCRS(null, schema);
            }
            StyleAttributeExtractor attExtractor = new StyleAttributeExtractor();
            geometry.accept((ExpressionVisitor)attExtractor, null);
            for (String name : attExtractor.getAttributeNameSet()) {
                if (!(schema.getDescriptor(name) instanceof GeometryDescriptor)) continue;
                return this.getAttributeCRS(name, schema);
            }
        } else if (currLayer.getSource() != null) {
            return currLayer.getSource().getCRS();
        }
        return null;
    }

    CoordinateReferenceSystem getAttributeCRS(String geomName, SimpleFeatureType schema) {
        if (geomName == null || "".equals(geomName)) {
            GeometryDescriptor geom = schema.getGeometryDescriptor();
            return geom.getType().getCoordinateReferenceSystem();
        }
        GeometryDescriptor geom = (GeometryDescriptor)schema.getDescriptor(geomName);
        return geom.getType().getCoordinateReferenceSystem();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private boolean isOptimizedDataLoadingEnabled() {
        if (this.rendererHints == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        Object result = null;
        try {
            result = this.rendererHints.get(OPTIMIZED_DATA_LOADING_KEY);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (result == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        return result;
    }

    private int getRenderingBuffer() {
        if (this.rendererHints == null) {
            return this.renderingBufferDEFAULT;
        }
        Number result = (Number)this.rendererHints.get("renderingBuffer");
        if (result == null) {
            return this.renderingBufferDEFAULT;
        }
        return result.intValue();
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get(SCALE_COMPUTATION_METHOD_KEY);
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    private String getTextRenderingMethod() {
        if (this.rendererHints == null) {
            return this.textRenderingModeDEFAULT;
        }
        String result = (String)this.rendererHints.get(TEXT_RENDERING_KEY);
        if (result == null) {
            return this.textRenderingModeDEFAULT;
        }
        return result;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    @Override
    public void setJava2DHints(RenderingHints hints) {
        this.java2dHints = hints;
        this.styleFactory.setRenderingHints(hints);
    }

    @Override
    public RenderingHints getJava2DHints() {
        return this.java2dHints;
    }

    public void setRendererHints(Map hints) {
        if (hints != null && hints.containsKey(LABEL_CACHE_KEY)) {
            LabelCache cache = (LabelCache)hints.get(LABEL_CACHE_KEY);
            if (cache == null) {
                throw new NullPointerException("Label_Cache_Hint has a null value for the labelcache");
            }
            this.labelCache = cache;
            this.painter = new StyledShapePainter(cache);
        }
        if (hints != null && hints.containsKey(LINE_WIDTH_OPTIMIZATION_KEY)) {
            this.styleFactory.setLineOptimizationEnabled(Boolean.TRUE.equals(hints.get(LINE_WIDTH_OPTIMIZATION_KEY)));
        }
        this.rendererHints = hints;
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    @Override
    public void setContext(MapContext context) {
        this.context = context;
    }

    @Override
    public MapContext getContext() {
        return this.context;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    private class RenderableFeature {
        Object content;
        private MapLayer layer;
        private IdentityHashMap symbolizerAssociationHT = new IdentityHashMap();
        private List geometries = new ArrayList();
        private List shapes = new ArrayList();
        private boolean clone;
        private IdentityHashMap decimators = new IdentityHashMap();

        public RenderableFeature(MapLayer layer, boolean clone) {
            this.layer = layer;
            this.clone = clone;
        }

        public void setFeature(Object feature) {
            this.content = feature;
            this.geometries.clear();
            this.shapes.clear();
        }

        public LiteShape2 getShape(Symbolizer symbolizer, AffineTransform at) throws FactoryException {
            Geometry g = StreamingRenderer.this.findGeometry(this.content, symbolizer);
            if (g == null) {
                return null;
            }
            SymbolizerAssociation sa = (SymbolizerAssociation)this.symbolizerAssociationHT.get(symbolizer);
            MathTransform2D crsTransform = null;
            MathTransform2D atTransform = null;
            MathTransform2D fullTransform = null;
            if (sa == null) {
                sa = new SymbolizerAssociation();
                sa.crs = StreamingRenderer.this.findGeometryCS(this.layer, this.content, symbolizer);
                try {
                    crsTransform = StreamingRenderer.this.buildTransform(sa.crs, StreamingRenderer.this.destinationCrs);
                    atTransform = (MathTransform2D)ProjectiveTransform.create((AffineTransform)StreamingRenderer.this.worldToScreenTransform);
                    fullTransform = StreamingRenderer.this.buildFullTransform(sa.crs, StreamingRenderer.this.destinationCrs, at);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                sa.xform = fullTransform;
                sa.crsxform = crsTransform;
                sa.axform = atTransform;
                this.symbolizerAssociationHT.put(symbolizer, sa);
            }
            try {
                if (symbolizer instanceof PointSymbolizer) {
                    if (!this.clone && g.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory) {
                        this.getTransformedShape(g, sa);
                        return this.getTransformedShape(RendererUtilities.getCentroid(g), null);
                    }
                    return this.getTransformedShape(RendererUtilities.getCentroid(g), sa);
                }
                return this.getTransformedShape(g, sa);
            }
            catch (TransformException te) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                StreamingRenderer.this.fireErrorEvent((Exception)((Object)te));
                return null;
            }
            catch (AssertionError ae) {
                LOGGER.log(Level.FINE, ((Throwable)((Object)ae)).getLocalizedMessage(), (Throwable)((Object)ae));
                StreamingRenderer.this.fireErrorEvent(new RuntimeException((Throwable)((Object)ae)));
                return null;
            }
        }

        private final LiteShape2 getTransformedShape(Geometry originalGeom, SymbolizerAssociation sa) throws TransformException, FactoryException {
            LiteShape2 shape;
            for (int i = 0; i < this.geometries.size(); ++i) {
                if (this.geometries.get(i) != originalGeom) continue;
                return (LiteShape2)this.shapes.get(i);
            }
            Geometry geom = originalGeom;
            if (this.clone || !(geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory)) {
                geom = LiteCoordinateSequence.cloneGeometry(geom);
            }
            if (StreamingRenderer.this.projectionHandler != null && sa != null) {
                geom = StreamingRenderer.this.projectionHandler.preProcess(sa.crs, geom);
                if (geom == null) {
                    shape = null;
                } else {
                    Decimator d = this.getDecimator(sa.xform);
                    d.decimateTransformGeneralize(geom, (MathTransform)sa.crsxform);
                    geom.geometryChanged();
                    geom = StreamingRenderer.this.projectionHandler.postProcess(geom);
                    d = new Decimator(-1.0, -1.0);
                    d.decimateTransformGeneralize(geom, (MathTransform)sa.axform);
                    shape = new LiteShape2(geom, null, null, false, false);
                }
            } else {
                MathTransform2D xform = null;
                if (sa != null) {
                    xform = sa.xform;
                }
                shape = new LiteShape2(geom, (MathTransform)xform, this.getDecimator(xform), false, false);
            }
            this.geometries.add(originalGeom);
            this.shapes.add(shape);
            return shape;
        }

        private Decimator getDecimator(MathTransform2D mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
            if (StreamingRenderer.this.generalizationDistance == 0.0 || !StreamingRenderer.this.inMemoryGeneralization) {
                return NULL_DECIMATOR;
            }
            Decimator decimator = (Decimator)this.decimators.get(mathTransform);
            if (decimator == null) {
                decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator((MathTransform)mathTransform.inverse(), StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance) : new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                this.decimators.put(mathTransform, decimator);
            }
            return decimator;
        }
    }
}

