/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.filter.FilterCapabilities;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class PostgisFilterToSQL
extends FilterToSQL {
    FilterToSqlHelper helper = new FilterToSqlHelper(this);

    public PostgisFilterToSQL(PostGISDialect dialect) {
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (geom instanceof LinearRing) {
            geom = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
        }
        this.out.write("GeomFromText('");
        this.out.write(geom.toText());
        this.out.write("', " + this.currentSRID + ")");
    }

    protected FilterCapabilities createFilterCapabilities() {
        PostgisFilterToSQL postgisFilterToSQL = this;
        return postgisFilterToSQL.helper.createFilterCapabilities();
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }
}

