/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataEncoder;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.operation.projection.AlbersEqualArea;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.referencing.operation.projection.ObliqueMercator;
import org.geotools.referencing.operation.projection.ObliqueStereographic;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.SoftValueHashMap;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public final class CRS2GeoTiffMetadataAdapter {
    public static final int DEFAULT_MAX = 100;
    private static final Map pool = Collections.synchronizedMap(new SoftValueHashMap(100));
    private CoordinateReferenceSystem crs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object key) {
        Map map = pool;
        synchronized (map) {
            Object object = pool.get(key);
            if (object == null) {
                object = new CRS2GeoTiffMetadataAdapter((CoordinateReferenceSystem)key);
                CRS2GeoTiffMetadataAdapter.put(key, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map map = pool;
        synchronized (map) {
            pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(Object key, Object object) {
        Map map = pool;
        synchronized (map) {
            pool.put(key, object);
        }
    }

    public CRS2GeoTiffMetadataAdapter(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    private static int getEPSGCode(IdentifiedObject obj) {
        Set identifiers = obj.getIdentifiers();
        Iterator it = identifiers.iterator();
        String code = "";
        while (it.hasNext()) {
            Identifier identifier = (Identifier)it.next();
            Citation cite = identifier.getAuthority();
            if (!Citations.identifierMatches((Citation)cite, (String)"EPSG")) continue;
            code = identifier.getCode();
            break;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public GeoTiffIIOMetadataEncoder parseCoordinateReferenceSystem() throws GeoTiffException {
        GeoTiffIIOMetadataEncoder metadata = new GeoTiffIIOMetadataEncoder();
        int modelType = this.crs instanceof ProjectedCRS ? 1 : 2;
        metadata.addGeoShortParam(1024, modelType);
        switch (modelType) {
            case 2: {
                this.parseGeoGCS((DefaultGeographicCRS)this.crs, metadata);
                break;
            }
            case 1: {
                this.parseProjCRS((ProjectedCRS)this.crs, metadata);
                break;
            }
            default: {
                throw new GeoTiffException(null, "The supplied grid coverage uses an unsupported crs! You are allowed to use only projected and geographic coordinate reference systems", null);
            }
        }
        return metadata;
    }

    private void parseProjCRS(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode((IdentifiedObject)projectedCRS);
        if (code != -1) {
            metadata.addGeoShortParam(3072, code);
            return;
        }
        metadata.addGeoShortParam(3072, Short.MAX_VALUE);
        this.parseProjection(projectedCRS, metadata);
        this.parseGeoGCS((DefaultGeographicCRS)projectedCRS.getBaseCRS(), metadata);
    }

    private void parseProjection(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        MapProjection projTransf;
        Projection conversion = projectedCRS.getConversionFromBase();
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode((IdentifiedObject)conversion);
        if (code != -1) {
            metadata.addGeoShortParam(3074, code);
            return;
        }
        String conversionName = conversion.getName().getCode();
        metadata.addGeoShortParam(3074, Short.MAX_VALUE);
        metadata.addGeoAscii(3073, conversionName);
        OperationMethod method = conversion.getMethod();
        String name = method.getName().getCode();
        name = name.trim();
        name = name.replace(' ', '_');
        MathTransform mt = conversion.getMathTransform();
        if (!(mt instanceof ConcatenatedTransform)) {
            projTransf = (MapProjection)mt;
        } else {
            ConcatenatedTransform tr = (ConcatenatedTransform)mt;
            MathTransform m1 = tr.transform1;
            MathTransform m2 = tr.transform2;
            projTransf = m1 instanceof MapProjection ? (MapProjection)m1 : (MapProjection)m2;
        }
        this.parseCoordinateProjectionTransform(projTransf, name, metadata);
        this.parseLinearUnit(projectedCRS, metadata);
    }

    private void parseLinearUnit(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        Unit<?> linearUnit = CRSUtilities.getUnit((CoordinateSystem)projectedCRS.getCoordinateSystem());
        if (linearUnit != null && !SI.METER.isCompatible(linearUnit)) {
            throw new IllegalArgumentException(Errors.format((int)113, linearUnit));
        }
        if (SI.METER.isCompatible(linearUnit)) {
            if (SI.METER.equals(linearUnit)) {
                metadata.addGeoShortParam(3076, 9001);
                metadata.addGeoDoubleParam(3077, 1.0);
            }
            if (NonSI.NAUTICAL_MILE.equals(linearUnit)) {
                metadata.addGeoShortParam(3076, 9015);
                metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METER).convert(1.0));
            }
            if (NonSI.FOOT.equals(linearUnit)) {
                metadata.addGeoShortParam(3076, 9002);
                metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METER).convert(1.0));
            }
            if (NonSI.YARD.equals(linearUnit)) {
                metadata.addGeoShortParam(3076, 9012);
                metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METER).convert(1.0));
            }
        }
    }

    private void parseCoordinateProjectionTransform(MapProjection projTransf, String name, GeoTiffIIOMetadataEncoder metadata) {
        ParameterValueGroup parameters = projTransf.getParameterValues();
        if (projTransf instanceof TransverseMercator && name.equalsIgnoreCase("transverse_mercator")) {
            metadata.addGeoShortParam(3075, 1);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof Mercator && (name.equalsIgnoreCase("mercator_1SP") || name.equalsIgnoreCase("Mercator_2SP"))) {
            metadata.addGeoShortParam(3075, 7);
            List values = parameters.values();
            for (GeneralParameterValue value : values) {
                if (!(value instanceof ParameterValue)) continue;
                ParameterValue paramValue = (ParameterValue)value;
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "latitude_of_origin")) {
                    metadata.addGeoDoubleParam(3081, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "central_meridian")) {
                    metadata.addGeoDoubleParam(3080, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "scale_factor")) {
                    metadata.addGeoDoubleParam(3092, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "standard_parallel_1")) {
                    metadata.addGeoDoubleParam(3078, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "false_easting")) {
                    metadata.addGeoDoubleParam(3082, paramValue.doubleValue());
                    continue;
                }
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "false_northing")) continue;
                metadata.addGeoDoubleParam(3083, paramValue.doubleValue());
            }
            return;
        }
        if (projTransf instanceof LambertConformal && name.indexOf("1") != -1) {
            metadata.addGeoShortParam(3075, 9);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof LambertConformal && name.indexOf("2") != -1) {
            metadata.addGeoShortParam(3075, 8);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3078, parameters.parameter("standard_parallel_1").doubleValue());
            metadata.addGeoDoubleParam(3079, parameters.parameter("standard_parallel_2").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof Stereographic && name.equalsIgnoreCase("stereographic")) {
            metadata.addGeoShortParam(3075, 14);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof PolarStereographic && name.equalsIgnoreCase("polar_stereographic")) {
            metadata.addGeoShortParam(3075, 15);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3095, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof ObliqueStereographic && name.equalsIgnoreCase("Oblique_Stereographic")) {
            metadata.addGeoShortParam(3075, 16);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof ObliqueMercator && (name.equalsIgnoreCase("oblique_mercator") || name.equalsIgnoreCase("hotine_oblique_mercator"))) {
            metadata.addGeoShortParam(3075, 3);
            metadata.addGeoDoubleParam(3088, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3089, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3093, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3094, parameters.parameter("azimuth").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof AlbersEqualArea && name.equalsIgnoreCase("albers_Conic_Equal_Area")) {
            metadata.addGeoShortParam(3075, 11);
            metadata.addGeoDoubleParam(3080, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            metadata.addGeoDoubleParam(3078, parameters.parameter("standard_parallel_1").doubleValue());
            metadata.addGeoDoubleParam(3079, parameters.parameter("standard_parallel_2").doubleValue());
            return;
        }
        if (projTransf instanceof Orthographic && name.equalsIgnoreCase("Orthographic")) {
            metadata.addGeoShortParam(3075, 21);
            metadata.addGeoDoubleParam(3088, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3088, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof LambertAzimuthalEqualArea && name.equalsIgnoreCase("Lambert_Azimuthal_Equal_Area")) {
            metadata.addGeoShortParam(3075, 10);
            metadata.addGeoDoubleParam(3089, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3088, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
    }

    private void parseGeoGCS(DefaultGeographicCRS geographicCRS, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(geographicCRS);
        if (code != -1) {
            metadata.addGeoShortParam(2048, code);
            return;
        }
        metadata.addGeoShortParam(2048, Short.MAX_VALUE);
        metadata.addGeoAscii(2049, geographicCRS.getName().getCode());
        DefaultGeodeticDatum datum = (DefaultGeodeticDatum)geographicCRS.getDatum();
        this.parseDatum(datum, metadata);
        Unit angularUnit = geographicCRS.getCoordinateSystem().getAxis(0).getUnit();
        this.parseUnit(angularUnit, 0, metadata);
        this.parsePrimem((DefaultPrimeMeridian)datum.getPrimeMeridian(), metadata);
    }

    private void parseDatum(DefaultGeodeticDatum datum, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(datum);
        if (code != -1) {
            metadata.addGeoShortParam(2050, code);
            return;
        }
        metadata.addGeoShortParam(2050, Short.MAX_VALUE);
        this.parseSpheroid((DefaultEllipsoid)datum.getEllipsoid(), metadata);
    }

    private void parseSpheroid(DefaultEllipsoid ellipsoid, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(ellipsoid);
        if (code != -1) {
            metadata.addGeoShortParam(2056, code);
            return;
        }
        metadata.addGeoShortParam(2056, Short.MAX_VALUE);
        metadata.addGeoDoubleParam(2057, ellipsoid.getSemiMajorAxis());
        metadata.addGeoDoubleParam(2059, ellipsoid.getInverseFlattening());
    }

    private void parsePrimem(DefaultPrimeMeridian pm, GeoTiffIIOMetadataEncoder metadata) {
        int numCode = CRS2GeoTiffMetadataAdapter.getEPSGCode(pm);
        if (numCode > 0) {
            metadata.addGeoShortParam(2051, numCode);
        } else {
            metadata.addGeoShortParam(2051, Short.MAX_VALUE);
            metadata.addGeoDoubleParam(2061, pm.getGreenwichLongitude());
        }
    }

    private void parseUnit(Unit unit, int model, GeoTiffIIOMetadataEncoder metadata) {
        metadata.addGeoShortParam(model == 0 ? 2054 : 3076, Short.MAX_VALUE);
        Unit base = null;
        if (SI.METER.isCompatible(unit)) {
            base = SI.METER;
        } else if (SI.SECOND.isCompatible(unit)) {
            base = SI.SECOND;
        } else if (SI.RADIAN.isCompatible(unit) && !Unit.ONE.equals((Object)unit)) {
            base = SI.RADIAN;
        }
        if (base != null) {
            metadata.addGeoDoubleParam(model == 0 ? 2055 : 2053, unit.getConverterTo(base).convert(1.0));
        } else {
            metadata.addGeoDoubleParam(model == 0 ? 2055 : 2053, 1.0);
        }
    }
}

