/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl.jxpath;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.xml.impl.jxpath.FeatureTypeAttributeIterator;
import org.geotools.xml.impl.jxpath.SingleFeatureTypeAttributeIterator;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypePointer
extends NodePointer {
    QName name;
    SimpleFeatureType featureType;

    protected FeatureTypePointer(NodePointer parent, SimpleFeatureType featureType, QName name) {
        super(parent);
        this.name = name;
        this.featureType = featureType;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isCollection() {
        return true;
    }

    public int getLength() {
        return this.featureType.getAttributeCount();
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getImmediateNode() {
        return this.featureType;
    }

    public void setValue(Object value) {
        this.featureType = (SimpleFeatureType)value;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodeTypeTest nodeTypeTest;
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            if (!nodeNameTest.isWildcard()) {
                int index = this.featureType.indexOf(nodeNameTest.getNodeName().getName());
                if (index > -1) {
                    return new SingleFeatureTypeAttributeIterator(this, index);
                }
            } else {
                return new FeatureTypeAttributeIterator(this);
            }
        }
        if (test instanceof NodeTypeTest && (nodeTypeTest = (NodeTypeTest)test).getNodeType() == 1) {
            return new FeatureTypeAttributeIterator(this);
        }
        return super.childIterator(test, reverse, startWith);
    }
}

