/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows10.Ows10Factory;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.PropertyTypePropertyExtractor;
import org.geoserver.wfs.xml.WFSHandlerFactory;
import org.geoserver.wfs.xml.gml3.AbstractGeometryTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.AllSomeTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.DeleteElementTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.DescribeFeatureTypeTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.EmptyTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.FeatureCollectionTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.FeaturesLockedTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.FeaturesNotLockedTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.GMLAbstractFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.GetCapabilitiesTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.GetFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.GetFeatureWithLockTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.InsertElementTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.InsertResultTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.LockFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.LockTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.NativeTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.PropertyTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.QueryTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.StatusTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.TransactionResultTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.TransactionTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.UpdateElementTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.WFS;
import org.geoserver.wfs.xml.v1_0_0.WFS_LockFeatureResponseTypeBinding;
import org.geoserver.wfs.xml.v1_0_0.WFS_TransactionResponseTypeBinding;
import org.geotools.data.DataAccess;
import org.geotools.filter.v1_0.OGCBBOXTypeBinding;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.filter.v1_1.OGC;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.OptionalComponentParameter;
import org.geotools.xml.XSD;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.SetterInjectionComponentAdapter;

public class WFSConfiguration
extends Configuration {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    Catalog catalog;
    FeatureTypeSchemaBuilder schemaBuilder;

    public WFSConfiguration(Catalog catalog, FeatureTypeSchemaBuilder schemaBuilder, final WFS wfs) {
        super((XSD)wfs);
        this.catalog = catalog;
        this.schemaBuilder = schemaBuilder;
        catalog.addListener(new CatalogListener(){

            public void handleAddEvent(CatalogAddEvent event) {
                if (event.getSource() instanceof FeatureTypeInfo) {
                    this.reloaded();
                }
            }

            public void handleModifyEvent(CatalogModifyEvent event) {
                if (event.getSource() instanceof DataStoreInfo || event.getSource() instanceof FeatureTypeInfo || event.getSource() instanceof NamespaceInfo) {
                    this.reloaded();
                }
            }

            public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            }

            public void handleRemoveEvent(CatalogRemoveEvent event) {
            }

            public void reloaded() {
                wfs.flush();
            }
        });
        catalog.getResourcePool().addListener(new ResourcePool.Listener(){

            public void disposed(FeatureTypeInfo featureType, FeatureType ft) {
            }

            public void disposed(CoverageStoreInfo coverageStore, GridCoverageReader gcr) {
            }

            public void disposed(DataStoreInfo dataStore, DataAccess da) {
                wfs.flush();
            }
        });
        this.addDependency((Configuration)new OGCConfiguration());
        this.addDependency((Configuration)new GMLConfiguration());
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    protected void registerBindings(MutablePicoContainer container) {
        container.registerComponentImplementation((Object)WFS.ALLSOMETYPE, AllSomeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DELETEELEMENTTYPE, DeleteElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DESCRIBEFEATURETYPETYPE, DescribeFeatureTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.EMPTYTYPE, EmptyTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURECOLLECTIONTYPE, FeatureCollectionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESLOCKEDTYPE, FeaturesLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESNOTLOCKEDTYPE, FeaturesNotLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETCAPABILITIESTYPE, GetCapabilitiesTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATURETYPE, GetFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATUREWITHLOCKTYPE, GetFeatureWithLockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTELEMENTTYPE, InsertElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTRESULTTYPE, InsertResultTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKFEATURETYPE, LockFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKTYPE, LockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.NATIVETYPE, NativeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.PROPERTYTYPE, PropertyTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.QUERYTYPE, QueryTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.STATUSTYPE, StatusTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONRESULTTYPE, TransactionResultTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONTYPE, TransactionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.UPDATEELEMENTTYPE, UpdateElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.WFS_LOCKFEATURERESPONSETYPE, WFS_LockFeatureResponseTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.WFS_TRANSACTIONRESPONSETYPE, WFS_TransactionResponseTypeBinding.class);
    }

    public void configureContext(MutablePicoContainer context) {
        super.configureContext(context);
        context.registerComponentInstance((Object)Ows10Factory.eINSTANCE);
        context.registerComponentInstance((Object)WfsFactory.eINSTANCE);
        context.registerComponentInstance((Object)new WFSHandlerFactory(this.catalog, this.schemaBuilder));
        context.registerComponentInstance((Object)this.catalog);
        context.registerComponentImplementation(PropertyTypePropertyExtractor.class);
        FeatureTypeCache featureTypeCache = (FeatureTypeCache)context.getComponentInstanceOfType(FeatureTypeCache.class);
        List featureTypes = this.catalog.getFeatureTypes();
        for (FeatureTypeInfo meta : featureTypes) {
            if (!meta.enabled()) continue;
            FeatureType featureType = null;
            try {
                featureType = meta.getFeatureType();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not load underlying feature type for type " + meta.getName(), e);
                continue;
            }
            featureTypeCache.put(featureType);
        }
    }

    protected void configureBindings(Map bindings) {
        bindings.put(GML.AbstractFeatureType, GMLAbstractFeatureTypeBinding.class);
        bindings.put(GML.AbstractGeometryType, new SetterInjectionComponentAdapter((Object)GML.AbstractGeometryType, AbstractGeometryTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class)}));
        bindings.put(OGC.BBOXType, new SetterInjectionComponentAdapter((Object)OGC.BBOXType, OGCBBOXTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class)}));
    }
}

