/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadDescriptorMT;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverageio.GridCoverageUtilities;
import org.geotools.coverageio.RasterLayerRequest;
import org.geotools.coverageio.RasterLayerResponse;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.PrjFileReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class BaseGridCoverage2DReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER;
    private final String worldFileExt;
    private final ImageReaderSpi readerSPI;
    private GeneralEnvelope nativeEnvelope = null;
    private CoordinateReferenceSystem nativeCRS = null;
    private File inputFile = null;
    private String coverageName = "geotools_coverage";
    private GridEnvelope2D nativeGridRange = null;
    private String parentPath;
    private ServiceInfo serviceInfo;
    private ResourceInfo resourceInfo;

    protected abstract void setCoverageProperties(ImageReader var1) throws IOException;

    protected BaseGridCoverage2DReader(Object input, Hints hints, String worldFileExtension, ImageReaderSpi formatSpecificSpi) throws DataSourceException {
        ImageReader reader = null;
        try {
            if (this.hints == null) {
                this.hints = new Hints();
            }
            if (hints != null) {
                this.hints.add((RenderingHints)hints);
            }
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
            this.readerSPI = formatSpecificSpi;
            this.worldFileExt = worldFileExtension;
            this.checkSource(input);
            reader = this.readerSPI.createReaderInstance();
            reader.setInput(this.inputFile);
            this.setCoverageProperties(reader);
            this.getResolutionInfo(reader);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException(e);
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException(e);
        }
        finally {
            block21: {
                if (reader != null) {
                    block20: {
                        try {
                            reader.reset();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block20;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        reader.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block21;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    Hints getHints() {
        return this.hints;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    private void checkSource(Object input) throws UnsupportedEncodingException, DataSourceException, IOException, FileNotFoundException {
        File sourceFile;
        if (input == null) {
            IllegalArgumentException ex = new IllegalArgumentException("No source set to read this coverage.");
            throw ex;
        }
        this.source = null;
        if (input instanceof URL) {
            URL sourceURL = (URL)input;
            this.source = sourceURL;
            if (sourceURL.getProtocol().compareToIgnoreCase("file") == 0) {
                this.inputFile = DataUtilities.urlToFile((URL)sourceURL);
                input = this.inputFile;
            } else {
                throw new IllegalArgumentException("Unsupported input type");
            }
        }
        if (input instanceof FileImageInputStreamExt) {
            if (this.source == null) {
                this.source = input;
            }
            this.inputFile = ((FileImageInputStreamExt)input).getFile();
            input = this.inputFile;
        }
        if (input instanceof File) {
            sourceFile = (File)input;
            if (this.source == null) {
                this.source = sourceFile;
            }
            if (this.inputFile == null) {
                this.inputFile = sourceFile;
            }
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        this.parentPath = sourceFile.getParent();
        this.coverageName = sourceFile.getName();
        int dotIndex = this.coverageName.lastIndexOf(".");
        this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle originalDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        if (this.getCoverageGridRange() == null) {
            this.setCoverageGridRange(new GridEnvelope2D(originalDim));
        }
        this.highestRes = CoverageUtilities.getResolution((AffineTransform)this.raster2Model);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest Resolution = [").append(this.highestRes[0]).append(",").append(this.highestRes[1]).toString());
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        RasterLayerResponse response = this.requestCoverage(request);
        if (response != null) {
            return (GridCoverage2D)response.getGridCoverage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePRJFile() {
        String prjPath = null;
        this.setCoverageCRS(null);
        prjPath = this.parentPath + File.separatorChar + this.coverageName + ".prj";
        PrjFileReader projReader = null;
        try {
            File prj = new File(prjPath);
            if (prj.exists()) {
                projReader = new PrjFileReader((ReadableByteChannel)new FileInputStream(prj).getChannel());
                this.setCoverageCRS(projReader.getCoordinateReferenceSystem());
            }
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        catch (FactoryException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        finally {
            block25: {
                if (projReader != null) {
                    try {
                        projReader.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block25;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    protected void parseWorldFile() {
        block9: {
            String worldFilePath = new StringBuffer(this.parentPath).append(GridCoverageUtilities.SEPARATOR).append(this.coverageName).toString();
            File file2Parse = null;
            boolean worldFileExists = false;
            if (this.worldFileExt != null && this.worldFileExt.length() > 0) {
                file2Parse = new File(worldFilePath + this.worldFileExt);
                worldFileExists = file2Parse.exists();
            }
            if (!worldFileExists) {
                file2Parse = new File(worldFilePath + ".wld");
                worldFileExists = file2Parse.exists();
            }
            if (worldFileExists) {
                try {
                    WorldFileReader reader = new WorldFileReader(file2Parse);
                    this.raster2Model = reader.getTransform();
                    MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                    GeneralEnvelope gridRange = new GeneralEnvelope((Rectangle2D)this.getCoverageGridRange());
                    GeneralEnvelope coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                    this.setCoverageEnvelope(coverageEnvelope);
                    return;
                }
                catch (TransformException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IllegalStateException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block9;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        this.raster2Model = null;
    }

    public synchronized ServiceInfo getInfo() {
        if (this.serviceInfo != null) {
            return new DefaultServiceInfo(this.serviceInfo);
        }
        DefaultServiceInfo localInfo = new DefaultServiceInfo();
        this.serviceInfo = localInfo;
        localInfo.setDescription(this.source.toString());
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            localInfo.setTitle(url.getFile());
            try {
                localInfo.setSource(url.toURI());
            }
            catch (URISyntaxException e) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                localInfo.setTitle(file.getName());
            }
            localInfo.setSource(file.toURI());
        }
        return new DefaultServiceInfo((ServiceInfo)localInfo);
    }

    public synchronized ResourceInfo getInfo(String subname) {
        if (this.resourceInfo != null) {
            return new DefaultResourceInfo(this.resourceInfo);
        }
        DefaultResourceInfo localInfo = new DefaultResourceInfo();
        this.resourceInfo = localInfo;
        localInfo.setName(subname);
        localInfo.setBounds(new ReferencedEnvelope((Envelope)this.getOriginalEnvelope()));
        localInfo.setCRS(this.getCrs());
        localInfo.setTitle(subname);
        return new DefaultResourceInfo(this.resourceInfo);
    }

    private RasterLayerResponse requestCoverage(RasterLayerRequest request) {
        RasterLayerResponse response = new RasterLayerResponse(request, this.coverageFactory, this.readerSPI);
        try {
            response.compute();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        return response;
    }

    protected void setCoverageCRS(CoordinateReferenceSystem coverageCRS) {
        this.nativeCRS = coverageCRS;
    }

    protected CoordinateReferenceSystem getCoverageCRS() {
        return this.nativeCRS;
    }

    protected void setCoverageEnvelope(GeneralEnvelope coverageEnvelope) {
        this.nativeEnvelope = coverageEnvelope;
    }

    protected GeneralEnvelope getCoverageEnvelope() {
        return this.nativeEnvelope;
    }

    protected void setCoverageGridRange(GridEnvelope2D coverageGridRange) {
        this.nativeGridRange = coverageGridRange;
    }

    protected GridEnvelope2D getCoverageGridRange() {
        return this.nativeGridRange;
    }

    protected File getInputFile() {
        return this.inputFile;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public boolean hasMoreGridCoverages() {
        return false;
    }

    static {
        block2: {
            LOGGER = Logging.getLogger((String)"org.geotools.coverageio.gdal");
            try {
                ImageReadDescriptorMT.register((JAI)JAI.getDefaultInstance());
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }
}

