/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadInfo;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest;
import org.apache.wicket.markup.html.DynamicWebResource;
import org.apache.wicket.protocol.http.WebRequest;

class UploadStatusResource
extends DynamicWebResource {
    private static final long serialVersionUID = 1L;

    UploadStatusResource() {
    }

    protected DynamicWebResource.ResourceState getResourceState() {
        return new UploadResourceState();
    }

    private static class UploadResourceState
    extends DynamicWebResource.ResourceState {
        private String status;

        public UploadResourceState() {
            RequestCycle rc = RequestCycle.get();
            HttpServletRequest req = ((WebRequest)rc.getRequest()).getHttpServletRequest();
            UploadInfo info = UploadWebRequest.getUploadInfo(req);
            this.status = info == null || info.getTotalBytes() < 1L ? "0|0|0|0" : "" + info.getPercentageComplete() + "|" + info.getBytesUploadedString() + "|" + info.getTotalBytesString() + "|" + info.getTransferRateString() + "|" + info.getRemainingTimeString();
            this.status = "<html>|" + this.status + "|</html>";
        }

        public String getContentType() {
            return "text/plain";
        }

        public int getLength() {
            return this.status.length();
        }

        public byte[] getData() {
            return this.status.getBytes();
        }
    }
}

