/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.Map;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefiningConversion
extends DefaultConversion {
    private static final long serialVersionUID = 7399026512478064721L;
    private final ParameterValueGroup parameters;

    public DefiningConversion(String name, ParameterValueGroup parameters) {
        this(Collections.singletonMap("name", name), DefiningConversion.getOperationMethod(parameters), parameters);
    }

    private static OperationMethod getOperationMethod(ParameterValueGroup parameters) {
        DefiningConversion.ensureNonNull("parameters", parameters);
        ParameterDescriptorGroup descriptor = parameters.getDescriptor();
        return new DefaultOperationMethod(DefiningConversion.getProperties((IdentifiedObject)descriptor, null), 2, 2, descriptor);
    }

    public DefiningConversion(Map<String, ?> properties, OperationMethod method, ParameterValueGroup parameters) {
        super(properties, null, null, null, method);
        DefiningConversion.ensureNonNull("parameters", parameters);
        this.parameters = parameters.clone();
    }

    public DefiningConversion(Map<String, ?> properties, OperationMethod method, MathTransform transform) {
        super(properties, null, null, transform, method);
        this.parameters = null;
    }

    @Override
    void validate() throws IllegalArgumentException {
        if (this.transform == null) {
            super.validate();
        }
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters.clone() : super.getParameterValues();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        String name = super.formatWKT(formatter);
        formatter.append((GeneralParameterValue)this.parameters);
        return name;
    }
}

