/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.calldecorator;

import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPostprocessingCallDecorator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public final class AjaxCallThrottlingDecorator
extends AjaxPostprocessingCallDecorator {
    private static final long serialVersionUID = 1L;
    private final Duration duration;
    private final String id;

    public AjaxCallThrottlingDecorator(String id, Duration delay) {
        this(null, id, delay);
    }

    public AjaxCallThrottlingDecorator(IAjaxCallDecorator decorator, String id, Duration delay) {
        super(decorator);
        if (Strings.isEmpty(id)) {
            throw new IllegalArgumentException("id cannot be an empty string");
        }
        this.id = id;
        this.duration = delay;
    }

    public final CharSequence postDecorateScript(CharSequence script) {
        return AbstractDefaultAjaxBehavior.throttleScript(script, this.id, this.duration);
    }
}

