/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;

public class CompoundAuthorizationStrategy
implements IAuthorizationStrategy {
    private final ArrayList strategies = new ArrayList();

    public final void add(IAuthorizationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy argument cannot be null");
        }
        this.strategies.add(strategy);
    }

    public final boolean isInstantiationAuthorized(Class componentClass) {
        int size = this.strategies.size();
        for (int i = 0; i < size; ++i) {
            IAuthorizationStrategy strategy = (IAuthorizationStrategy)this.strategies.get(i);
            if (strategy.isInstantiationAuthorized(componentClass)) continue;
            return false;
        }
        return true;
    }

    public final boolean isActionAuthorized(Component component, Action action) {
        int size = this.strategies.size();
        for (int i = 0; i < size; ++i) {
            IAuthorizationStrategy strategy = (IAuthorizationStrategy)this.strategies.get(i);
            if (strategy.isActionAuthorized(component, action)) continue;
            return false;
        }
        return true;
    }
}

